<?php
$lang['admin']['pagedefaultsupdated'] = 'Paginastandaarden bijgewerkt';
$lang['admin']['help_function_module_available'] = '<h3>What does this do? </h3>
<p>A plugin to test wether a given module (by name) is installed, and available for use.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><strong>(required)module</strong> - (string) The name of the module.</li>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul>
<h3>Example:</h3>
{module_available module=&#039;News&#039; assign=&#039;havenews&#039;}{if $havenews}{cms_module module=News}{/if}
<h3>Note:</h3>
<p>You cannot use the short form of the module call, i.e: <em>{News}</em> in this type of expression.</p>';
$lang['admin']['prettyurls_noeffect'] = 'Pretty URL&#039;s zijn niet geconfigureerd. Deze URL heeft geen effect.';
$lang['admin']['help_function_cms_lang_info'] = '<h3>What does this do?</h3>
<p>This plugin returns an object containing the information that CMSMS has about the selected language.  This can include locale information, encodings, language aliases etc.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><em>(optional)lang</em> - The language to return information for.  If the lang parameter is not specified then the information for the current CMSMS language is used.</li>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul>
<h3>Example:</h3>
<pre>{cms_lang_info assign=&#039;nls&#039;}{$nls->locale()}</pre>
<h3>See Also:</h3>
<p>the CmsNls class documentation.</p>';
$lang['admin']['help_function_cms_set_language'] = '<h3>What does this do?</h3>
<p>This plugin attempts to set the current language for use by translation strings and date formatting to the desired language.  The language specified must be known to CMSMS (The nls file must exist).  When this function is called, (and unless overridden in the config.php) an attempt will be made to set the locale to the local associated with the language.  The locale for the language must be installed on the server.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><strong>(required)lang</em> - The desired language.  The language must be known to the CMSMS installation (nls file must exist).</li>
</ul>';
$lang['admin']['help_function_cms_get_language'] = '<h3>What does this do?</h3>
<p>This plugin returns the current CMSMS language name. The language is used for translation strings and date formatting.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul>';
$lang['admin']['help_modifier_cms_escape'] = '<h3>What does this do?</h3>
<p>This modifier is used to escape the string in one of many ways.  This can be used for converting the string to multiple different display formats, or to make user entered data with special characters displayable on a standard web page.</p>
<h3>Usage:</h3>
<pre><code>{$some_var_with_text|cms_escape[:<escape type>|[<character set>]]}</code></pre>
<h4>Valid escape types:</h4>
<ul>
<li>html <em>(default)</em> - use htmlspecialchars.</li>
<li>htmlall - use htmlentities.</li>
<li>url - raw url encode all entities.</li>
<li>urlpathinfo - Similar to the url escape type, but also encode /.</li>
<li>quotes - Escape unescaped single quotes.</li>
<li>hex - Escape every character into hex.</li>
<li>hexentity - Hex encode every character.</li>
<li>decentity - Decimal encode every character.</li>
<li>javascript - Escape quotes, backslashes, newlines etc.</li>
<li>mail - Encode an email address into something that is safe to display.</li>
<li>nonstd - Escape non standard characters, such as document quotes.</li>
</ul>
<h4>Character Set::</h4>
<p>If the character set is not specified, utf-8 is assumed. The character set is only applicable to the &quot;html&quot; and &quot;htmlall&quot; escape types.</p>';
$lang['admin']['help_modifier_cms_date_format'] = '<h3>What does this do?</h3>
<p>This modifier is used to format dates in a suitable format. It uses the standard strftime parameters. If no format string is specified, the system will use the date format string user preference (for logged in users) or the system date format preference.</p>
<p>This modifier is capable of understanding dates in many formats.  i.e: date-time strings output from the database or integer timestamps generated by the time() function.</p>
<h3>Usage:</h3>
<pre><code>{$some_date_var|cms_date_format[:<format string>]}</code></pre>
<h3>Example:</h3>
<pre><code>{&#039;2012-03-24 22:44:22&#039;|cms_date_format}</code></pre>';
$lang['admin']['help_modifier_summarize'] = '<h3>What does this do?</h3>
<p>This modifier is used to truncate a long sequence of text to a limited number of &quot;words&quot;.</p>
<h3>Usage:</h3>
<pre><code>{$some_var_with_long_text|summarize:<number>}</code></pre>
<h3>Example:</h3>
<p>The following example would strip all html tags from the content and truncate it after 50 words.</p>
<pre><code>{content|strip_tags|summarize:50}</code></pre>';
$lang['admin']['module_param_lang'] = '<strong>Verouderd</strong> - Overschrijf de huidige taal die wordt gebruikt voor het selecteren van vertaalde regels.';
$lang['admin']['server_db_grants'] = 'Controleer toegangsniveau van de database';
$lang['admin']['error_nograntall_found'] = 'Kan geen geldige &quot;GRAND ALL&quot; permissie vinden.  Dit kan problemen opleveren bij het installeren of verwijderen van modules. Of zelfs bij het toevoegen of verwijderen van items, zoals pagina&#039;s.';
$lang['admin']['msg_grantall_found'] = 'Er is een &quot;GRAND ALL&quot; permissie gevonden, alles lijkt in orde.';
$lang['admin']['curlversion'] = 'Test Curl versie';
$lang['admin']['curl'] = 'Test voor de curl bibliotheek';
$lang['admin']['test_curl'] = 'Test voor de beschikbaarheid van Curl';
$lang['admin']['test_curlversion'] = 'Test Curl Versie';
$lang['admin']['curl_versionstr'] = 'versie %s, minimaal aanbevolen versie is %s';
$lang['admin']['lines_in_error'] = '%d regels met fouten';
$lang['admin']['no_files_scanned'] = 'Er zijn geen bestanden gescand tijdens het verificatieproces (misschien is het bestand ongeldig)';
$lang['admin']['stylesheetnotfound'] = 'Stylesheet %d niet gevonden';
$lang['admin']['sysmain_updateurls'] = 'Routes bijwerken';
$lang['admin']['sysmain_confirmupdateurls'] = 'Weet u zeker dat u de database routes wilt bijwerken?';
$lang['admin']['routesrebuilt'] = 'De database routes zijn opnieuw opgebouwd';
$lang['admin']['text_changeowner'] = 'Draag geselecteerde pagina&#039;s over aan een andere gebruiker';
$lang['admin']['changeowner'] = 'Verander gebruiker';
$lang['admin']['xmlreader_class'] = 'Controle voor de XMLReader class';
$lang['admin']['info_smarty_cacheudt'] = 'Indien dit is ingeschakeld zullen user defined tags worden gecached. Dit is handig voor tags die een output van een aantal databasequeries geven. U kunt de caching uitschakelen door de nocache-parameter te gebruiken in de udt aanvraag. Bijvoorbeeld: <code>{myusertag nocache}</code>';
$lang['admin']['prompt_smarty_cacheudt'] = 'Cache UDT aanvragen';
$lang['admin']['always'] = 'Altijd';
$lang['admin']['never'] = 'Nooit';
$lang['admin']['moduledecides'] = 'Module beslist';
$lang['admin']['info_smarty_cachemodules'] = 'Selecteer hoe tags die moduleacties aanroepen in bepaalde sjablonen gecached moeten worden. Indien dit is ingeschakeld zullen alle moduleaanvragen worden gecached. Dit kan een negatief effect hebben op sommige modules of modules met formulieren. <em>(opmerking: u kunt deze instelling overschrijven door de nocache optie, zoals beschreven in de smarty manual, te gebruiken)</em>. Indien dit uitgeschakeld is, dan zal dit een effect hebben op de snelheid van uw website. Indien u er voor kiest om de module te laten beslossen, dan zal caching standaard uit staan. De module kan dit overschrijven en u kunt caching dan alsnog uitschakelen door gebruik te maken van de nocache parameter wanneer u een module aanroept.';
$lang['admin']['prompt_smarty_cachemodules'] = 'Cache module aanvragen';
$lang['admin']['info_smarty_compilecheck'] = 'Indien uitgeschakeld zal de smarty geen controle uitvoeren op aanpassingsdatums van de sjablonen om te zien of deze zijn gewijzigd. Dit kan de snelheid significant verbeteren. Dit kan er wel toe leiden dat een wijziging in het sjabloon (of zelfs sommige inhoudswijzigingen) opschonen van de cache vereisen/';
$lang['admin']['prompt_smarty_compilecheck'] = 'Doe een bundelingscontrole';
$lang['admin']['info_smarty_options'] = 'De volgende opties zijn alleen van toepassing wanneer de bovenstaande cachingopties zijn ingeschakeld';
$lang['admin']['info_smarty_caching'] = 'Indien dit is ingeschakeld zullen de outputs van verschillende plugins worden gecached om zo de snelheid van de site verhogen. Dit is alleen van toepassing op een output op een inhoudspagina die cachable is en alleen voor niet-admin gebruikers. Opmerking: deze functionale kan mogelijk interfereren met het gedrag van sommige modules, plugins of plugins die een non-inline formulier gebruiken.';
$lang['admin']['prompt_use_smartycaching'] = 'Schakel smarty caching in';
$lang['admin']['smarty_settings'] = 'Smarty instellingen';
$lang['admin']['help_function_cms_init_editor'] = '<h3>What does this do?</h3>
  <p>This plugin is used to initialize the selected wysiwyg editor for display when wysiwyg functionalities are required for frontend data submission.  This module will find the selected frontend wysiwyg, determine if it has been requested, and if so generate the appropriate html code <em>(usually javascript links)</em> so that the wysiwyg will initialize properly when the page is loaded.  If no wysiwyg editors have been requested for the frontend request this plugin will produce no output.</p>
  <p><strong>Note:</strong> This plugin will work properly given the default configuration of CMSMS.  If you have modified the &quot;process_whole_template&quot; configuration variable from its default value, you may have to adjust the parameters supplied to this plugin.</p>
<h3>How do I use it?</h3>
<p>The first thing you must do is select the frontend WYSIWYG editor to use in the global settings page of the admin console.  Next If you use frontend wysiwyg editors on numerous pages, it may be best to place the {cms_init_editor} plugin directly into your page template.  If you only require the wysiwyg editor to be enabled on a limited amount of pages you may just place it into the &quot;Page Specific Metadata&quot; field in each page.</p>
<h3>What parameters does it take?</h3>
<ul>
<li><em>(optional)wysiwyg</em> - Specify the name of the wysiwyg editor module to initialize.  Use with caution.  If you have a different wysiwyg editor selected in the global settings, this will force the specified  editor to be initialized.</li>
<li><em>(optional)force=0</em> - Normally this plugin will not initialize the specified (or detected) editor if it has not been marked as &quot;active&quot;.  This parameter will override that behavior.  This parameter may be required of the &quot;process_whole_template&quot; configuration variable is set to a non default value.</li>
<li><em>(optional)assign</em> - Assign the output of the plugin to the named smarty variable.</li>
</ul> ';
$lang['admin']['info_pagedefaults'] = 'Dit formulier staat toe enkele opties in te stellen die standaard worden gebruikt bij het maken van nieuwe pagina&#039;s. De instellingen op de pagina hebben geen effect op het bewerken van bestaande pagina&#039;s';
$lang['admin']['default_contenttype'] = 'Standaard inhoudstype';
$lang['admin']['info_default_contenttype'] = 'Van toepassing bij het toevoegen van nieuwe inhoudsobjecten, deze instelling bepaald het type dat standaard wordt geselecteerd. Controleer of het geselecteerde item niet voorkomt op de lijst met niet-toegestane inhoudstypen';
$lang['admin']['error_contenttype'] = 'Het inhoudstype dat is geassocieerd met deze pagina is ongeldig of niet toegestaan';
$lang['admin']['info_disallowed_contenttypes'] = 'Selecteer welke inhoudstypen verwijderd moeten worden uit de keuzelijst met inhoudstypen bij het bewerken of toevoegen van pagina&#039;s. Gebruikt CTRL + klik om items te selecteren of te deselecteren. Als u geen items heeft geselecteerd dan zijn alle inhoudstypen toegestaan. <em>(van toepassing op alle gebuikers)</em>';
$lang['admin']['disallowed_contenttypes'] = 'Inhoudstypen die niet zijn toegestaan';
$lang['admin']['search_module'] = 'Zoek module';
$lang['admin']['info_search_module'] = 'Selecteer de module die gebruikt moet worden voor het indexeren van woorden voor zoekacties en de zoekfunctionaliteit op de site gaat verzorgen';
$lang['admin']['filecreatedirbadchars'] = 'Er staan niet-toegestane karakters in de opgegeven directory naam';
$lang['admin']['modulehelp_yourlang'] = 'Bekijk de Nederlandstalige versie';
$lang['admin']['info_umask'] = 'De &quot;umask&quot; is een octale waarde die aangeeft wat de standaard rechten zijn voor nieuwe bestanden (dit is voor bestanden in de cache en ge&uuml;ploade bestanden).  Zie voor meer informatie het volgende <a href="http://en.wikipedia.org/wiki/Umask">wikipedia artikel.</a>';
$lang['admin']['general_operation_settings'] = 'Algemene instellingen';
$lang['admin']['info_checkversion'] = 'Als dit is ingeschakeld zal er dagelijks een controle voor een nieuwe versie van CMSMS worden uitgevoerd';
$lang['admin']['checkversion'] = 'Sta toe dat er periodiek controles worden uitgevoerd naar nieuwe CMSMS versies';
$lang['admin']['actioncontains'] = 'Bewerking bevat';
$lang['admin']['filterapplied'] = 'Huidig Filter';
$lang['admin']['automatedtask_success'] = 'Geautomatiseerde taak is uitgevoerd';
$lang['admin']['siteprefsupdated'] = 'Website-instellingen zijn bijgewerkt';
$lang['admin']['ip_addr'] = 'IP-adres';
$lang['admin']['warn_admin_ipandcookies'] = 'Waarschuwing: Alle beheerhandelingen gebruiken cookies en registreren uw IP-adres!';
$lang['admin']['event_desc_loginfailed'] = 'Aanmelden mislukt';
$lang['admin']['event_help_loginfailed'] = '<p>Een tag die wordt aangeroepen nadat een gebruiker tevergeefs heeft geprobeerd in te loggen in het beheerpaneel.</p>';
$lang['admin']['modulehelp_english'] = 'Bekijk de Engelse (originele) versie';
$lang['admin']['nopluginabout'] = 'Er is geen &#039;Over&#039; informatie beschikbaar voor deze plugin';
$lang['admin']['nopluginhelp'] = 'Er is geen &#039;Help&#039; beschikbaar voor deze plugin';
$lang['admin']['moduleupgraded'] = 'Upgrade succesvol uitgevoerd';
$lang['admin']['added_css'] = 'Stylesheet toegevoegd';
$lang['admin']['toggle'] = 'Selecteer';
$lang['admin']['added_group'] = 'Groep toegevoegd';
$lang['admin']['expanded_xml'] = 'Het uitgepakte XML bestand bestaat uit %s %s';
$lang['admin']['installed_mod'] = 'Ge&iuml;nstalleerde versie %s';
$lang['admin']['uninstalled_mod'] = 'Gede&iuml;nstalleerde module %s';
$lang['admin']['upgraded_mod'] = '%s bijgewerkt van versie %s naar %s';
$lang['admin']['edited_gcb'] = 'Bewerk HTML-blok';
$lang['admin']['edited_content'] = 'Bewerk inhoud';
$lang['admin']['added_content'] = 'Inhoud toegevoegd';
$lang['admin']['added_css_association'] = 'Stylesheet-koppeling toegevoegd';
$lang['admin']['deleted_group'] = 'Groep verwijderd';
$lang['admin']['deleted_content'] = 'Inhoud verwijderd';
$lang['admin']['edited_user'] = 'Gebruiker bewerkt';
$lang['admin']['edited_udt'] = 'Gebruikersgedefinieerde tag (UDT) bewerkt';
$lang['admin']['content_copied'] = 'Pagina gekopieerd naar %s';
$lang['admin']['deleted_template'] = 'Sjabloon verwijderd';
$lang['admin']['added_udt'] = 'Gebruikersgedefinieerde tag (UDT) toegevoegd';
$lang['admin']['deleted_udt'] = 'Gebruikersgedefinieerde tag (UDT) verwijderd';
$lang['admin']['added_gcb'] = 'HTML-blok toegevoegd';
$lang['admin']['edited_group'] = 'Groep bewerkt';
$lang['admin']['deleted_css_association'] = 'Stylesheet-koppeling verwijderd';
$lang['admin']['user_logout'] = 'Gebruiker afgemeld';
$lang['admin']['user_login'] = 'Gebruiker aangemeld';
$lang['admin']['login_failed'] = 'Gebruikerslogin mislukt';
$lang['admin']['deleted_css'] = 'Stylesheet verwijderd';
$lang['admin']['uploaded_file'] = 'Bestand ge&uuml;pload';
$lang['admin']['created_directory'] = 'Map aangemaakt';
$lang['admin']['deleted_file'] = 'Bestand verwijderd';
$lang['admin']['deleted_directory'] = 'Map verwijderd';
$lang['admin']['edited_template'] = 'Sjabloon bewerkt';
$lang['admin']['deleted_user'] = 'Gebruiker verwijderd';
$lang['admin']['deleted_module'] = '%s is definitief verwijderd';
$lang['admin']['deleted_gcb'] = 'HTML-blok verwijderd';
$lang['admin']['added_user'] = 'Gebruiker aangemaakt';
$lang['admin']['edited_user_preferences'] = 'Gebruikersvoorkeuren aangepast';
$lang['admin']['added_template'] = 'Sjabloon toegevoegd';
$lang['admin']['event_desc_stylesheetpostcompile'] = 'Een tag die wordt aangeroepen nadat een stylesheet is gegenereerd door smarty';
$lang['admin']['event_desc_stylesheetprecompile'] = 'Een tag die wordt aangeroepen voordat een stylesheet is gegenereerd door smarty';
$lang['admin']['confirm_uploadmodule'] = 'Weet u zeker dat u het geselecteerde XML bestand wilt uploaden? Door het verkeerd uploaden van een module bestand kan de website stoppen met functioneren';
$lang['admin']['error_module_mincmsversion'] = 'Deze module werkt alleen op een nieuwere versie van CMS Made Smple';
$lang['admin']['info_browser_cache_expiry'] = 'Benoem de tijd (in minuten) hoe lang een browser de te bufferen pagina&#039;s mag opslaan. Een 0 invullen zal de functie uitschakelen.';
$lang['admin']['browser_cache_expiry'] = 'Browser Buffer Verloop Periode <em>(minuten)</em>';
$lang['admin']['info_browser_cache'] = 'Alleen te gebruiken bij te bufferen pagina&#039;s. Deze instelling betekent dat de browser webpagina&#039;s voor een bepaalde tijd mag opslaan. Indien ingeschakeld kan het voorkomen dat een terugkomende gebruiker niet direct uw (content)wijzigingen zal zien!';
$lang['admin']['allow_browser_cache'] = 'Browsers mogen pagina&#039;s in de buffer opnemen';
$lang['admin']['server_cache_settings'] = 'Server Buffer Instellingen';
$lang['admin']['browser_cache_settings'] = 'Browser Buffer Instellingen';
$lang['admin']['help_function_browser_lang'] = '<h3>What does this do? </h3>
  <p>This plugin detects and outputs the language that the users browser accepts, and cross references it with a list of allowed languages to determine a language value for the session.</p>
<h3>How do I use it?</h3>
<p>Insert the tag early into your page template <em>(it can go above the <head> section if you want)</em> and provide it the name of the default language, and the accepted languages (only two character language names are accepted), then do something with the result.  i.e:</p>
<pre><code>{browser_lang accept=de,fr,en,es default=en assign=tmp}{session_put var=lang val=$tmp}</code></pre>
<p><em>({session_put} is a plugin provided by the CGSimpleSmarty module)</em></p>
<h3>What Parameters does it Take?</h3>
<ul>
<li><strong>accepted <em>(required)</em></strong><br/> - A comma separated list of two character language names that are accepted.</li>
<li>default<br/>- <em>(optional)</em> A default language to output if no accepted language was supported by the browser.  en is used if no other value is specified.</li>
<li>assign<br/>- <em>(optional)</em> The name of the smarty variable to assign the results to.  If not specified the results of this function are returned.</li>
</ul>';
$lang['admin']['info_target'] = 'Deze optie kan gebruikt worden door de Menu Manager om te bepalen hoe nieuwe schermen worden geopend. Let op, niet alle menu sjablonen ondersteunen deze functie!';
$lang['admin']['close'] = 'Sluit';
$lang['admin']['open'] = ' Open';
$lang['admin']['revert'] = 'Maak alle wijzigingen ongedaan';
$lang['admin']['autoclearcache2'] = 'Verwijder gebufferde bestanden die ouder zijn dan het gespecificeerde aantal dagen';
$lang['admin']['root'] = 'Start';
$lang['admin']['info_content_autocreate_flaturls'] = 'Dit zet alle URL&#039;s naar dezelfde waarde als de pagina alias. Opmerking: de twee waarden zullen niet gesynchroniseerd worden als er een is ingesteld.';
$lang['admin']['content_autocreate_flaturls'] = 'Automatisch aangemaakte URL&#039;s hebben geen hierarchische opbouw (plat)';
$lang['admin']['content_autocreate_urls'] = 'Automatisch pagina URL&#039;s aanmaken';
$lang['admin']['content_mandatory_urls'] = 'Pagina URL&#039;s zijn verplicht';
$lang['admin']['content_imagefield_path'] = 'Pad naar het afbeeldingsveld';
$lang['admin']['info_content_imagefield_path'] = 'Benoem een directory naam of pad die de afbeeldingen bevat voor het afbeeldingsveld in de pagina editor. Relatief aan het afbeelding upload pad.';
$lang['admin']['content_thumbnailfield_path'] = 'Pad voor het miniatuurveld';
$lang['admin']['info_content_thumbnailfield_path'] = 'Benoem een directory naam of pad die de miniaturen bevat voor het miniatuur veld in de pagina editor. Relatief aan het afbeelding upload pad.  Meestal zal deze hetzelfde zijn als bovenstaand pad.';
$lang['admin']['contentimage_path'] = 'Pad voor de {content_image} tag';
$lang['admin']['info_contentimage_path'] = 'Relatief aan het upload pad, Benoem een directory naam of pad die de bestanden voor de {content_image} tag.  Deze waarde wordt gebruikt als standaard voor de dir parameter.';
$lang['admin']['editcontent_settings'] = 'Pagina Mutatie Instellingen';
$lang['admin']['help_page_url'] = 'Benoem een alternatieve URL (relatief aan de root van de website) die gebruikt kan worden om de pagina uniek te benoemen, bijv. pad/naar/mijn-pagina';
$lang['admin']['help_page_alias'] = 'De alias wordt gebruikt als een alternatief voor het pagina id om een pagina uniek te herkennen. De alias moet dus uniek zijn ten opzichte van alle andere pagina&#039;s. Daarnaast wordt de alias gebruikt bij het maken van de URL voor de pagina.';
$lang['admin']['help_page_searchable'] = 'Hiermee bepaald u of deze pagina door de zoek-module ge&iuml;ndexeerd mag worden';
$lang['admin']['help_page_cachable'] = 'Website snelheid kan worden vergroot door zoveel mogelijk pagina te bufferen (in cache opnemen). Hoewel dit niet gebruikt kan worden voor bijvoorbeeld pagina&#039;s die wijzigen per aanroep.';
$lang['admin']['sitedownexcludeadmins'] = 'Ingelogde Administrators uitsluiten';
$lang['admin']['your_ipaddress'] = 'Uw IP-adres op deze computer is';
$lang['admin']['use_wysiwyg'] = 'Gebruik WYSIWYG';
$lang['admin']['contenttype_redirlink'] = 'Externe Link';
$lang['admin']['yes'] = 'Ja';
$lang['admin']['no'] = 'Nee';
$lang['admin']['listcontent_showalias'] = 'Toon de &quot;Alias&quot; Kolom';
$lang['admin']['listcontent_showurl'] = 'Toon de &quot;URL&quot; kolom';
$lang['admin']['listcontent_showtitle'] = 'Toon de Pagina Titel, of de Menu Tekst';
$lang['admin']['listcontent_settings'] = 'Pagina Lijst Instellingen';
$lang['admin']['lctitle_page'] = 'De titel van bestaande pagina&#039;s of andere content items';
$lang['admin']['lctitle_alias'] = 'De alias van een bestaande pagina of een andere content item. Niet alle content items hebben een alias';
$lang['admin']['lctitle_url'] = 'Voorkeur pagina URL, indien ingesteld';
$lang['admin']['lctitle_template'] = 'De gebruikte html-sjabloon. Niet alle content items hebben een sjabloon';
$lang['admin']['lctitle_owner'] = 'De eigenaar van de pagina, of content item';
$lang['admin']['lctitle_active'] = 'Is een pagina, of een andere content item actief? Inactieve pagina&#039;s worden niet op de website getoond.';
$lang['admin']['lctitle_default'] = 'Selecteer de pagina die standaard wordt geopend als de basis website url wordt geopend. Er kan maar &eacute;&eacute;n pagina worden geselecteerd.';
$lang['admin']['lctitle_move'] = 'Hier kun u de volgorde van de pagina&#039;s wijzigen';
$lang['admin']['lctitle_multiselect'] = 'Selecteer alle zichtbare items / Selecteer geen';
$lang['admin']['invalid_url2'] = 'De pagina URL is ongeldig. Het mag alleen alphanummerieke karakters bevatten of - of /. Extenties mogen alleen alphanummerieke karakters zijn en de lengte moet korter zijn dan 5 tekens. Het is ook mogelijk dat de betreffende URL al ergens anders in gebruik is.';
$lang['admin']['page_url'] = 'Pagina URL';
$lang['admin']['runuserplugin'] = 'Gebruikersgedefinieerde tag (UDT) uitvoeren';
$lang['admin']['output'] = 'Resultaat';
$lang['admin']['run'] = 'Uitvoeren';
$lang['admin']['run_udt'] = 'Voer deze gebruikersgedefinieerde tag (UDT) uit';
$lang['admin']['stylesheetcopied'] = 'Stylesheet gekopieerd';
$lang['admin']['templatecopied'] = 'Sjabloon gekopieerd';
$lang['admin']['ecommerce_desc'] = 'Modules voor E-commerce toepassingen';
$lang['admin']['ecommerce'] = 'E-Commerce ';
$lang['admin']['help_function_content_module'] = '<h3>What does this do?</h3>
<p>This content block type allows interfacing with different modules to create different content block types.</p>
<p>Some modules can define content block types for use in module templates.  i.e: The FrontEndUsers module may define a group list content block type.  It will then indicate how you can use the content_module tag to utilize that block type within your templates.</p>
<p><strong>Note:</strong> This block type must be used only with compatible modules.  You should not use this in any way except for as guided by addon modules.</p>';
$lang['admin']['error_parsing_content_blocks'] = 'Er is een fout opgetreden bij het genereren van de pagina opbouw uit het html-sjabloon. (Mogelijk heeft u meerdere {content block=&quot;...&quot;} tags in dit sjabloon met dezelfde naam?)';
$lang['admin']['error_no_default_content_block'] = 'In het toegepaste sjabloon is geen standaard content blok gedetecteerd.  Het is verplicht om in ieder sjabloon een kale {content} tag te hebben. Wijzig dit eerst...';
$lang['admin']['help_function_cms_stylesheet'] = '<h3>What does this do?</h3>
  <p>A replacement for the {stylesheet} tag, this tag provides caching of css files by generating static files in the tmp/cache directory, and smarty processing of the individual stylesheets.</p>
  <p>This plugin retrieves stylesheet information from the system.  By default, it grabs all of the stylesheets attached to the current template in the order specified by the designer, and generates stylesheet tags.</p>
  <p>Generated stylesheets are uniquely named according to the last modification date in the database, and are only generated if the stylesheet has changed.</p>
  <p>This tag is the replacement for the {stylesheet} tag.</p>
  <h3>How do I use it?</h3>
  <p>Just insert the tag into your template/page&#039;s head section like: <code>{cms_stylesheet}</code></p>
  <h3>What parameters does it take?</h3>
  <ul>
  <li><em>(optional)</em>name - Instead of getting all stylesheets for the given page, it will only get one specifically named one, whether it&#039;s attached to the current template or not.</li>
  <li><em>(optional)</em>templateid - If templateid is defined, this will return stylesheets associated with that template instead of the current one.</li>
  <li><em>(optional)</em>media - When used in conjunction with the name parameter this parameter will allow you to override the media type for that stylesheet.  When used in conjunction with the templateid parameter, the media parameter will only output stylesheet tags for those stylesheets that arer marked as compatible with the specified media type.</li>
  </ul>
  <h3>Smarty Processing</h3>
  <p>When generating css files this system passes the stylesheets retrieved from the database through smarty.  The smarty delimiters have been changed from the CMSMS standard { and } to [[ and ]] respectively to ease transition in stylesheets.  This allows creating smarty variables i.e.: [[assign var=&#039;red&#039; value=&#039;#900&#039;]] at the top of the stylesheet, and then using these variables later in the stylesheet, i.e:</p>
<pre>
<code>
h3 .error { color: [[$red]]; }<br/>
</code>
</pre>
<p>Because the cached files are generated in the tmp/cache directory of the CMSMS installation, the CSS relative working directory is not the root of the website.  Therefore any images, or other tags that require a url should use the [[root_url]] tag to force it to be an absolute url. i.e:</p>
<pre>
<code>
h3 .error { background: url([[root_url]]/uploads/images/error_background.gif); }<br/>
</code>
</pre>
<p><strong>Note:</strong> Due to the caching nature of the plugin, smarty variables should be placed at the top of EACH stylesheet that is attached to a template.</p>';
$lang['admin']['pseudocron_granularity'] = 'Geplande taak uitvoering (Cronjobs)';
$lang['admin']['info_pseudocron_granularity'] = 'Deze instellingen bepaald hoe vaak het CMS zal proberen bepaalde ingestelde taken uit te voeren';
$lang['admin']['cron_request'] = 'Ieder verzoek';
$lang['admin']['cron_15m'] = '15 Minuten';
$lang['admin']['cron_30m'] = '30 Minuten';
$lang['admin']['cron_60m'] = '1 Uur';
$lang['admin']['cron_120m'] = '2 Uur';
$lang['admin']['cron_3h'] = '3 Uur';
$lang['admin']['cron_6h'] = '6 Uur';
$lang['admin']['cron_12h'] = '12 Uur';
$lang['admin']['cron_24h'] = '24 Uur';
$lang['admin']['adminlog_1day'] = '1 dag';
$lang['admin']['adminlog_1week'] = '1 week ';
$lang['admin']['adminlog_2weeks'] = '2 weken';
$lang['admin']['adminlog_1month'] = '1 maand';
$lang['admin']['adminlog_3months'] = '3 maanden';
$lang['admin']['adminlog_6months'] = '6 maanden';
$lang['admin']['adminlog_manual'] = 'Handmatig verwijderen';
$lang['admin']['adminlog_lifetime'] = 'Levensduur van de informatie uit het beheerlogboek';
$lang['admin']['info_adminlog_lifetime'] = 'Met deze instelling kunt u bepalen vanaf welk moment de informatie uit het beheerlogboek wordt verwijderd';
$lang['admin']['filteruser'] = 'Gebruikersnaam is';
$lang['admin']['filtername'] = 'Gebeurtenisnaam bevat';
$lang['admin']['filteraction'] = 'Bewerking bevat';
$lang['admin']['filterapply'] = 'Filters toevoegen';
$lang['admin']['filterreset'] = 'Reset filters ';
$lang['admin']['filters'] = 'Filters ';
$lang['admin']['showfilters'] = 'Toon filters';
$lang['admin']['clearcache_taskdescription'] = 'Dagelijks uitvoeren, deze bewerking zal de gebufferde bestanden verwijderen die ouder zijn dan de ingestelde waarde onder Websitebeheer >> Algemene Instellingen';
$lang['admin']['clearcache_taskname'] = 'Leeg buffer (Clear Cache)';
$lang['admin']['info_autoclearcache'] = 'Vul een geheel getal in. Vul 0 in om het automatisch legen van de buffer uit te schakelen';
$lang['admin']['autoclearcache'] = 'Leeg de buffer (Clear Cache) iedere N dagen';
$lang['admin']['listtemplates_pagelimit'] = 'Aantal regels per pagina wanneer de sjablonen worden bekeken';
$lang['admin']['liststylesheets_pagelimit'] = 'Aantal regels per pagina wanneer de stylesheets worden bekeken';
$lang['admin']['listgcbs_pagelimit'] = 'Aantal regels per pagina wanneer de HTML-blokken worden bekeken';
$lang['admin']['insecure'] = 'Onbeveiligd (HTTP)';
$lang['admin']['secure'] = 'Beveiligd (HTTPS)';
$lang['admin']['secure_page'] = 'Gebruik voor deze pagina HTTPS';
$lang['admin']['thumbnail_width'] = 'Miniatuur breedte';
$lang['admin']['thumbnail_height'] = 'Miniatuur hoogte';
$lang['admin']['E_STRICT'] = 'Is E_STRICT uitgeschakeld in error_reporting';
$lang['admin']['test_estrict_failed'] = 'E_STRICT is uitgeschakeld in error_reporting';
$lang['admin']['info_estrict_failed'] = 'Bepaalde functionaliteiten die CMSMS gebruikt, werken niet goed met E_STRICT.  Schakel deze alstublieft uit voordat u verder gaat';
$lang['admin']['E_DEPRECATED'] = 'Is E_DEPRECATED uitgeschakeld in error_reporting';
$lang['admin']['test_edeprecated_failed'] = 'E_DEPRECATED is ingeschakeld';
$lang['admin']['info_edeprecated_failed'] = 'Als E_DEPRECATED is ingeschakeld by error_reporting zullen gebruikers veel waarschuwingsmeldingen krijgen te zien, wat effect heeft op de lay-out en werking van de website';
$lang['admin']['session_use_cookies'] = 'Gebruik sessie-cookies';
$lang['admin']['errorgettingcontent'] = 'Kan geen informatie inzien voor het gespecificeerde content object';
$lang['admin']['errordeletingcontent'] = 'Fout tijdens het verwijderen (Of deze pagina heeft nog onderliggende pagina of het als standaard ingesteld)';
$lang['admin']['invalidemail'] = 'Het ingevoerde e-mail adres is niet correct';
$lang['admin']['info_deletepages'] = 'Opmerking: Als gevolg van rechten-restricties is het mogelijk dat bepaalde, voor verwijdering geselecteerde pagina&#039;s niet worden weergegeven. ';
$lang['admin']['info_pagealias'] = 'Benoem een unieke alias voor deze pagina.';
$lang['admin']['info_autoalias'] = 'Als dit veld leeg is zal er automatisch een alias worden gemaakt.';
$lang['admin']['invalidparent'] = 'U moet een bovenliggende pagina selecteren (neem contact op met uw administrator als u geen pagina ziet).';
$lang['admin']['forgotpwprompt'] = 'Voer uw gebruikersnaam in.<br />Er zal een e-mail met verdere informatie worden verstuurd naar het bij deze naam bekende mailadres';
$lang['admin']['info_basic_attributes'] = 'Dit veld geeft u de mogelijkheid om te specificeren welke inhoudsgegevens gebruikers  zonder de &quot;Wijzig paginastructuur&quot; rechten, mogen wijzigen.';
$lang['admin']['basic_attributes'] = 'Basis Gegevens';
$lang['admin']['no_permission'] = 'U heeft geen toestemming om deze functie uit te voeren.';
$lang['admin']['bulk_success'] = 'De bulk bewerking is succesvol uitgevoerd.';
$lang['admin']['no_bulk_performed'] = 'Geen bulk bewerking uitgevoerd.';
$lang['admin']['info_preview_notice'] = 'Let op: Dit preview venster simuleert een browserscherm, waarin u ook naar andere pagina&#039;s kunnen navigeren.  Maar, als u dat doet, dan kunt u ook onverwachte fouten tegenkomen. <br />
Als u van de huidige pagina weg navigeert en vervolgens weer terugkeert, kan het zijn dat de niet-opgeslagen wijzigingen niet zichtbaar zijn.  Wijzig eerst de pagina in de START tab en refresh deze pagina.<br />
Als u een nieuwe pagina aan de site toevoegd, kunt u hier niet naar terugkeren, u zult deze pagina moeten refreshen.';
$lang['admin']['sitedownexcludes'] = 'Gebruik deze adressen niet voor de &#039;site niet aanwezig&#039; meldingen';
$lang['admin']['info_sitedownexcludes'] = 'Deze parameter kan worden voorzien met een komma-gescheiden lijst van ip adressen of netwerken die geen onderdeel gaan vormen van de &#039;site niet aanwezig&#039; melding.  Hierdoor kan een administrator aan de website werken, terwijl een bezoeker wel een offline melding krijgt.<br/><br />
Adressen kunnen als volgt worden benoemd:<br/>
1. xxx.xxx.xxx.xxx -- (exacte IP adres)<br/>
2. xxx.xxx.xxx.[yyy-zzz] -- (IP adres groep)<br/>
3. xxx.xxx.xxx.xxx/nn -- (nnn = aantal bits, cisco stijl.  bijv.:  192.168.0.100/24 = geheel 192.168.0 class C subnet) ';
$lang['admin']['setup'] = 'Uitgebreide setup';
$lang['admin']['handle_404'] = 'Aangepaste 404 afhandeling';
$lang['admin']['sitedown_settings'] = 'Site niet bereikbaar instellingen';
$lang['admin']['general_settings'] = 'Algemene instellingen';
$lang['admin']['help_function_page_attr'] = '<h3>Wat doet dit?</h3>
<p>Deze tag kan worden gebruikt om de waarde terug te geven van een attribuut van een bepaalde pagina.</p>
<h3>Hoe wordt dit gebruikt?</h3>
<p>Voeg in de template een tag in op deze manier: <code>{page_attr key=&quot;extra1&quot;}</code>.</p>
<h3>Welke parameters accepteert het? </h3>
<ul>
  <li><strong>key [verplicht]</strong> De sleutel om het attribuut terug te geven.</li>
</ul> ';
$lang['admin']['forge'] = 'Forge ';
$lang['admin']['disable_wysiwyg'] = 'WYSIWYG niet toestaan voor deze pagina (ongeacht het sjabloon of gebruikers instellingen).';
$lang['admin']['help_function_page_image'] = '<h3>Wat doet dit?</h3>
<p>Deze tag kan gebruikt worden om een waarde in te vullen om een miniatuur of een afbeelding op een pagina te plaatsen.</p>
<h3>Hoe gebruik ik het?</h3>
<p>Voeg de tag toe in een sjabloon, zoals: <code>{page_image}</code>.</p>
<h3>Welke parameters zijn er?</h3>
<ul>
  <li>thumbnail - Een optie om de waarde van de miniatuur eigenschappen weer te geven in plaats van de afbeelding eigenschappen.</li>
</ul>';
$lang['admin']['pagelink_circular'] = 'Een paginalink kan geen andere paginalink als doel bevatten';
$lang['admin']['destinationnotfound'] = 'De geselecteerde pagina is niet gevonden of is niet aanwezig';
$lang['admin']['help_function_dump'] = '<h3>Wat doet dit? </h3>
  <p>Deze tag kan worden gebruikt om een uitvoer te geven van elke smarty variabele in een wat meer leesbaar formaat. Dit is handig voor fouten zoeken en aanpassen van templates zodat je weet welke formaten en types data beschikbaar zijn.</p>
<h3>Hoe wordt dit gebruikt?</h3>
<p>Voeg de tag in de template in als: <code>{dump item=&#039;the_smarty_variable_to_dump&#039;}</code>.</p>
<h3>Welke parameters accepteert het?</h3>
<ul>
<li><strong>item (verplicht)</strong> - De smarty variabele om de inhoud van te dumpen.</li>
<li>maxlevel - De maximum aantal levels om terug te gaan (alleen toepasbaar als &quot;recurse&quot; wordt aangeleverd). De standaard waarde voor deze parameter is 3</li>
<li>nomethods - Sla de uitvoer over van methoden vanuit objecten.</li>
<li>novars - Sla de uitvoer over van onderdelen van objecten.</li>
<li>recurse - Ga een maximum aantal levels terug door de objecten en geef daarbij zichtbare uitvoer van elk item totdat het maximum aantal levels is bereikt.</li>
</ul>';
$lang['admin']['sqlerror'] = 'SQL fout in %s';
$lang['admin']['image'] = 'Afbeelding';
$lang['admin']['thumbnail'] = 'Miniatuur';
$lang['admin']['searchable'] = 'Deze pagina is doorzoekbaar';
$lang['admin']['help_function_content_image'] = '<h3>Wat doet dit?</h3>
<p>Deze plugin geeft template designers toestemming gebruikers een afbeelding te laten selecteren wanneer ze de inhoud van een pagina aan het bewerken zijn. Het gedraagt zich net als de content plugin voor meerdere content blokken.</p>
<h3>Hoe wordt het gebruikt?</h3>
<p>Voeg de tag in je pagina template op deze manier: <code>{content_image block=&#039;afbeelding1&#039;}</code>.</p>
<h3>Welke parameters gebruikt het?</h3>
<ul>
  <li><strong>(verplicht)</strong> block - De naam voor dit toegevoegde gegevens blok.
  <p>Voorbeeld:</p>
  <pre>{content_image block=&#039;afbeelding1&#039;}</pre><br/>
  </li>

  <li><em>(optioneel)</em> label - Een etiket of herinnering voor dit gegevens blok in de bewerk pagina. Indien dit niet is aangegeven wordt de naam van het gegevens blok gebruikt.</li>
 
  <li><em>(optioneel)</em> dir - De naam van de map (relatief ten opzichte van de uploads map, van waaruit afbeeldingen geselecteerd worden. Wanneer dit niet is gespecificeerd wordt de upload map gebruikt.
  <p>Voorbeeld: gebruik de afbeeldingen uit: uploads/images map.</p>
  <pre>{content_image block=&#039;afbeelding1&#039; dir=&#039;images&#039;}</pre><br/>
  </li>

  <li><em>(optioneel)</em> class - De css-class naam welke wordt gebruikt door de img tag in de weergave.</li>

  <li><em>(optioneel)</em> id - De id naam welke wordt gebruikt door de img tag in de weergave.</li> 

  <li><em>(optioneel)</em> name - De tag naam welke wordt gebruikt door de img tag in de weergave.</li> 

  <li><em>(optioneel)</em> width - De gewenste breedte van de afbeelding.</li>

  <li><em>(optioneel)</em> height - De gewenste hoogte van de afbeelding.</li>

  <li><em>(optioneel)</em> alt - Alternatieve tekst wanneer de afbeelding niet gevonden kan worden.</li>
  <li><em>(optioneel)</em> urlonly - Geeft alleen de url naar de afbeelding weer en negeerd alle parameters zoals id, name, width, height, etc.</li>
</ul>';
$lang['admin']['error_udt_name_chars'] = 'Een geldige UDT naam begint met een letter of een underscore, gevolgd door verschillende nummers, letters of underscores.';
$lang['admin']['errorupdatetemplateallpages'] = 'Sjabloon is niet actief';
$lang['admin']['hidefrommenu'] = 'Verberg in menu';
$lang['admin']['settemplate'] = 'Koppel sjabloon';
$lang['admin']['text_settemplate'] = 'Koppel geselecteerde paginas aan een andere template';
$lang['admin']['cachable'] = 'Kan in buffer opgenomen worden';
$lang['admin']['noncachable'] = 'Niet in de buffer opnemen';
$lang['admin']['copy_from'] = 'Kopieer van';
$lang['admin']['copy_to'] = 'Kopieer naar';
$lang['admin']['copycontent'] = 'Kopieer Inhoudsartikel';
$lang['admin']['md5_function'] = 'md5 functie';
$lang['admin']['tempnam_function'] = 'tempnam functie';
$lang['admin']['register_globals'] = 'PHP register_globals ';
$lang['admin']['output_buffering'] = 'PHP output_buffering ';
$lang['admin']['disable_functions'] = 'disable_functions in PHP ';
$lang['admin']['xml_function'] = 'Basis XML (expat) ondersteuning';
$lang['admin']['magic_quotes_gpc'] = 'Magic quotes voor Get/Post/Cookie bewerkingen';
$lang['admin']['magic_quotes_gpc_on'] = 'Enkele aanhalingstekens, dubbele aanhalingstekens en backslashes worden automatisch verwijderd. U kunt daardoor problemen krijgen bij het opslaan van sjablonen.';
$lang['admin']['magic_quotes_runtime'] = 'Er bevinden magic quotes in de runtime';
$lang['admin']['magic_quotes_runtime_on'] = 'De meeste functies die data terugsturen, maken gebruik van aanhalingstekens, die worden vervangen door een backslash. Dit kan problemen veroorzaken.';
$lang['admin']['file_get_contents'] = 'Controleer file_get_contents';
$lang['admin']['check_ini_set'] = 'Controleer ini_set';
$lang['admin']['check_ini_set_off'] = 'U kunt problemen hebben met bepaalde functionaliteit zonder deze mogelijkheid. Deze test kan mislukken als safe_mode is ingeschakeld';
$lang['admin']['file_uploads'] = 'Bestand uploads';
$lang['admin']['test_remote_url'] = 'Testen van externe URL';
$lang['admin']['test_remote_url_failed'] = 'U bent misschien niet gemachtigd om bestanden te openen op een externe server.';
$lang['admin']['test_allow_url_fopen_failed'] = 'Wanneer allow url-fopen is uitgeschakeld, zult u niet in staat zijn om toegang te krijgen tot URL-objecten, zoals bestanden met behulp van het FTP-of HTTP-protocol.';
$lang['admin']['connection_error'] = 'Uitgaande http connecties, lijken niet te werken! Er is een firewall of ACL voor de externe aansluitingen? Dit zal resulteren in het niet werken van module manager, en mogelijk ook andere functies.';
$lang['admin']['remote_connection_timeout'] = 'Verbinden duurde te lang!';
$lang['admin']['search_string_find'] = 'Verbinden geslaagd!';
$lang['admin']['connection_failed'] = 'Verbinden mislukt!';
$lang['admin']['remote_response_ok'] = 'Extern antwoord: OK!';
$lang['admin']['remote_response_404'] = 'Extern antwoord: Niet gevonden.';
$lang['admin']['remote_response_error'] = 'Extern antwoord: Fout!';
$lang['admin']['notifications_to_handle'] = 'U heeft <b>%d</b> onbehandelde berichten.';
$lang['admin']['notification_to_handle'] = 'U heeft <b>%d</b> onbehandeld bericht.';
$lang['admin']['notifications'] = 'Berichten';
$lang['admin']['dashboard'] = 'Geef Dashboard weer';
$lang['admin']['ignorenotificationsfrommodules'] = 'Negeer berichten van deze modules';
$lang['admin']['admin_enablenotifications'] = 'Sta gebruikers het weergeven van berichten toe<br/><em>(de berichten worden weergegeven op alle administrator-pagina&#039;s.)</em>';
$lang['admin']['enablenotifications'] = 'Schakel gebruikersmededelingen in voor de administratorpagina&#039;s';
$lang['admin']['test_check_open_basedir_failed'] = 'Open basedir restricties zijn in werking. U kunt problemen ondervinden met sommige aanvullende modules ';
$lang['admin']['config_writable'] = 'config.php is beschrijfbaar! Het is veiliger om dit in te stellen als &#039;alleen-lezen&#039; (chmod 444).';
$lang['admin']['caution'] = 'Let op';
$lang['admin']['create_dir_and_file'] = 'Controle of het httpd proces een bestand in de aangemaakte directory kan maken';
$lang['admin']['os_session_save_path'] = 'Geen controle door het &#039;OS pad&#039;';
$lang['admin']['unlimited'] = 'Ongelimiteerd';
$lang['admin']['open_basedir'] = 'PHP Open Basedir ';
$lang['admin']['open_basedir_active'] = 'Geen controle omdat &#039;open_basedir&#039; actief is';
$lang['admin']['invalid'] = 'Ongeldig';
$lang['admin']['checksum_passed'] = 'Alle checksums komen overeen met het opgegeven bestand';
$lang['admin']['error_retrieving_file_list'] = 'Fout bij ophalen bestandslijst';
$lang['admin']['files_checksum_failed'] = 'Niet mogelijk checksum te maken voor bestanden';
$lang['admin']['failure'] = 'Fout';
$lang['admin']['help_function_process_pagedata'] = '<h3>Wat doet dit?</h3>
<p>Deze plugin verwerkt de data in het &amp;quot;pagedata&amp;quot; blok van de inhoud pagina&#039;s door middel van smarty.  Hierdoor kun je specifieke pagina data specificeren in een smarty zonder dat de template voor elke pagina aangepast moet worden.</p>
<h3>Hoe word het gebruikt?</h3>
<ol>
  <li>Voeg smarty variabelen en andere smarty logica in in het paginadata veld van enkele inhoudspagina&#039;s.</li>
  <li>Voeg de <code>{process_pagedata}</code> tag in helemaal bovenaan jouw pagina template.</li>
</ol>
<br/>
<h3>Welke parameters worden gebruikt?</h3>
<p>Op dit moment geen enkele.</p>';
$lang['admin']['page_metadata'] = 'Pagina specifieke metadata';
$lang['admin']['pagedata_codeblock'] = 'Smarty data of logica, specifiek voor deze pagina';
$lang['admin']['error_uploadproblem'] = 'Er heeft zich een fout opgedaan tijdens het uploaden';
$lang['admin']['error_nofileuploaded'] = 'Geen bestand ge&uuml;pload';
$lang['admin']['files_failed'] = 'Bestanden md5sum check komt niet overeen';
$lang['admin']['files_not_found'] = 'Bestanden niet gevonden';
$lang['admin']['info_generate_cksum_file'] = 'Deze functie geeft de mogelijkheid om een checksum bestand te maken t.b.v. latere validatie. Dit dient te worden gebruikt voor het uitrollen van een website, en voor/na een upgrade, of grote wijzigingen.';
$lang['admin']['info_validation'] = 'Deze functie controleert de checksums in het opgegeven bestand tegen de huidige bestanden. Het kan helpen om bestanden te helpen die zijn aangepast of gehacked. Vanaf CMS Made Simple versie 1.4 zal voor iedere releases een checksum worden gemaakt.';
$lang['admin']['download_cksum_file'] = 'Download Checksum Bestand';
$lang['admin']['perform_validation'] = 'Voer een validatie uit';
$lang['admin']['upload_cksum_file'] = 'Upload Checksum Bestand';
$lang['admin']['checksumdescription'] = 'Valideer de integriteit van de CMSMS bestanden tegen bekende checksums';
$lang['admin']['system_verification'] = 'Systeem Verificatie';
$lang['admin']['extra1'] = 'Extra Pagina Veld 1';
$lang['admin']['extra2'] = 'Extra Pagina Veld 2';
$lang['admin']['extra3'] = 'Extra Pagina Veld 3';
$lang['admin']['start_upgrade_process'] = 'Start Upgrade proces';
$lang['admin']['warning_upgrade'] = '<em><strong>Let op:</strong></em> het CMS heeft een upgrade nodig.';
$lang['admin']['warning_upgrade_info1'] = 'U heeft database versie %s. U dient te upgraden naar databaseversie %s';
$lang['admin']['warning_upgrade_info2'] = 'Selecteer de volgende link: %s.';
$lang['admin']['warning_mail_settings'] = 'Uw mail instellingen zijn nog niet geconfigureerd. Dit kan van invloed zijn op het versturen van e-mail berichten vanuit uw website.  Ga naar <a href="%s">Uitbreidingen >> CMSMailer</a> en configureer de mail instellingen met de informatie die u van uw internet provider heeft gekregen.';
$lang['admin']['view_page'] = 'Bekijk deze pagina in een nieuw venster';
$lang['admin']['off'] = 'Uit';
$lang['admin']['on'] = 'Aan';
$lang['admin']['invalid_test'] = 'Ongeldige test parameterwaarde!';
$lang['admin']['copy_paste_forum'] = 'Bekijk tekst rapport <em>(bruikbaar voor forum posts)</em>';
$lang['admin']['permission_information'] = 'Autorisatie informatie';
$lang['admin']['server_os'] = 'Server Operating System ';
$lang['admin']['server_api'] = 'Server API ';
$lang['admin']['server_software'] = 'Server Software ';
$lang['admin']['server_information'] = 'Server Informatie';
$lang['admin']['session_save_path'] = 'Session Save Path ';
$lang['admin']['max_execution_time'] = 'Maximale Uitvoertijd';
$lang['admin']['gd_version'] = 'GD versie';
$lang['admin']['upload_max_filesize'] = 'Maximale Upload Grootte';
$lang['admin']['post_max_size'] = 'Maximale Post Grootte';
$lang['admin']['memory_limit'] = 'PHP Memory Limit ';
$lang['admin']['server_db_type'] = 'Server Database ';
$lang['admin']['server_db_version'] = 'Server Database Versie';
$lang['admin']['phpversion'] = 'Huidige PHP versie';
$lang['admin']['safe_mode'] = 'PHP Safe Mode ';
$lang['admin']['php_information'] = 'PHP Informatie';
$lang['admin']['cms_install_information'] = 'CMS Installatie informatie';
$lang['admin']['cms_version'] = 'CMS Versie';
$lang['admin']['installed_modules'] = 'Ge&iuml;nstalleerde Modules';
$lang['admin']['config_information'] = 'CMS Config Instellingen';
$lang['admin']['systeminfo_copy_paste'] = 'Kopieer en plak deze geselecteerde tekst in uw forumbericht';
$lang['admin']['help_systeminformation'] = 'De hieronder getoonde informatie is afkomstig uit verschillende elementen van het cms-systeem, kan worden gebruikt bij een probleem-analyse. Ook kan deze worden gekopieerd naar het forum voor hulpvraag.';
$lang['admin']['systeminfo'] = 'Systeem Informatie';
$lang['admin']['systeminfodescription'] = 'Tonen van verschillende informatie elementen van het systeem die kunnen worden gebruikt bij een probleemanalyse';
$lang['admin']['systemmaintenance'] = 'Systeemonderhoud';
$lang['admin']['systemmaintenancedescription'] = 'Diverse functies waarmee je het systeem kunt onderhouden. Hier kunt u ook het changelog van CMS Made Simple bekijken.';
$lang['admin']['sysmaintab_database'] = 'Database ';
$lang['admin']['sysmaintab_changelog'] = 'Changelog ';
$lang['admin']['sysmaintab_content'] = 'Website buffer en content';
$lang['admin']['sysmain_content_status'] = 'Content Status';
$lang['admin']['sysmain_cache_status'] = 'Cache Status';
$lang['admin']['sysmain_database_status'] = 'Database Status  ';
$lang['admin']['sysmain_updatehierarchy'] = 'Pagina hierarchie posities bijwerken';
$lang['admin']['sysmain_confirmupdatehierarchy'] = 'Weet u zeker dat u de paginaposities in de hierarchie wilt repareren?';
$lang['admin']['sysmain_update'] = 'Bijwerken';
$lang['admin']['sysmain_pagesfound'] = 'pagina&#039;s gevonden';
$lang['admin']['sysmain_hierarchyupdated'] = 'Pagina hierarchie posities bijgewerkt';
$lang['admin']['sysmain_nostr_errors'] = 'Er zijn geen structurele fouten aangetroffen in de database';
$lang['admin']['sysmain_str_error'] = 'Er is een structurele fout aangetroffen in de tabel';
$lang['admin']['sysmain_str_errors'] = 'Er zijn structurele fouten aangetroffen in de tabellen';
$lang['admin']['sysmain_tablesfound'] = 'tabellen gevonden (waarvan er %d geen seq-tabellen zijn)';
$lang['admin']['sysmain_repair'] = 'Repareer';
$lang['admin']['sysmain_repairtables'] = 'Repareer tabellen';
$lang['admin']['sysmain_tablesrepaired'] = 'Tabellen gerepareerd';
$lang['admin']['sysmain_optimizetables'] = 'Tabellen optimaliseren';
$lang['admin']['sysmain_tablesoptimized'] = 'Tabellen geoptimaliseerd';
$lang['admin']['sysmain_optimize'] = 'Optimaliseer';
$lang['admin']['sysmain_confirmclearcache'] = 'Weet u zeker dat u de buffer wilt legen?';
$lang['admin']['sysmain_nocontenterrors'] = 'Geen fouten gedetecteerd in de inhoud';
$lang['admin']['sysmain_pagesmissinalias'] = 'pagina&#039;s missen aliassen';
$lang['admin']['sysmain_confirmfixaliases'] = 'Weet u zeker dat u aliassen wilt toevoegen aan pagina&#039;s die het missen?';
$lang['admin']['sysmain_fixaliases'] = 'Voeg aliassen toe waar deze worden gemist';
$lang['admin']['sysmain_aliasesfixed'] = 'aliassen gerepareerd';
$lang['admin']['sysmain_pagesinvalidtypes'] = 'pagina&#039;s met een ongeldig contenttype';
$lang['admin']['sysmain_confirmfixtypes'] = 'Weet u zeker dat u alle pagina&#039;s met een ongeldig contenttype wilt omzetten naar standaardpagina&#039;s?';
$lang['admin']['sysmain_fixtypes'] = 'Converteer pagina&#039;s naar standaard contentpagina&#039;s';
$lang['admin']['sysmain_typesfixed'] = 'pagina contenttype&#039;s gerepareerd';
$lang['admin']['welcome_user'] = 'Welkom';
$lang['admin']['itsbeensincelogin'] = 'Laatste login %s';
$lang['admin']['days'] = 'dagen';
$lang['admin']['day'] = 'dag';
$lang['admin']['hours'] = 'uren';
$lang['admin']['hour'] = 'uur';
$lang['admin']['minutes'] = 'minuten';
$lang['admin']['minute'] = 'minuut';
$lang['admin']['help_css_max_age'] = 'Deze parameter dient een hoge waarde te hebben voor statische sites, en 0 te hebben voor een ontwikkel omgeving';
$lang['admin']['css_max_age'] = 'Maximale periode (in seconden) die stylesheets gebufferd mogen worden in de browser';
$lang['admin']['error'] = 'Fout';
$lang['admin']['new_version_available'] = '<em>Opmerking:</em> Er is een nieuwere versie van het CMS beschikbaar. Neem contact op met uw webmaster.';
$lang['admin']['master_admintheme'] = 'Standaard Admin Theme (voor de login pagina en nieuwe gebruikers)';
$lang['admin']['contenttype_separator'] = 'Scheidingsteken';
$lang['admin']['contenttype_sectionheader'] = 'Sectie hoofd';
$lang['admin']['contenttype_content'] = 'Inhoud';
$lang['admin']['contenttype_pagelink'] = 'Interne link';
$lang['admin']['nogcbwysiwyg'] = 'Schakel WYSIWYG uit bij HTML-Blokken';
$lang['admin']['destination_page'] = 'Doelpagina';
$lang['admin']['additional_params'] = 'Overige Parameters';
$lang['admin']['help_function_current_date'] = '<h3 style=&quot;color: red;&quot;>Deprecated </h3>
	 <p>use <code>{$smarty.now|cms_date_format}</code></p>
	<h3>What does this do?</h3>
	<p>Prints the current date and time.  If no format is given, it will default to a format similar to &#039;Jan 01, 2004&#039;.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{current_date format=&quot;%A %d-%b-%y %T %Z&quot;}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em>format - Date/Time format using parameters from php&#039;s strftime function.  See <a href="http://php.net/strftime" target="_blank">here</a> for a parameter list and information.</li>
		<li><em>(optional)</em>ucword - If true return uppercase the first character of each word.</li>
	</ul>';
$lang['admin']['help_function_valid_xhtml'] = '<h3>Wat doet dit?</h3>
<p>Geeft een link naar de w3c HTML validator terug.</p>
<h3>Hoe wordt dit gebruikt?</h3>
<p>Voeg simpelweg de tag in jouw template/pagina als: <code>{valid_xhtml}</code></p>
<h3>Welke parameters gebruikt het?</h3>

    <ul>
	<li><em>(optioneel)</em> url         (string)     - De URL gebruikt voor validatie, wanneer deze niet is gegeven, http://validator.w3.org/check/referer wordt gebruikt.</li>
	<li><em>(optioneel)</em> class       (string)     - Indien deze is ingesteld zal deze gebruikt worden als een class attribuut voor het link (a) element</li>
	<li><em>(optioneel)</em> target      (string)     - Indien deze is ingesteld zal deze gebruikt worden doel attribuut voor het link (a) element</li>
	<li><em>(optioneel)</em> image       (true/false) - Indien ingesteld als false zal een tekst link gebruikt worden in plaats van afbeelding/icoon.</li>
	<li><em>(optioneel)</em> text        (string)     - Indien ingesteld zal dit gebruikt worden voor de link tekst of de alternatieve tekst voor de afbeelding. Standaard is &#039;valid XHTML 1.0 Transitional&#039;.<br /> Wanneer er een afbeelding wordt gebruikt zal de opgegeven string ook worden gebruikt voor het alt-attribuut van de afbeelding (Standaard kan dit overruled worden door de &#039;alt&#039; parameter).</li>
	<li><em>(optioneel)</em> image_class (string)     - Alleen wanneer &#039;image&#039; niet is ingesteld als &#039;false&#039;. Indien deze is ingesteld zal deze gebruikt worden als class-attribuut voor het afbeelding (img) element</li>
	<li><em>(optioneel)</em> src         (string)     - Alleen wanneer &#039;image&#039; niet is ingesteld als &#039;false&#039;. Het icoon om weer te geven. Standaard is http://www.w3.org/Icons/valid-xhtml10</li>
	<li><em>(optioneel)</em> width       (string)     - Alleen wanneer &#039;image&#039; niet is ingesteld als &#039;false&#039;. De afbeelding breedte. Standaard is dit 88 (breedte van http://www.w3.org/Icons/valid-xhtml10)</li>
	<li><em>(optioneel)</em> height      (string)     - Alleen wanneer &#039;image&#039; niet is ingesteld als &#039;false&#039;. De afbeelding hoogte. Standaard is dit 31 (hoogte van http://www.w3.org/Icons/valid-xhtml10)</li>
	<li><em>(optioneel)</em> alt         (string)     - Alleen wanneer &#039;image&#039; niet is ingesteld als &#039;false&#039;. De alternatieve tekst (&#039;alt&#039; attribute) voor de afbeelding (element). Wanneer niets is opgegeven wordt de link-tekst gebruikt.</li>
    </ul>';
$lang['admin']['help_function_valid_css'] = '<h3>Wat doet dit?</h3>
<p>Geeft een link naar de w3c CSS validator.</p>
<h3>Hoe wordt het gebruikt?</h3>
<p>Plaats simpelweg de tag in jouw template/pagina zoals: <code>{valid_css}</code></p>
<h3>Welke parameters heeft het?</h3>

    <ul>
        <li><em>(optioneel)</em> url         (string)     - De URL die gebruikt wordt voor validatie, wanneer niets is opgegeven wordt http://jigsaw.w3.org/css-validator/check/referer gebruikt.</li>
	<li><em>(optioneel)</em> class       (string)     - Indien ingesteld wordt dit gebruikt als class-attribuut voor het link (a) element</li>
	<li><em>(optioneel)</em> target      (string)     - Indien ingesteld wordt dit gebruikt als doel attribuut voor het link (a) element</li>
	<li><em>(optioneel)</em> image       (true/false) - Indien deze is ingesteld als &#039;false&#039;, wordt er een tekst-link gebruikt in plaats van een afbeelding/icoon.</li>
	<li><em>(optioneel)</em> text        (string)     - Indien ingesteld wordt deze gebruikt voor de link-tekst of voor de alternatieve tekst voor de afbeelding. Standaard is dit &#039;Valid CSS 2.1&#039;.<br /> Wanneer een afbeelding wordt gebruikt wordt deze string ook gebruikt als alt attribuut voor de afbeelding (Standaard kan dit overruled worden door de &#039;alt&#039; parameter).</li>
	<li><em>(optioneel)</em> image_class (string)     - Alleen indien &#039;image&#039; niet is ingesteld op &#039;false&#039;. Indien ingesteld wordt dit gebruikt als class attribuut voor het afbeelding (img) element</li>
        <li><em>(optioneel)</em> src         (string)     - Alleen indien &#039;image&#039; niet is ingesteld op &#039;false&#039;. Het icoon om weer te geven. Standaard is dit http://jigsaw.w3.org/css-validator/images/vcss</li>
        <li><em>(optioneel)</em> width       (string)     - Alleen indien &#039;image&#039; niet is ingesteld op &#039;false&#039;. De afbeelding breedte. Standaard is dit 88 (breedte van http://jigsaw.w3.org/css-validator/images/vcss)</li>
        <li><em>(optioneel)</em> height      (string)     - Alleen indien &#039;image&#039; niet is ingesteld op &#039;false&#039;. De afbeelding hoogte. Standaard is dit 31 (hoogte van http://jigsaw.w3.org/css-validator/images/vcss)</li>
	<li><em>(optioneel)</em> alt         (string)     - Alleen indien &#039;image&#039; niet is ingesteld op &#039;false&#039;. De alternatieve tekst (&#039;alt&#039; attribute) voor de afbeelding (element). Wanneer niets is opgegeven zal de  link-tekst worden gebruikt.</li>
    </ul>';
$lang['admin']['help_function_title'] = '	<h3>Wat doet dit?</h3>
	<p>Druk de titel van de pagina af.</p>
	<h3>Hoe wordt het gebruikt?</h3>
	<p>Plaats simpelweg de tag in jouw template/pagina zoals: <code>{title}</code></p>
	<h3>Welke parameters heeft het?</h3>
	<p><em>(optioneel)</em> assign (string) - Wijst het resultaat toe aan een smarty variabele met die naam.</p>';
$lang['admin']['help_function_stylesheet'] = '<p><strong>Deprecated:</strong> This function is deprecated and will be removed in later versions of CMSMS.</p>

	<h3>Wat doet dit?</h3>
	<p>Haalt stylesheet informatie van het systeem.  Standaard haalt het alle stylesheets op die aan de huidige template zijn verbonden.</p>
	<h3>Hoe wordt het gebruikt?</h3>
	<p>Plaats simpelweg de tag in jouw template/pagina head sectie zoals: <code>{stylesheet}</code></p>
	<h3>Welke parameters heeft het?</h3>
	<ul>
		<li><em>(optioneel)</em>name - In plaats van alle stylesheets op te halen voor de gegeven pagina, haalt het alleen de genoemde op. Of deze nu verbonden is met de huidige template of niet.</li>
		<li><em>(optioneel)</em>media - Indien een naam is opgegeven geeft dit je de mogelijkheid om een ander media type voor deze stylesheet in te stellen.</li>
    <li><em>(optioneel)</em>templateid - Indien templateid is opgegeven zal deze de stylesheets gebruiken die verbonden zijn aan die template in plaats van de huidige template.</li>
	</ul>';
$lang['admin']['help_function_sitename'] = '        <h3>What does this do?</h3>
        <p>Shows the name of the site.  This is defined during install and can be modified in the Global Settings section of the admin panel.</p>
        <h3>How do I use it?</h3>
        <p>Just insert the tag into your template/page like: <code>{sitename}</code></p>
        <h3>What parameters does it take?</h3>
	<p><em>(optional)</em> assign (string) - Assign the results to a smarty variable with that name.</p>';
$lang['admin']['help_function_search'] = '<h3>What does this do?</h3>
	<p>This is actually just a wrapper tag for the Search module to make the tag syntax easier. 
	Instead of having to use <code>{cms_module module=&#039;Search&#039;}</code> you can now just use <code>{search}</code> to insert the module in a template.
	</p>
	<h3>How do I use it?</h3>
	<p>Just put <code>{search}</code> in a template where you want the search input box to appear. For help about the Search module, please refer to the Search module help.</p>';
$lang['admin']['help_function_root_url'] = '	<h3>What does this do?</h3>
	<p>Prints the root url location for the site.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{root_url}</code></p>
	<h3>What parameters does it take?</h3>
	<p>None at this time.</p>';
$lang['admin']['help_function_repeat'] = '  <h3>What does this do?</h3>
  <p>Repeats a specified sequence of characters, a specified number of times</p>
  <h3>How do I use it?</h3>
  <p>Insert a tag similar to the following into your template/page, like this: <code>{repeat string=&#039;repeat this &#039; times=&#039;3&#039;}</code></p>
  <h3>What parameters does it take?</h3>
  <ul>
  <li>string=&#039;text&#039; - The string to repeat</li>
  <li>times=&#039;num&#039; - The number of times to repeat it.</li>
  </ul>';
$lang['admin']['help_function_recently_updated'] = '	<h3>What does this do?</h3>
	<p>Outputs a list of recently updated pages.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{recently_updated}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
	 <li><p><em>(optional)</em> number=&#039;10&#039; - Number of updated pages to show.</p><p>Example: {recently_updated number=&#039;15&#039;}</p></li>
 	 <li><p><em>(optional)</em> leadin=&#039;Last changed&#039; - Text to show left of the modified date.</p><p>Example: {recently_updated leadin=&#039;Last Changed&#039;}</p></li>
 	 <li><p><em>(optional)</em> showtitle=&#039;true&#039; - Shows the titleattribute if it exists as well (true|false).</p><p>Example: {recently_updated showtitle=&#039;true&#039;}</p></li>											 	
	 <li><p><em>(optional)</em> css_class=&#039;some_name&#039; - Warp a div tag with this class around the list.</p><p>Example: {recently_updated css_class=&#039;some_name&#039;}</p></li>											 	
	 <li><p><em>(optional)</em> dateformat=&#039;d.m.y h:m&#039; - default is d.m.y h:m , use the format you whish (php -date- format)</p><p>Example: {recently_updated dateformat=&#039;D M j G:i:s T Y&#039;}</p></li>											 	
	</ul>
	<p>or combined:</p>
	<pre>{recently_updated number=&#039;15&#039; showtitle=&#039;false&#039; leadin=&#039;Last Change: &#039; css_class=&#039;my_changes&#039; dateformat=&#039;D M j G:i:s T Y&#039;}</pre>';
$lang['admin']['help_function_print'] = '	<h3>What does this do?</h3>
	<p>This is actually just a wrapper tag for the CMSPrinting module to make the tag syntax easier. 
	Instead of having to use <code>{cms_module module=&#039;CMSPrinting&#039;}</code> you can now just use <code>{print}</code> to insert the module on pages and templates.
	</p>
	<h3>How do I use it?</h3>
	<p>Just put <code>{print}</code> on a page or in a template. For help about the CMSPrinting module, what parameters it takes etc., please refer to the CMSPrinting module help.</p>';
$lang['admin']['login_info_title'] = 'Informatie';
$lang['admin']['login_info'] = 'Vanaf dit punt moeten de volgende parameters gelden';
$lang['admin']['login_info_params'] = '<ol> 
  <li>Cookies toestaan in uw browser</li> 
  <li>Javascript toestaan in uw browser </li> 
  <li>Popup schermen toestaan vanuit dit adres:</li> 
</ol>';
$lang['admin']['help_function_news'] = '	<h3>What does this do?</h3>
	<p>This is actually just a wrapper tag for the News module to make the tag syntax easier. 
	Instead of having to use <code>{cms_module module=&#039;News&#039;}</code> you can now just use <code>{news}</code> to insert the module on pages and templates.
	</p>
	<h3>How do I use it?</h3>
	<p>Just put <code>{news}</code> on a page or in a template. For help about the News module, what parameters it takes etc., please refer to the News module help.</p>';
$lang['admin']['help_function_modified_date'] = '        <h3>What does this do?</h3>
        <p>Prints the date and time the page was last modified.  If no format is given, it will default to a format similar to &#039;Jan 01, 2004&#039;.</p>
        <h3>How do I use it?</h3>
        <p>Just insert the tag into your template/page like: <code>{modified_date format=&quot;%A %d-%b-%y %T %Z&quot;}</code></p>
        <h3>What parameters does it take?</h3>
        <ul>
                <li><em>(optional)</em>format - Date/Time format using parameters from php&#039;s strftime function.  See <a href="http://php.net/strftime" target="_blank">here</a> for a parameter list and information.</li>
        </ul>';
$lang['admin']['help_function_metadata'] = '	<h3>What does this do?</h3>
	<p>Displays the metadata for this page. Both global metdata from the global settings page and metadata for each page will be shown.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template like: <code>{metadata}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em>showbase (true/false) - If set to false, the base tag will not be sent to the browser.  Defaults to true if use_hierarchy is set to true in config.php.</li>
	</ul>';
$lang['admin']['help_function_menu_text'] = '	<h3>What does this do?</h3>
	<p>Prints the menu text of the page.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{menu_text}</code></p>
	<h3>What parameters does it take?</h3>
	<p>None at this time.</p>';
$lang['admin']['help_function_menu'] = '	<h3>What does this do?</h3>
	<p>This is actually just a wrapper tag for the Menu Manager module to make the tag syntax easier. 
	Instead of having to use <code>{cms_module module=&#039;MenuManager&#039;}</code> you can now just use <code>{menu}</code> to insert the module on pages and templates.
	</p>
	<h3>How do I use it?</h3>
	<p>Just put <code>{menu}</code> on a page or in a template. For help about the Menu Manager module, what parameters it takes etc., please refer to the Menu Manager module help.</p>';
$lang['admin']['help_function_last_modified_by'] = '        <h3>What does this do?</h3>
        <p>Prints last person that edited this page.  If no format is given, it will default to a ID number of user .</p>
        <h3>How do I use it?</h3>
        <p>Just insert the tag into your template/page like: <code>{last_modified_by format=&quot;fullname&quot;}</code></p>
        <h3>What parameters does it take?</h3>
        <ul>
                <li><em>(optional)</em>format - id, username, fullname</li>
        </ul>';
$lang['admin']['help_function_image'] = '  <h3>What does this do?</h3>
  <p>Creates an image tag to an image stored within your images directory</p>
  <h3>How do I use it?</h3>
  <p>Just insert the tag into your template/page like: <code>{image src=&quot;something.jpg&quot;}</code></p>
  <h3>What parameters does it take?</h3>
  <ul>
     <li><em>(required)</em>  <tt>src</tt> - Image filename within your images directory.</li>
     <li><em>(optional)</em>  <tt>width</tt> - Width of the image within the page. Defaults to true size.</li>
     <li><em>(optional)</em>  <tt>height</tt> - Height of the image within the page. Defaults to true size.</li>
     <li><em>(optional)</em>  <tt>alt</tt> - Alt text for the image -- needed for xhtml compliance. Defaults to filename.</li>
     <li><em>(optional)</em>  <tt>class</tt> - CSS class for the image.</li>
     <li><em>(optional)</em>  <tt>title</tt> - Mouse over text for the image. Defaults to Alt text.</li>
     <li><em>(optional)</em>  <tt>addtext</tt> - Additional text to put into the tag</li>
  </ul>';
$lang['admin']['help_function_html_blob'] = '	<h3>Wat doet het?</h3>
	<p>Zie de global_content voor een beschrijving.</p>';
$lang['admin']['help_function_google_search'] = '	<h3>What does this do?</h3>
	<p>Search&#039;s your website using Google&#039;s search engine.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{google_search}</code><br />
	<br />
	Note: Google needs to have your website indexed for this to work. You can submit your website to google <a href="http://www.google.com/addurl.html">here</a>.</p>
	<h3>What if I want to change the look of the textbox or button?</h3>
	<p>The look of the textbox and button can be changed via css. The textbox is given an id of textSearch and the button is given an id of buttonSearch.</p>

	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional)</em> domain - This tells google the website domain to search. This script tries to determine this automatically.</li>
		<li><em>(optional)</em> buttonText - The text you want to display on the search button. The default is &quot;Search Site&quot;.</li>
	</ul>';
$lang['admin']['help_function_global_content'] = '	<h3>What does this do?</h3>
	<p>Inserts a global content block into your template or page.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{global_content name=&#039;myblob&#039;}</code>, where name is the name given to the block when it was created.</p>
	<h3>What parameters does it take?</h3>
	<ul>
  	  <li>name - The name of the global content block to display.</li>
          <li><em>(optional)</em> assign - The name of a smarty variable that the global content block should be assigned to.</li>
	</ul>';
$lang['admin']['help_function_get_template_vars'] = '	<h3>What does this do?</h3>
	<p>Dumps all the known smarty variables into your page</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{get_template_vars}</code></p>
	<h3>What parameters does it take?</h3>
											  <p>None at this time</p>';
$lang['admin']['help_function_uploads_url'] = '	<h3>What does this do?</h3>
	<p>Prints the uploads url location for the site.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{uploads_url}</code></p>
	<h3>What parameters does it take?</h3>
	<p><em>(optional)</em> assign (string) - Assign the results to a smarty variable with that name.</p>';
$lang['admin']['help_function_embed'] = '		<h3>What does this do?</h3>
	<p>Enable inclusion (embeding) of any other application into the CMS. The most usual use could be a forum. 
	This implementation is using IFRAMES so older browsers can have problems. Sorry bu this is the only known way 
	that works without modifing the embeded application.</p>
	<h3>How do I use it?</h3>
        <ul>
        <li>a) Add <code>{embed header=true}</code> into the head section of your page template, or into the metadata section in the options tab of a content page.  This will ensure that the required javascript gets included.   If you insert this tag into the metadata section in the options tab of a content page you must ensure that <code>{metadata}</code> is in your page template.</li>
        <li>b) Add <code>{embed url=&quot;http://www.google.com&quot;}</code> into your page content or in the body of your page template.</li>
        </ul>
        <br/>
        <h4>Example to make the iframe larger</h4>
	<p>Add the following to your style sheet:</p>
        <pre>#myframe { height: 600px; }</pre>
        <br/>
        <h3>What parameters does it take?</h3>
        <ul>
            <li><em>(required)</em>url - the url to be included</li> 
            <li><em>(required)</em>header=true - this will generate the header code for good resizing of the IFRAME.</li>
            <li>(optional)name - an optional name to use for the iframe (instead of myframe).<p>If this option is used, it must be used identically in both calls, i.e: {embed header=true name=foo} and {embed name=foo url=http://www.google.com} calls.</p></li>
        </ul>';
$lang['admin']['help_function_description'] = '	<h3>What does this do?</h3>
	<p>Prints the description (title attribute) of the page.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{description}</code></p>
	<h3>What parameters does it take?</h3>
	<p>None at this time.</p>';
$lang['admin']['help_function_created_date'] = '        <h3>What does this do?</h3>
        <p>Prints the date and time the page was created.  If no format is given, it will default to a format similar to &#039;Jan 01, 2004&#039;.</p>
        <h3>How do I use it?</h3>
        <p>Just insert the tag into your template/page like: <code>{created_date format=&quot;%A %d-%b-%y %T %Z&quot;}</code></p>
        <h3>What parameters does it take?</h3>
        <ul>
                <li><em>(optional)</em>format - Date/Time format using parameters from php&#039;s strftime function.  See <a href="http://php.net/strftime" target="_blank">here</a> for a parameter list and information.</li>
        </ul>';
$lang['admin']['help_function_content'] = '<h3>What does this do?</h3>
	<p>This is where the content for your page will be displayed. It&#039;s inserted into the template and changed based on the current page being displayed.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template like: <code>{content}</code>.</p>
	<p><strong>The default block <code>{content}</code> is required for proper working. (so without the block-parameter)</strong> To give the block a specific label, use the label-parameter. Additional blocks can be added by using the block-parameter.</p>
	<h3>What parameters does it take?</h3>
	<ul>
		<li><em>(optional) </em>block - Allows you to have more than one content block per page. When multiple content tags are put on a template, that number of edit boxes will be displayed when the page is edited.
<p>Example:</p>
<pre>{content block=&quot;second_content_block&quot; label=&quot;Second Content Block&quot;}</pre>
<p>Now, when you edit a page there will a textarea called &quot;Second Content Block&quot;.</p></li>
		<li><em>(optional) </em>wysiwyg (true/false) - If set to false, then a wysiwyg will never be used while editing this block. If true, then it acts as normal.  Only works when block parameter is used.</li>
		<li><em>(optional) </em>oneline (true/false) - If set to true, then only one edit line will be shown while editing this block. If false, then it acts as normal.  Only works when block parameter is used.</li>
<li><em>(optional) </em>size - Applicable only when the oneline option is used this optional parameter allows you to specify the size of the edit field.  The default value is 50.</li>
<li><em>(optional) </em>maxlength - Applicable only when the oneline option is used this optional parameter allows you to specify the maximum length of input for the edit field.  The default value is 255.</li>
		<li><em>(optional) </em>default - Allows you to specify default content for this content blocks (additional content blocks only).</li>
		<li><em>(optional) </em>label - Allows specifying a label for display in the edit content page.</li>
                <li><em>(optional)</em> tab - The desired tab to display this field on in the edit form..</li>
		<li><em>(optional) </em>assign - Assigns the content to a smarty parameter, which you can then use in other areas of the page, or use to test whether content exists in it or not.
<p>Example of passing page content to a User Defined Tag as a parameter:</p></li>
<pre>
         {content assign=pagecontent}
         {table_of_contents thepagecontent=&quot;$pagecontent&quot;}
</pre>
</li>
	</ul>';
$lang['admin']['help_function_contact_form'] = '  <h2>Let op: Deze plugin is vervallen</h2>
  <h3>Deze plugin is verwijderd sinds CMS Made Simple versie 1.5</h3>
  <p>U kunt in plaats hiervan de module FormBuilder gebruiken.</p>';
$lang['admin']['help_function_cms_versionname'] = '	<h3>What does this do? </h3>
	<p>This tag is used to insert the current version name of CMS into your template or page.  It doesn&#039;t display any extra besides the version name.</p>
	<h3>How do I use it?</h3>
	<p>This is just a basic tag plugin.  You would insert it into your template or page like so: <code>{cms_versionname}</code>
	<h3>What parameters does it take?</h3>
	<p>It takes no parameters.</p>';
$lang['admin']['help_function_cms_version'] = '	<h3>What does this do?</h3>
	<p>This tag is used to insert the current version number of CMS into your template or page.  It doesn&#039;t display any extra besides the version number.</p>
	<h3>How do I use it?</h3>
	<p>This is just a basic tag plugin.  You would insert it into your template or page like so: <code>{cms_version}</code>
	<h3>What parameters does it take?</h3>
	<p>It takes no parameters.</p>';
$lang['admin']['about_function_cms_selflink'] = '		<p>Author: Ted Kulp <tedkulp@users.sf.net></p>
		<p>Version: 1.1</p>
		<p>Modified: Martin B. Vestergaard <mbv@nospam.dk></p>
		<p>Version: 1.41</p>
		<p>Modified: Russ Baldwin</p>
		<p>Version: 1.42</p>
		<p>Modified: Marcus Bointon <coolbru@users.sf.net></p>
		<p>Version: 1.43</p>
		<p>Modified: Tatu Wikman <tsw@backspace.fi></p>
		<p>Version: 1.44</p>
		<p>Modified: Hans Mogren <http://hans.bymarken.net/></p>
		<p>Version: 1.45</p>

		<p>
		Change History:<br/>
		1.46 - Fixes a problem with too many queries when using the dir=start option.<br/>
		1.45 - Added a new option for &quot;dir&quot;, &quot;up&quot;, for links to the parent page e.g. dir=&quot;up&quot; (Hans Mogren).<br />
		1.44 - Added new parameters &quot;ext&quot; and &quot;ext_info&quot; to allow external links with class=&quot;external&quot; and info text after the link, ugly hack but works thinking about rewriting this(Tatu Wikman)<br />
		1.43 - Added new parameters &quot;image&quot; and &quot;imageonly&quot; to allow attachment of images to be used for page links, either instead of or in addition to text links. (Marcus Bointon)<br />
		1.42 - Added new parameter &quot;anchorlink&quot; and a new option for &quot;dir&quot; namely, &quot;anchor&quot;, for internal page links. e.g. dir=&quot;anchor&quot; anchorlink=&quot;internal_link&quot;. (Russ)<br />
		1.41 - added new parameter &quot;href&quot; (LeisureLarry)<br />
		1.4 - fixed bug next/prev linking to non-content pages. (Thanks Teemu Koistinen for this fix)<br />
		1.3 - added option &quot;more&quot;<br />
		1.2 - by Martin B. Vestergaard
		<ul>
		<li>changed default text to Page Name (was Page Alias)</li>
		<li>added option dir=next/prev to display next or previous item in the hirachy - thanks to 100rk</li>
		<li>added option class to add a class= statement to the a-tag.</li>
		<li>added option menu to display menu-text in sted of Page Name</li>
		<li>added option lang to display link-labels in different languages</li>
		</ul>
		1.1 - Changed to new content system<br />
		1.0 - Initial release
		</p> ';
$lang['admin']['help_function_cms_selflink'] = '		<h3>What does this do?</h3>
		<p>Creates a link to another CMSMS content page inside your template or content. Can also be used for external links with the ext parameter.</p>
		<h3>How do I use it?</h3>
		<p>Just insert the tag into your template/page like: <code>{cms_selflink page=&amp;quot;1&amp;quot;}</code> or  <code>{cms_selflink page=&amp;quot;alias&amp;quot;}</code></p>
		<h3>What parameters does it take?</h3>
		<p>
		<ul>
		<li><em>(optional)</em> <tt>page</tt> - Page ID or alias to link to.</li>
		<li><em>(optional)</em> <tt>dir anchor (internal links)</tt> - New option for an internal page link. If this is used then <tt>anchorlink</tt> should be set to your link. </li> <!-- Russ - 25-04-2006 -->
		<li><em>(optional)</em> <tt>anchorlink</tt> - New paramater for an internal page link. If this is used then <tt>dir =&quot;anchor&quot;</tt> should also be set. No need to add the #, because it is added automatically.</li> <!-- Russ - 25-04-2006 -->
		<li><em>(optional)</em> <tt>urlparam</tt> - Specify additional parameters to the URL.  <strong>Do not use this in conjunction with the <em>anchorlink</em> parameter</em></strong>
		<li><em>(optional)</em> <tt>tabindex =&quot;a value&quot;</tt> - Set a tabindex for the link.</li> <!-- Russ - 22-06-2005 -->
		<li><em>(optional)</em> <tt>dir start/next/prev/up (previous)</tt> - Links to the default start page or the next or previous page, or the parent page (up). If this is used <tt>page</tt> should not be set.</li> <!-- mbv - 21-06-2005 -->
		<B>Note!</B> Only one of the above may be used in the same cms_selflink statement!!
		<li><em>(optional)</em> <tt>text</tt> - Text to show for the link.  If not given, the Page Name is used instead.</li>
		<li><em>(optional)</em> <tt>menu 1/0</tt> - If 1 the Menu Text is used for the link text instead of the Page Name</li> <!-- mbv - 21-06-2005 -->
		<li><em>(optional)</em> <tt>target</tt> - Optional target for the a link to point to.  Useful for frame and javascript situations.</li>
		<li><em>(optional)</em> <tt>class</tt> - Class for the < a > link. Useful for styling the link.</li> <!-- mbv - 21-06-2005 -->
		<li><em>(optional)</em> <tt>lang</tt> - Display link-labels  (&quot;Next Page&quot;/&quot;Previous Page&quot;) in different languages (0 for no label.) Danish (dk), English (en) or French (fr), for now.</li> <!-- mbv - 21-06-2005 -->
		<li><em>(optional)</em> <tt>id</tt> - Optional css_id for the < a > link.</li> <!-- mbv - 29-06-2005 -->
		<li><em>(optional)</em> <tt>more</tt> - place additional options inside the < a > link.</li> <!-- mbv - 29-06-2005 -->
		<li><em>(optional)</em> <tt>label</tt> - Label to use in with the link if applicable.</li>
		<li><em>(optional)</em> <tt>label_side left/right</tt> - Side of link to place the label (defaults to &quot;left&quot;).</li>
		<li><em>(optional)</em> <tt>title</tt> - Text to use in the title attribute.  If none is given, then the title of the page will be used for the title.</li>
		<li><em>(optional)</em> <tt>rellink 1/0</tt> - Make a relational link for accessible navigation.  Only works if the dir parameter is set and should only go in the head section of a template.</li>
		<li><em>(optional)</em> <tt>href</tt> - If href is used only the href value is generated (no other parameters possible). <strong>Example:</strong> &amp;lt;a href=&amp;quot;{cms_selflink href=&amp;quot;alias&amp;quot;}&amp;quot;&amp;gt;&amp;lt;img src=&amp;quot;&amp;quot;&amp;gt;&amp;lt;/a&amp;gt;</li>
		<li><em>(optional)</em> <tt>image</tt> - A url of an image to use in the link. <strong>Example:</strong> {cms_selflink dir=&amp;quot;next&amp;quot; image=&amp;quot;next.png&amp;quot; text=&amp;quot;Next&amp;quot;}</li>
		<li><em>(optional)</em> <tt>alt</tt> - Alternative text to be used with image (alt=&quot;&quot; will be used if no alt parameter is given).</li>
		<li><em>(optional)</em> <tt>imageonly</tt> - If using an image, whether to suppress display of text links. If you want no text in the link at all, also set lang=0 to suppress the label. <B>Example:</B> {cms_selflink dir=&amp;quot;next&amp;quot; image=&amp;quot;next.png&amp;quot; text=&amp;quot;Next&amp;quot; imageonly=1}</li>
		<li><em>(optional)</em> <tt>ext</tt> - For external links, will add class=&amp;quot;external and info text. <strong>warning:</strong> only text, target and title parameters are compatible with this parameter</li>
		<li><em>(optional)</em> <tt>ext_info</tt> - Used together with &amp;quot;ext&amp;quot; defaults to (external link).</li>
                <li><em>(optional)</em> <tt>assign</tt> - Assign the results to the named smarty variable.</li>
		</ul>
		</p>';
$lang['admin']['about_function_cms_module'] = '	<p>Author: Ted Kulp<tedkulp@users.sf.net></p>
	<p>Version: 1.0</p>
	<p>
	Change History:<br/>
	None
	</p> ';
$lang['admin']['help_function_cms_module'] = '	<h3>What does this do?</h3>
	<p>This tag is used to insert modules into your templates and pages. If a module is created to be used as a tag plugin (check it&#039;s help for details), then you should be able to insert it with this tag.</p>
	<h3>How do I use it?</h3>
	<p>It&#039;s just a basic tag plugin.  You would insert it into your template or page like so: <code>{cms_module module=&quot;somemodulename&quot;}</code></p>
	<h3>What parameters does it take?</h3>
	<p>There is only one required parameter.  All other parameters are passed on to the module.</p>
	<ul>
		<li>module - Name of the module to insert.  This is not case sensitive.</li>
	</ul>';
$lang['admin']['about_function_breadcrumbs'] = '<p>Author: Marcus Deglos <<a href="mailto:md@zioncore.com">md@zioncore.com</a>></p>
<p>Version: 1.7</p>
<p>
Change History:<br/>
1.1 - Modified to use new content rewrite (wishy)<br />
1.2 - Added parameters: delimiter, initial, and root (arl)<br />
1.3 - Added parameter: classid (tdh / perl4ever)<br />
1.4 - Added parameter currentclassid and fixed some bugs (arl)<br />
1.5 - Modified to use new hierarchy manager<br />
1.6 - Modified to skip any parents that are marked to be &quot;not shown in menu&quot; except for root<br />
1.7 - Added root_url parameter (elijahlofgren)<br />
</p> ';
$lang['admin']['help_function_breadcrumbs'] = '<h3>What does this do?</h3>
<p>Prints a breadcrumb trail .</p>
<h3>How do I use it?</h3>
<p>Just insert the tag into your template/page like: <code>{breadcrumbs}</code></p>
<h3>What parameters does it take?</h3>
<ul>
<li><em>(optional)</em> <tt>delimiter</tt> - Text to seperate entries in the list (default &quot;>>&quot;).</li>
<li><em>(optional)</em> <tt>initial</tt> - 1/0 If set to 1 start the breadcrumbs with a delimiter (default 0).</li>
<li><em>(optional)</em> <tt>root</tt> - Page alias of a page you want to always appear as the first page in
    the list. Can be used to make a page (e.g. the front page) appear to be the root of everything even though it is not.</li>
<li><em>(optional)</em> <tt>root_url</tt> - Override the URL of the root page. Useful for making link be to &#039;/&#039; instead of &#039;/home/&#039;. This requires that the root page be set as the default page.</li>
<li><em>(optional)</em> <tt>classid</tt> - The CSS class for the non current page names, i.e. the first n-1 pages in the list. If the name is a link it is added to the <a href> tags, otherwise it is added to the <span> tags.</li>
<li><em>(optional)</em> <tt>currentclassid</tt> - The CSS class for the &amp;lt;span&amp;gt; tag surrounding the current page name.</li>
<li><em>(optional)</em> <tt>starttext</tt> - Text to append to the front of the breadcrumbs list, something like &quot;You are here&quot;.</li>
</ul>';
$lang['admin']['about_function_anchor'] = '	<p>Author: Ted Kulp<tedkulp@users.sf.net></p>
	<p>Version: 1.1</p>
	<p>
	Change History:<br/>
	<strong>Update to version 1.1 from 1.0</strong> <em>2006/07/19</em><br/>
	Russ added the means to insert a title, a tabindex and a class for the anchor link. Westis added accesskey and changed parameter names to not include &#039;anchorlink&#039;.<br/>
	</hr>
	</p> ';
$lang['admin']['help_function_anchor'] = '	<h3>What does this do? </h3>
	<p>Makes a proper anchor link.</p>
	<h3>How do I use it?</h3>
	<p>Just insert the tag into your template/page like: <code>{anchor anchor=&#039;here&#039; text=&#039;Scroll Down&#039;}</code></p>
	<h3>What parameters does it take?</h3>
	<ul>
	<li><tt>anchor</tt> - Where we are linking to.  The part after the #.</li>
	<li><tt>text</tt> - The text to display in the link.</li>
	<li><tt>class</tt> - The class for the link, if any</li>
	<li><tt>title</tt> - The title to display for the link, if any.</li>
	<li><tt>tabindex</tt> - The numeric tabindex for the link, if any.</li>
	<li><tt>accesskey</tt> - The accesskey for the link, if any.</li>
	<li><em>(optional)</em> <tt>onlyhref</tt> - Only display the href and not the entire link. No other options will work</li>
	</ul>';
$lang['admin']['help_function_site_mapper'] = '<h3>What does this do?</h3>
  <p>This is actually just a wrapper tag for the Menu Manager module to make the tag syntax easier, and to simplify creating a sitemap. </p>
<h3>How do I use it?</h3>
  <p>Just put <code>{site_mapper}</code> on a page or in a template. For help about the Menu Manager module, what parameters it takes etc., please refer to the Menu Manager module help.</p>
  <p>By default, if no template option is specified the minimal_menu.tpl file will be used.</p>
  <p>Any parameters used in the tag are available in the menumanager template as <code>{$menuparams.paramname}</code></p>';
$lang['admin']['help_function_redirect_url'] = '<h3>What does this do?</h3>
  <p>This plugin allows you to easily redirect to a specified url.  It is handy inside of smarty conditional logic (for example, redirect to a splash page if the site is not live yet). </p>
<h3>How do I use it?</h3>
<p>Simply insert this tage into your page or template: <code>{redirect_url to=&#039;http://www.cmsmadesimple.org&#039;}</code></p>';
$lang['admin']['help_function_redirect_page'] = '<h3>What does this do?</h3>
 <p>This plugin allows you to easily redirect to another page.  It is handy inside of smarty conditional logic (for example, redirect to a login page if the user is not logged in.)</p>
<h3>How do I use it?</h3>
<p>Simply insert this tage into your page or template: <code>{redirect_page page=&#039;some-page-alias&#039;}</code></p> ';
$lang['admin']['help_function_cms_jquery'] = '<h3>What does this do?</h3>
 <p>This plugin allows you output the javascript libraries and plugins used from the admin.</p>
<h3>How do I use it?</h3>
<p>Simply insert this tag into your page or template: <code>{cms_jquery}</code></p>

<h3>Sample</h3>
<pre><code>{cms_jquery cdn=&#039;true&#039; exclude=&#039;jquery.ui.nestedSortable-1.3.4.js&#039; append=&#039;uploads/NCleanBlue/js/ie6fix.js&#039;}</code></pre>
<h4><em>Outputs</em></h4>
<pre><code>&amp;lt;script type=&quot;text/javascript&quot; src=&quot;https://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js&quot;&amp;gt;&amp;lt;/script&amp;gt;
&amp;lt;script type=&quot;text/javascript&quot; src=&quot;https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.16/jquery-ui.min.js&quot;&amp;gt;&amp;lt;/script&amp;gt;
&amp;lt;script type=&quot;text/javascript&quot; src=&quot;http://localhost/1.10.x/lib/jquery/js/jquery.json-2.2.js&quot;&amp;gt;&amp;lt;/script&amp;gt;
&amp;lt;script type=&quot;text/javascript&quot; src=&quot;uploads/NCleanBlue/js/ie6fix.js&quot;&amp;gt;&amp;lt;/script&amp;gt;
</code></pre>

<h3><em>Included Defaults</em></h3>
<ul>
	<li><tt>jQuery</tt><em>(1.7.1)</em> - jquery-1.7.1.min.js</li>
	<li><tt>jQuery UI</tt><em>(1.8.16)</em> - jquery-ui-1.8.16.min.js</li>
	<li><tt>nestedSortable</tt>(1.3.4) - jquery/js/jquery.ui.nestedSortable-1.3.4.js</li>
	<li><tt>jQuery json</tt><em>(2.2)</em> - jquery/js/jquery.json-2.2.js</li>
</ul>
    
<h3>What parameters does it take?</h3>
<ul>
	<li><em>(optional) </em><tt>exclude</tt> - use comma seperated value(CSV) list of scripts you would like to exclude. <code>&#039;jquery.ui.nestedSortable.js,jquery.json-2.2.js&#039;</code></li>
	<li><em>(optional) </em><tt>append</tt> - use comma seperated value(CSV) list of script paths you would like to append. <code>&#039;/uploade/jquery.ui.nestedSortable.js,http://code.jquery.com/jquery-1.6.2.min.js&#039;</code></li>
	<li><em>(optional) </em><tt>cdn</tt> - cdn=&#039;true&#039; will insert jQuery and jQueryUI Frameworks using Google&#039;s Content Delivery Netwok. Default is false.</li>
	<li><em>(optional) </em><tt>ssl</tt> - use to use the ssl_url as the base path.</li>
	<li><em>(optional) </em><tt>custom_root</tt> - use to set any base path wished.<code>custom_root=&#039;http://test.domain.com/&#039;</code> <br/>NOTE: overwrites ssl option and works with the cdn option</li>
	<li><em>(optional)</em> <tt>assign</tt> - Assign the results to the named smarty variable.</li>
	</ul>';
$lang['admin']['of'] = 'van';
$lang['admin']['first'] = 'Eerste';
$lang['admin']['last'] = 'Laatste';
$lang['admin']['adminspecialgroup'] = 'Waarschuwing: leden van deze groep hebben automatisch alle rechten';
$lang['admin']['disablesafemodewarning'] = 'Safe mode-waarschuwing buiten werking stellen';
$lang['admin']['date_format_string'] = 'Tekenreeks met datumopmaak';
$lang['admin']['date_format_string_help'] = '<em>strftime</em> tekenreeks met datumopmaak. Google naar &#039;strftime&#039; voor meer informatie';
$lang['admin']['last_modified_at'] = 'Laatst aangepast op';
$lang['admin']['last_modified_by'] = 'Laatst aangepast door';
$lang['admin']['read'] = 'Lees';
$lang['admin']['write'] = 'Schrijf';
$lang['admin']['execute'] = 'Uitvoeren';
$lang['admin']['group'] = 'Groep';
$lang['admin']['other'] = 'Andere';
$lang['admin']['event_desc_moduleupgraded'] = 'Een tag die wordt aangeroepen nadat een module is ge&uuml;pgrade';
$lang['admin']['event_help_moduleupgraded'] = '<p>Een tag die wordt aangeroepen nadat een module is ge&uuml;pgrade.</p>';
$lang['admin']['event_desc_moduleinstalled'] = 'Een tag die wordt aangeroepen nadat een module is ge&iuml;nstalleerd';
$lang['admin']['event_help_moduleinstalled'] = '<p>Een tag die wordt aangeroepen nadat een module is ge&iuml;nstalleerd.</p>';
$lang['admin']['event_desc_moduleuninstalled'] = 'Een tag die wordt aangeroepen nadat een module is gede&iuml;nstalleerd';
$lang['admin']['event_help_moduleuninstalled'] = '<p>Een tag die wordt aangeroepen nadat een module is gede&iuml;nstalleerd.</p>';
$lang['admin']['event_desc_edituserdefinedtagpost'] = 'Een tag die wordt aangeroepen na het bijwerken van gebruikers-gedefinieerde tag';
$lang['admin']['event_help_edituserdefinedtagpost'] = '<p>Een tag die wordt aangeroepen na het bijwerken van gebruikers-gedefinieerde tag.</p>';
$lang['admin']['event_desc_edituserdefinedtagpre'] = 'Een tag die wordt aangeroepen voor het bijwerken van gebruikers-gedefinieerde tag';
$lang['admin']['event_help_edituserdefinedtagpre'] = '<p>Een tag die wordt aangeroepen voor het bijwerken van gebruikers-gedefinieerde tag.</p>';
$lang['admin']['event_desc_deleteuserdefinedtagpre'] = 'Een tag die wordt aangeroepen na het verwijderen van gebruikers-gedefinieerde tag';
$lang['admin']['event_help_deleteuserdefinedtagpre'] = '<p>Een tag die wordt aangeroepen na het verwijderen van gebruikers-gedefinieerde tag.</p>';
$lang['admin']['event_desc_deleteuserdefinedtagpost'] = 'Een tag die wordt aangeroepen na het verwijderen van gebruikers-gedefinieerde tag';
$lang['admin']['event_help_deleteuserdefinedtagpost'] = '<p>Een tag die wordt aangeroepen na het verwijderen van gebruikers-gedefinieerde tag.</p>';
$lang['admin']['event_desc_adduserdefinedtagpost'] = 'Een tag die wordt aangeroepen na toevoegen van gebruikers-gedefinieerde tag';
$lang['admin']['event_help_adduserdefinedtagpre'] = '<p>Een tag die wordt aangeroepen na toevoegen van gebruikers-gedefinieerde tag.</p>';
$lang['admin']['event_desc_adduserdefinedtagpre'] = 'Een tag die wordt aangeroepen voor het toevoegen van gebruikers-gedefinieerde tag';
$lang['admin']['event_help_adduserdefinedtagpost'] = '<p>Een tag die wordt aangeroepen voor het toevoegen van gebruikers-gedefinieerde tag.</p>';
$lang['admin']['global_umask'] = 'Bestandscreatiemasker (umask)';
$lang['admin']['errorcantcreatefile'] = 'Kan geen bestand aanmaken (rechtenprobleem?)';
$lang['admin']['errormoduleversionincompatible'] = 'Module is incompatibel met deze CMS-versie';
$lang['admin']['errormodulenotloaded'] = 'Interne fout, de module is niet ge&iuml;nstantieerd.';
$lang['admin']['errormodulenotfound'] = 'Interne fout, kan de moduleinstantie niet vinden.';
$lang['admin']['errorinstallfailed'] = 'Moduleinstallatie is mislukt';
$lang['admin']['errormodulewontload'] = 'Probleem bij het instantieren van een beschikbare module';
$lang['admin']['frontendlang'] = 'Standaardtaal voor de frontend van de website';
$lang['admin']['info_edituser_password'] = 'Dit veld wijzigen om het gebruikerswachtwoord te veranderen';
$lang['admin']['info_edituser_passwordagain'] = 'Dit veld wijzigen om het gebruikerswachtwoord te veranderen';
$lang['admin']['originator'] = 'Versturende module';
$lang['admin']['module_name'] = 'Modulenaam';
$lang['admin']['event_name'] = 'Gebeurtenisnaam';
$lang['admin']['event_description'] = 'Gebeurtenisomschrijving';
$lang['admin']['error_delete_default_parent'] = 'U kunt de standaardpagina of de bovenliggende pagina van de standaardpagina niet verwijderen.';
$lang['admin']['jsdisabled'] = 'Sorry, deze functie vereist dat Javascript geactiveerd is.';
$lang['admin']['order'] = 'Volgorde';
$lang['admin']['reorderpages'] = 'Pagina&#039;s herschikken';
$lang['admin']['reorder'] = 'Wijzig volgorde';
$lang['admin']['page_reordered'] = 'Pagina met succes verplaatst.';
$lang['admin']['pages_reordered'] = 'Pagina&#039;s met succes verplaatst';
$lang['admin']['sibling_duplicate_order'] = 'Twee pagina&#039;s binnen hetzelfde niveau kunnen niet dezelfde positie hebben. De pagina&#039;s zijn niet herschikt.';
$lang['admin']['no_orders_changed'] = 'Geen wijzigingen in de pagina volgorde. De pagina&#039;s zijn niet verplaatst.';
$lang['admin']['order_too_small'] = 'Een paginapositie kan geen nul zijn. De pagina&#039;s zijn niet verplaatst.';
$lang['admin']['order_too_large'] = 'Een pagina positie kan niet groter zijn dan het aantal pagina&#039;s binnen dat niveau. De pagina&#039;s zijn niet verplaatst.';
$lang['admin']['user_tag'] = 'Gebruikersgedefinieerde tag (UDT)';
$lang['admin']['add'] = 'Toevoegen';
$lang['admin']['CSS'] = 'CSS ';
$lang['admin']['about'] = 'Over';
$lang['admin']['action'] = 'Bewerking';
$lang['admin']['actionstatus'] = 'Bewerking / Status';
$lang['admin']['active'] = 'Actief';
$lang['admin']['addcontent'] = 'Nieuwe inhoud toevoegen';
$lang['admin']['cantremove'] = 'Kan niet verwijderen';
$lang['admin']['changepermissions'] = 'Wijzig rechten';
$lang['admin']['changepermissionsconfirm'] = 'WEES VOORZICHTIG\n\n Deze bewerking probeert alle bestanden waaruit de module bestaat schrijfbaar voor de webserver te maken.\nWeet u zeker dat u door wilt gaan?';
$lang['admin']['contentadded'] = 'De inhoud is aan de database toegevoegd.';
$lang['admin']['contentupdated'] = 'De inhoud is bijgewerkt.';
$lang['admin']['contentdeleted'] = 'De inhoud is uit de database verwijderd.';
$lang['admin']['success'] = 'Succes';
$lang['admin']['addcss'] = 'Stylesheet toevoegen';
$lang['admin']['addgroup'] = 'Groep toevoegen';
$lang['admin']['additionaleditors'] = 'Andere editors';
$lang['admin']['addtemplate'] = 'Sjabloon toevoegen';
$lang['admin']['adduser'] = 'Gebruiker toevoegen';
$lang['admin']['addusertag'] = 'Tag toevoegen';
$lang['admin']['adminaccess'] = 'Login voor beheertoegang';
$lang['admin']['adminlog'] = 'Beheerlogboek';
$lang['admin']['adminlogcleared'] = 'Het beheerlogboek is gewist';
$lang['admin']['adminlogempty'] = 'Het beheerlogboek is leeg';
$lang['admin']['adminsystemtitle'] = 'CMS-beheersysteem';
$lang['admin']['adminpaneltitle'] = 'CMS Made Simple beheerpaneel';
$lang['admin']['advanced'] = 'Geavanceerd';
$lang['admin']['aliasalreadyused'] = 'Deze alias is al gebruikt voor een andere pagina. Verander &quot;Pagina-alias&quot; in het Opties-tabblad.';
$lang['admin']['aliasmustbelettersandnumbers'] = 'Alias mag alleen uit letters en cijfers bestaan.';
$lang['admin']['aliasnotaninteger'] = 'Alias mag geen getal zijn';
$lang['admin']['allpagesmodified'] = 'Alle pagina&#039;s zijn aangepast!';
$lang['admin']['assignments'] = 'Gebruikers toewijzen';
$lang['admin']['associationexists'] = 'Deze toewijzing bestaat al';
$lang['admin']['autoinstallupgrade'] = 'Automatisch installeren of bijwerken';
$lang['admin']['back'] = 'Terug naar menu';
$lang['admin']['backtoplugins'] = 'Terug naar plugin-lijst';
$lang['admin']['cancel'] = 'Annuleren';
$lang['admin']['cantchmodfiles'] = 'Kan de rechten van sommige bestanden niet wijzigen';
$lang['admin']['cantremovefiles'] = 'Probleem bij het verwijderen van bestanden (rechten?)';
$lang['admin']['confirmcancel'] = 'Wijzigingen negeren? Klik op OK om alle wijzigingen te negeren. Klik op Annuleren om door te gaan met wijzigen.';
$lang['admin']['canceldescription'] = 'Wijzigingen negeren';
$lang['admin']['clearadminlog'] = 'Maak beheerlogboek leeg';
$lang['admin']['code'] = 'Code ';
$lang['admin']['confirmdefault'] = 'Weet u zeker dat u - %s - als de standaardpagina van de website wilt instellen?';
$lang['admin']['confirmdeletedir'] = 'Weet u zeker dat u deze map met alle inhoud wilt verwijderen?';
$lang['admin']['content'] = 'Inhoud';
$lang['admin']['contentmanagement'] = 'Inhoudsbeheer';
$lang['admin']['contenttype'] = 'Inhoudstype';
$lang['admin']['copy'] = 'Kopieer';
$lang['admin']['copytemplate'] = 'Kopieer sjabloon';
$lang['admin']['create'] = 'Maak';
$lang['admin']['createnewfolder'] = 'Maak nieuwe map';
$lang['admin']['cssalreadyused'] = 'CSS-naam is al in gebruik';
$lang['admin']['cssmanagement'] = 'CSS-beheer';
$lang['admin']['currentassociations'] = 'Huidige verwijzingen';
$lang['admin']['currentdirectory'] = 'Huidige map';
$lang['admin']['currentgroups'] = 'Huidige groepen';
$lang['admin']['currentpages'] = 'Huidige pagina&#039;s';
$lang['admin']['currenttemplates'] = 'Huidige sjablonen';
$lang['admin']['currentusers'] = 'Huidige gebruikers';
$lang['admin']['custom404'] = 'Aangepaste 404-foutmelding';
$lang['admin']['database'] = 'Database ';
$lang['admin']['databaseprefix'] = 'Database voorvoegsel';
$lang['admin']['databasetype'] = 'Database type';
$lang['admin']['date'] = 'Datum';
$lang['admin']['default'] = 'Standaard';
$lang['admin']['delete'] = 'Verwijderen';
$lang['admin']['deleteconfirm'] = 'Weet u zeker dat u - %s - wilt verwijderen?';
$lang['admin']['deleteassociationconfirm'] = 'Weet u zeker dat u de verwijzing naar - %s - wilt verwijderen?';
$lang['admin']['deletecss'] = 'Verwijder CSS';
$lang['admin']['dependencies'] = 'Afhankelijkheden';
$lang['admin']['description'] = 'Omschrijving';
$lang['admin']['directoryexists'] = 'Deze map bestaat al.';
$lang['admin']['down'] = 'Omlaag';
$lang['admin']['edit'] = 'Bewerk';
$lang['admin']['editconfiguration'] = 'Configuratie bewerken';
$lang['admin']['editcontent'] = 'Inhoud bewerken';
$lang['admin']['editcss'] = 'Stylesheet bewerken';
$lang['admin']['editcsssuccess'] = 'Stylesheet bijgewerkt';
$lang['admin']['editgroup'] = 'Groep bewerken';
$lang['admin']['editpage'] = 'Pagina bewerken';
$lang['admin']['edittemplate'] = 'Sjabloon bewerken';
$lang['admin']['edittemplatesuccess'] = 'Sjabloon bijgewerkt';
$lang['admin']['edituser'] = 'Gebruiker bewerken';
$lang['admin']['editusertag'] = 'Gebruikersgedefinieerde tag (UDT) bewerken';
$lang['admin']['usertagadded'] = 'Gebruikersgedefinieerde tag (UDT) is toegevoegd.';
$lang['admin']['usertagupdated'] = 'Gebruikersgedefinieerde tag (UDT) is bijgewerkt.';
$lang['admin']['usertagdeleted'] = 'Gebruikersgedefinieerde tag (UDT) is verwijderd.';
$lang['admin']['email'] = 'E-mailadres';
$lang['admin']['errorattempteddowngrade'] = 'Moduleinstallatie zou resulteren in een downgrade. Handeling afgebroken.';
$lang['admin']['errorchildcontent'] = 'Pagina bevat gekoppelde pagina&#039;s. Verwijder deze eerst.';
$lang['admin']['errorcopyingtemplate'] = 'Fout bij kopi&euml;ren van de sjabloon';
$lang['admin']['errorcouldnotparsexml'] = 'Fout bij het verwerken van het XML-bestand. Vergewis u ervan dat u een .xml-bestand upload and geen .tar.gz of .zip-bestand';
$lang['admin']['errorcreatingassociation'] = 'Fout bij aanmaken van de verwijzing';
$lang['admin']['errorcssinuse'] = 'Deze stylesheet is nog in gebruik door een of meer sjablonen en/of pagina&#039;s. Verwijder deze verwijzingen eerst.';
$lang['admin']['errordefaultpage'] = 'Kan de standaardpagina niet verwijderen. Definieer eerst een nieuwe.';
$lang['admin']['errordeletingassociation'] = 'Fout bij verwijderen van verwijzing';
$lang['admin']['errordeletingcss'] = 'Fout bij verwijderen stylesheet';
$lang['admin']['errordeletingdirectory'] = 'Kan map niet verwijderen. Controleer of dit een rechtenprobleem is.';
$lang['admin']['errordeletingfile'] = 'Kan bestand niet verwijderen. Controleer of dit een rechtenprobleem is.';
$lang['admin']['errordirectorynotwritable'] = 'Geen rechten om in map te schrijven. Dit kan veroorzaakt worden door bestands- en eigendomsrechten. De veilige modus (PHP safe mode) kan ook aanstaan.';
$lang['admin']['errordtdmismatch'] = 'DTD-versie mist of is onverenigbaar met het XML-bestand';
$lang['admin']['errorgettingcssname'] = 'Fout bij opvragen van stylesheetnaam';
$lang['admin']['errorgettingtemplatename'] = 'Fout bij opvragen van sjabloonnaam';
$lang['admin']['errorincompletexml'] = 'XML-bestand is incompleet of fout';
$lang['admin']['uploadxmlfile'] = 'Installeer module via XML-bestand';
$lang['admin']['cachenotwritable'] = 'De cachemap is niet schrijfbaar. Het legen van de cache is niet mogelijk. Zorg dat de map tmp/cache volledig lees/schrijf/uitvoer rechten heeft (chmod 777). Ook kan het nodig zijn de veilige modus (PHP safe mode) uit te schakelen.';
$lang['admin']['error_nomodules'] = 'Er zijn geen modules ge&iuml;nstalleerd! Controleer Uitbreidingen > Modules';
$lang['admin']['modulesnotwritable'] = 'De modulemap <em>(en/of de uploads map)</em> is niet schrijfbaar. Om modules te installeren door een XML-bestand te uploaden, moet de modulemap volledige lees/schrijf/uitvoer rechten hebben (chmod 777). De veilige modus (PHP safe mode) zou ook aan kunnen staan...';
$lang['admin']['noxmlfileuploaded'] = 'Geen bestand ge&uuml;pload. Om een module via XML te installeren dient een module .xml bestand op uw computer gekozen en ge-upload worden.';
$lang['admin']['errorinsertingcss'] = 'Fout bij toevoegen van stylesheet';
$lang['admin']['errorinsertinggroup'] = 'Fout bij toevoegen van groep';
$lang['admin']['errorinsertingtag'] = 'Fout bij toevoegen van gebruikersgedefinieerde tag';
$lang['admin']['errorinsertingtemplate'] = 'Fout bij toevoegen van sjabloon';
$lang['admin']['errorinsertinguser'] = 'Fout bij toevoegen van gebruiker';
$lang['admin']['errornofilesexported'] = 'Fout bij exporteren van bestanden naar XML';
$lang['admin']['errorretrievingcss'] = 'Fout bij opvragen van stylesheet';
$lang['admin']['errorretrievingtemplate'] = 'Fout bij opvragen van sjabloon';
$lang['admin']['errortemplateinuse'] = 'Dit sjabloon is nog in gebruik door een pagina. Verwijder deze eerst.';
$lang['admin']['errorupdatingcss'] = 'Fout bij het bijwerken van stylesheet';
$lang['admin']['errorupdatinggroup'] = 'Fout bij het bijwerken van groep';
$lang['admin']['errorupdatingpages'] = 'Fout bij het bijwerken van de pagina&#039;s';
$lang['admin']['errorupdatingtemplate'] = 'Fout bij het bijwerken van het sjabloon';
$lang['admin']['errorupdatinguser'] = 'Fout bij het bijwerken van de gebruiker';
$lang['admin']['errorupdatingusertag'] = 'Fout bij het bijwerken van de gebruiker-tag';
$lang['admin']['erroruserinuse'] = 'Deze gebruiker is nog eigenaar van pagina&#039;s. Wijs een nieuwe eigenaar toe voordat de oude wordt verwijderd.';
$lang['admin']['eventhandlers'] = 'Gebeurtenissen Beheer';
$lang['admin']['eventhandler'] = 'Gekoppelde tags';
$lang['admin']['editeventhandler'] = 'Gebeurtenisverwerker bewerken';
$lang['admin']['eventhandlerdescription'] = 'Koppel gebruikersgedefinieerde tags (UDT) aan gebeurtenissen';
$lang['admin']['export'] = 'Exporteer';
$lang['admin']['event'] = 'Gebeurtenis';
$lang['admin']['false'] = 'Onwaar';
$lang['admin']['settrue'] = 'Zet op Waar (true)';
$lang['admin']['filecreatedirnodoubledot'] = 'De volgende tekens mogen niet voorkomen in een map naam: &#039;..&#039;.';
$lang['admin']['filecreatedirnoname'] = 'Kan geen map zonder naam aanmaken.';
$lang['admin']['filecreatedirnoslash'] = 'Map kan geen &#039;/&#039; of &#039;\&#039; bevatten.';
$lang['admin']['filemanagement'] = 'Bestandsbeheer';
$lang['admin']['filename'] = 'Bestandsnaam';
$lang['admin']['filenotuploaded'] = 'Bestand kan niet ge&iuml;mporteerd worden. Controleer of dit een rechtenprobleem of een probleem met veilig modus is.';
$lang['admin']['filesize'] = 'Bestandsgrootte';
$lang['admin']['firstname'] = 'Voornaam';
$lang['admin']['groupmanagement'] = 'Groepsbeheer';
$lang['admin']['grouppermissions'] = 'Groepsrechten';
$lang['admin']['handler'] = 'Verwerker (gebruikergedefinieerd tag)';
$lang['admin']['headtags'] = 'Tags voor pagina head';
$lang['admin']['help'] = 'Uitleg';
$lang['admin']['new_window'] = 'nieuw venster';
$lang['admin']['helpwithsection'] = 'Hulp bij %s';
$lang['admin']['helpaddtemplate'] = '<p>Een sjabloon (template) bepaalt hoe uw site er uitziet.</p><p>Maak het sjabloon hier aan en voeg tevens uw CSS aan het stylesheet-gedeelte toe, zodat u het uiterlijk van uw site zelf kunt bepalen.</p>';
$lang['admin']['helplisttemplate'] = '<p>Via deze pagina kunt u sjablonen aanpassen, verwijderen en nieuwe aanmaken.</p><p>Om een nieuw sjabloon aan te maken klikt u op <u>Nieuw sjabloon</u> .</p><p>Om hetzelfde sjabloon voor alle pagina&#039;s te gebruiken, kies <u>Alle</u>.</p><p>Om een sjabloon te kopi&euml;ren klik op het <u>kopieer</u>ikoon en geef een naam op voor het nieuwe sjabloon.</p>';
$lang['admin']['home'] = 'Start';
$lang['admin']['homepage'] = 'Startpagina';
$lang['admin']['hostname'] = 'Hostnaam';
$lang['admin']['idnotvalid'] = 'De ingevoerde ID is niet correct';
$lang['admin']['imagemanagement'] = 'Afbeeldingsbeheer';
$lang['admin']['informationmissing'] = 'Er ontbreekt informatie';
$lang['admin']['install'] = 'Installeer';
$lang['admin']['invalidcode'] = 'Niet correcte code ingevoerd.';
$lang['admin']['illegalcharacters'] = 'Ongeldige karakters in veld %s.';
$lang['admin']['invalidcode_brace_missing'] = 'Oneven aantal haakjes';
$lang['admin']['invalidtemplate'] = 'Het sjabloon is niet correct';
$lang['admin']['itemid'] = 'Item-id';
$lang['admin']['itemname'] = 'Item-naam';
$lang['admin']['language'] = 'Taal';
$lang['admin']['lastname'] = 'Achternaam';
$lang['admin']['logout'] = 'Uitloggen';
$lang['admin']['loginprompt'] = 'Voer een geldige gebruikersnaam en wachtwoord combinatie in om toegang te krijgen tot het beheerpaneel.';
$lang['admin']['logintitle'] = 'CMS Made Simple beheerlogin';
$lang['admin']['menutext'] = 'Menutekst';
$lang['admin']['missingparams'] = 'Enkele parameters ontbraken of waren niet correct';
$lang['admin']['modifygroupassignments'] = 'Groepstoekenningen wijzigen';
$lang['admin']['moduleabout'] = 'Over de %s module';
$lang['admin']['modulehelp'] = 'Hulp bij de %s module';
$lang['admin']['msg_defaultcontent'] = 'Voeg hier code toe dat verschijnt als standaardinhoud in alle nieuwe pagina&#039;s';
$lang['admin']['msg_defaultmetadata'] = 'Voeg hier code toe dat verschijnt in de metadatasectie in alle nieuwe pagina&#039;s';
$lang['admin']['wikihelp'] = 'Gemeenschapshulp';
$lang['admin']['moduleinstalled'] = 'Module is al ge&iuml;nstalleerd';
$lang['admin']['moduleinterface'] = '%s interface';
$lang['admin']['modules'] = 'Modules ';
$lang['admin']['move'] = 'Verplaatsen';
$lang['admin']['name'] = 'Naam';
$lang['admin']['needpermissionto'] = 'U heeft &#039;%s&#039; recht nodig om dit te kunnen uitvoeren.';
$lang['admin']['needupgrade'] = 'Moet bijgewerkt worden';
$lang['admin']['newtemplatename'] = 'Nieuwe sjabloonnaam';
$lang['admin']['next'] = 'Volgende';
$lang['admin']['noaccessto'] = 'Geen toegang tot %s';
$lang['admin']['nocss'] = 'Geen stylesheet';
$lang['admin']['noentries'] = 'Geen gegevens';
$lang['admin']['nofieldgiven'] = '%s niet opgegeven!';
$lang['admin']['nofiles'] = 'Geen bestanden';
$lang['admin']['nopasswordmatch'] = 'De wachtwoorden komen niet overeen';
$lang['admin']['norealdirectory'] = 'Deze map bestaat niet';
$lang['admin']['norealfile'] = 'Geen bestaand bestand opgegeven';
$lang['admin']['notinstalled'] = 'Niet ge&iuml;nstalleerd';
$lang['admin']['overwritemodule'] = 'Bestaande modules overschrijven';
$lang['admin']['owner'] = 'Eigenaar';
$lang['admin']['pagealias'] = 'Pagina alias';
$lang['admin']['content_id'] = 'Content Id';
$lang['admin']['pagedefaults'] = 'Paginastandaarden';
$lang['admin']['pagedefaultsdescription'] = 'Stel de standaardwaarden in voor nieuwe pagina&#039;s';
$lang['admin']['parent'] = 'Bovenliggend';
$lang['admin']['password'] = 'Wachtwoord';
$lang['admin']['passwordagain'] = 'Wachtwoord (nogmaals)';
$lang['admin']['permission'] = 'Recht';
$lang['admin']['permissions'] = 'Rechten';
$lang['admin']['permissionschanged'] = 'Rechten zijn bijgewerkt';
$lang['admin']['pluginabout'] = 'Over de %s tag';
$lang['admin']['pluginhelp'] = 'Hulp bij de %s tag';
$lang['admin']['pluginmanagement'] = 'Plugin Beheer';
$lang['admin']['prefsupdated'] = 'Voorkeuren zijn bijgewerkt.';
$lang['admin']['accountupdated'] = 'Gebruikersaccount is bijgewerkt.';
$lang['admin']['preview'] = 'Voorbeeld';
$lang['admin']['previewdescription'] = 'Voorbeeld wijzigingen';
$lang['admin']['previous'] = 'Vorige';
$lang['admin']['remove'] = 'Verwijderen';
$lang['admin']['removeconfirm'] = 'Hiermee worden de bestanden van deze module installatie volledig verwijderd.\nDoorgaan?';
$lang['admin']['removecssassociation'] = 'Stylesheetkoppeling verwijderen';
$lang['admin']['saveconfig'] = 'Configuratie opslaan';
$lang['admin']['send'] = 'Versturen';
$lang['admin']['setallcontent'] = 'Gebruik voor alle pagina&#039;s';
$lang['admin']['setallcontentconfirm'] = 'Wilt u dit sjabloon voor alle pagina&#039;s gebruiken?';
$lang['admin']['showinmenu'] = 'Toon in menu';
$lang['admin']['use_name'] = 'Gebruik de paginanaam, in plaats van de menutekst in de dropdown';
$lang['admin']['showsite'] = 'Toon website';
$lang['admin']['sitedownmessage'] = 'Melding dat de website buiten gebruik is';
$lang['admin']['siteprefs'] = 'Algemene instellingen';
$lang['admin']['status'] = 'Status ';
$lang['admin']['stylesheet'] = 'Stylesheet ';
$lang['admin']['submit'] = 'Versturen';
$lang['admin']['submitdescription'] = 'Wijzigingen opslaan';
$lang['admin']['tags'] = 'Tags ';
$lang['admin']['template'] = 'Sjabloon';
$lang['admin']['templateexists'] = 'Sjabloonnaam bestaat al';
$lang['admin']['templatemanagement'] = 'Sjabloonbeheer';
$lang['admin']['title'] = 'Titel';
$lang['admin']['tools'] = 'Gereedschappen';
$lang['admin']['true'] = 'Waar';
$lang['admin']['setfalse'] = 'Zet op onwaar (false)';
$lang['admin']['type'] = 'Type ';
$lang['admin']['typenotvalid'] = 'Type is niet correct';
$lang['admin']['uninstall'] = 'De&iuml;nstalleer';
$lang['admin']['uninstallconfirm'] = 'Weet u zeker dat u deze module wilt de&iuml;nstalleren?';
$lang['admin']['up'] = 'Omhoog';
$lang['admin']['upgrade'] = 'Bijwerken';
$lang['admin']['upgradeconfirm'] = 'Weet u zeker dat u dit wilt bijwerken?';
$lang['admin']['uploadfile'] = 'Bestand uploaden';
$lang['admin']['url'] = 'Url';
$lang['admin']['useadvancedcss'] = 'Geavanceerd stylesheetbeheer gebruiken';
$lang['admin']['user'] = 'Gebruiker';
$lang['admin']['userdefinedtags'] = 'Gebruikergedefinieerde tags (UDT)';
$lang['admin']['usermanagement'] = 'Gebruikersbeheer';
$lang['admin']['username'] = 'Gebruikersnaam';
$lang['admin']['usernameincorrect'] = 'Gebruikersnaam of wachtwoord incorrect';
$lang['admin']['userprefs'] = 'Gebruikersinstellingen';
$lang['admin']['useraccount'] = 'Gebruikersaccount';
$lang['admin']['lang_settings_legend'] = 'Taal gerelateerde instellingen';
$lang['admin']['content_editor_legend'] = 'Instellingen voor bewerken van inhoud';
$lang['admin']['admin_layout_legend'] = 'Instellingen voor lay-out admin';
$lang['admin']['usersassignedtogroup'] = 'Gebruikers aan groep %s toegewezen';
$lang['admin']['usertagexists'] = 'Een tag met deze naam bestaat al. Kies een andere naam.';
$lang['admin']['usewysiwyg'] = 'WYSIWYG editor gebruiken';
$lang['admin']['version'] = 'Versie';
$lang['admin']['view'] = 'Bekijk';
$lang['admin']['welcomemsg'] = 'Welkom %s';
$lang['admin']['directoryabove'] = 'Bovenliggende map';
$lang['admin']['nodefault'] = 'Geen standaard geselecteerd';
$lang['admin']['blobexists'] = 'HTML-bloknaam bestaat al';
$lang['admin']['blobmanagement'] = 'HTML-blokbeheer';
$lang['admin']['errorinsertingblob'] = 'Er was een fout bij het invoegen van het HTML-blok';
$lang['admin']['addhtmlblob'] = 'HTML-blok toevoegen';
$lang['admin']['edithtmlblob'] = 'HTML-blok bewerken';
$lang['admin']['edithtmlblobsuccess'] = 'HTML-blok bijgewerkt';
$lang['admin']['tagtousegcb'] = 'Tag om dit HTML-blok te gebruiken';
$lang['admin']['gcb_wysiwyg'] = 'Activeer HTML-blok WYSIWYG';
$lang['admin']['gcb_wysiwyg_help'] = 'Activeer de WYSIWYG-editor tijdens het bewerken van HTML-blokken';
$lang['admin']['filemanager'] = 'Bestandsbeheer';
$lang['admin']['imagemanager'] = 'Afbeeldingbeheer';
$lang['admin']['encoding'] = 'Codering';
$lang['admin']['clearcache'] = 'Buffer wissen';
$lang['admin']['clear'] = 'Wissen';
$lang['admin']['cachecleared'] = 'Buffer gewist';
$lang['admin']['apply'] = 'Toepassen';
$lang['admin']['applydescription'] = 'Wijzigingen opslaan en doorgaan met bewerken';
$lang['admin']['none'] = 'geen';
$lang['admin']['wysiwygtouse'] = 'Selecteer de WYSIWYG-editor';
$lang['admin']['syntaxhighlightertouse'] = 'Selecteer de syntax highlighter';
$lang['admin']['hasdependents'] = 'Heeft afhankelijkheden';
$lang['admin']['missingdependency'] = 'Noodzakelijke hulpmodule ontbreekt!';
$lang['admin']['minimumversion'] = 'Minimale versie';
$lang['admin']['minimumversionrequired'] = 'Minimaal benodigde CMSMS versie';
$lang['admin']['maximumversion'] = 'Maximale versie';
$lang['admin']['maximumversionsupported'] = 'Maximaal ondersteunde CMSMS versie';
$lang['admin']['depsformodule'] = 'Afhankelijke variabelen voor %s module';
$lang['admin']['installed'] = 'Ge&iuml;nstalleerd';
$lang['admin']['author'] = 'Auteur';
$lang['admin']['changehistory'] = 'Wijzigingen Geschiedenis';
$lang['admin']['moduleerrormessage'] = 'Foutmelding voor %s Module';
$lang['admin']['moduleupgradeerror'] = 'Er was een fout tijdens het opwaarderen van de module.';
$lang['admin']['moduleinstallmessage'] = 'Installatiebericht voor %s module';
$lang['admin']['moduleuninstallmessage'] = 'Boodschap bij verwijderen van %s module';
$lang['admin']['admintheme'] = 'Beheerthema';
$lang['admin']['addstylesheet'] = 'Een stylesheet toevoegen';
$lang['admin']['editstylesheet'] = 'Stylesheet veranderen';
$lang['admin']['addcssassociation'] = 'Eeen stylesheet-koppeling toevoegen';
$lang['admin']['attachstylesheet'] = 'Deze stylesheet koppelen';
$lang['admin']['attachtemplate'] = 'Aan deze sjabloon koppelen';
$lang['admin']['main'] = 'Start';
$lang['admin']['pages'] = 'Pagina&#039;s';
$lang['admin']['page'] = 'Pagina';
$lang['admin']['files'] = 'Bestanden';
$lang['admin']['layout'] = 'Opmaak';
$lang['admin']['usersgroups'] = 'Gebruikers/Groepen';
$lang['admin']['extensions'] = 'Uitbreidingen';
$lang['admin']['preferences'] = 'Voorkeuren';
$lang['admin']['admin'] = 'Websitebeheer';
$lang['admin']['viewsite'] = 'Site bekijken';
$lang['admin']['templatecss'] = 'Sjabloon aan stylesheet toewijzen';
$lang['admin']['plugins'] = 'Plugins ';
$lang['admin']['movecontent'] = 'Pagina&#039;s verplaatsen';
$lang['admin']['module'] = 'Module ';
$lang['admin']['usertags'] = 'Gebruikergedefinieerde tags';
$lang['admin']['htmlblobs'] = 'HTML-blokken';
$lang['admin']['adminhome'] = 'Beheer startpagina';
$lang['admin']['liststylesheets'] = 'Stylesheets ';
$lang['admin']['preferencesdescription'] = 'Beheer hier de website-brede instellingen.';
$lang['admin']['adminlogdescription'] = 'Logboek van beheersactiviteiten.';
$lang['admin']['mainmenu'] = 'Hoofdmenu';
$lang['admin']['users'] = 'Backend Gebruikers';
$lang['admin']['usersdescription'] = 'Hier beheert u de backend gebruikers van deze website';
$lang['admin']['groups'] = 'Backend Groepen';
$lang['admin']['groupsdescription'] = 'Hier beheert u de backend gebruikersgroepen';
$lang['admin']['groupassignments'] = 'Backend Groepstoekenningen';
$lang['admin']['groupassignmentdescription'] = 'Hier kunt u backend gebruikers aan groepen toewijzen.';
$lang['admin']['groupperms'] = 'Backend Groepsrechten';
$lang['admin']['grouppermsdescription'] = 'Beheerrechten en toegangsniveaus voor back-end groepen';
$lang['admin']['pagesdescription'] = 'Hier worden pagina&#039;s en andersoortige inhoud bewerkt en toegevoegd.';
$lang['admin']['htmlblobdescription'] = 'HTML-blokken zijn stukken (html) inhoud die op verschillende plekken in pagina&#039;s of sjablonen geplaatst kunnen worden.';
$lang['admin']['templates'] = 'Sjablonen';
$lang['admin']['templatesdescription'] = 'Beheer hier uw website-sjablonen. Deze verzorgen de opmaak van uw website.';
$lang['admin']['stylesheets'] = 'Stylesheets ';
$lang['admin']['stylesheetsdescription'] = 'Stylesheet beheer is een geavanceerde manier om CSS, gescheiden van uw sjablonen, toe te passen.';
$lang['admin']['filemanagerdescription'] = 'Bestanden uploaden en beheren.';
$lang['admin']['imagemanagerdescription'] = 'Afbeeldingen uploaden, bewerken en verwijderen.';
$lang['admin']['moduledescription'] = 'Modules breiden CMS Made Simple uit met allerhande functionaliteit.';
$lang['admin']['tagdescription'] = 'Tags zijn kleine stukjes PHP code die toegevoegd kunnen worden aan pagina&#039;s en/of sjablonen.';
$lang['admin']['usertagdescription'] = 'Tags die u zelf kunt aanmaken en onderhouden om specifieke taken uit te voeren.';
$lang['admin']['installdirwarning'] = '<em><strong>Waarschuwing:</strong></em> de Install map is nog aanwezig op de webserver. Voor uw eigen veiligheid moet u deze volledig verwijderen!';
$lang['admin']['subitems'] = 'Subonderdelen';
$lang['admin']['extensionsdescription'] = 'Modules, tags en andere gerelateerde zaken.';
$lang['admin']['usersgroupsdescription'] = 'Gebruikers- en groepsgerelateerde items';
$lang['admin']['layoutdescription'] = 'Website Opmaakfuncties';
$lang['admin']['admindescription'] = 'Website Beheerfuncties';
$lang['admin']['contentdescription'] = 'Beheer hier de inhoud van de site.';
$lang['admin']['enablecustom404'] = 'Onderstaand 404 bericht inschakelen';
$lang['admin']['enablesitedown'] = 'Melding Site onbereikbaar inschakelen';
$lang['admin']['enablewysiwyg'] = 'WYSIWYG toepassen op Site Onbereikbaar bericht';
$lang['admin']['bookmarks'] = 'Bladwijzers';
$lang['admin']['user_created'] = 'Gebruikerbladwijzers';
$lang['admin']['forums'] = 'Forums ';
$lang['admin']['wiki'] = 'Wiki ';
$lang['admin']['irc'] = 'IRC ';
$lang['admin']['team'] = 'Team ';
$lang['admin']['documentation'] = 'Documentatie';
$lang['admin']['module_help'] = 'Modulehulp';
$lang['admin']['managebookmarks'] = 'Bladwijzerbeheer';
$lang['admin']['editbookmark'] = 'Bladwijzer veranderen';
$lang['admin']['addbookmark'] = 'Bladwijzer toevoegen';
$lang['admin']['recentpages'] = 'Recente pagina&#039;s';
$lang['admin']['groupname'] = 'Groepsnaam';
$lang['admin']['selectgroup'] = 'Groep selecteren';
$lang['admin']['updateperm'] = 'Rechten bijwerken';
$lang['admin']['admincallout'] = 'Beheerbladwijzers';
$lang['admin']['showbookmarks'] = 'Beheerbladwijzers tonen';
$lang['admin']['hide_help_links'] = 'Modulehulp link verbergen';
$lang['admin']['hide_help_links_help'] = 'Schakel de module hulp link uit in de paginaheaders.';
$lang['admin']['showrecent'] = 'Toon onlangs gebruikte pagina&#039;s';
$lang['admin']['attachtotemplate'] = 'Koppel stylesheet aan een template';
$lang['admin']['attachstylesheets'] = 'Stylesheets koppelen';
$lang['admin']['indent'] = 'Paginalijst in laten springen om de hierarchie te benadrukken';
$lang['admin']['adminindent'] = 'Paginaweergave';
$lang['admin']['contract'] = 'Vouw sectie in';
$lang['admin']['expand'] = 'Vouw uit';
$lang['admin']['expandall'] = 'Vouw alle secties uit';
$lang['admin']['contractall'] = 'Vouw alle secties in';
$lang['admin']['menu_bookmarks'] = '[+] ';
$lang['admin']['globalconfig'] = 'Algemene instellingen';
$lang['admin']['adminpaging'] = 'Aantal inhoudsitems om te tonen per pagina in de paginalijst';
$lang['admin']['nopaging'] = 'Laat alle onderdelen zien';
$lang['admin']['myprefs'] = 'Mijn instellingen';
$lang['admin']['myprefsdescription'] = 'Hier kunt u de beheergedeelte naar uw wensen aanpassen';
$lang['admin']['myaccount'] = 'Mijn Account';
$lang['admin']['myaccountdescription'] = 'Hier kunt u uw persoonlijke accountgegevens aanpassen';
$lang['admin']['adminprefs'] = 'Gebruikersvoorkeuren';
$lang['admin']['adminprefsdescription'] = 'Hier stelt u eigen voorkeuren in voor het beheerpaneel.';
$lang['admin']['managebookmarksdescription'] = 'Hier beheert u uw bladwijzers.';
$lang['admin']['options'] = 'Opties';
$lang['admin']['langparam'] = 'Deze parameter wordt gebruikt om de taalkeuze aan te geven. Niet alle modules ondersteunen deze parameter (of hebben deze nodig).';
$lang['admin']['parameters'] = 'Parameters ';
$lang['admin']['mediatype'] = 'Mediatype';
$lang['admin']['media_query'] = 'Media Query ';
$lang['admin']['media_query_description'] = '<strong>Opmerking:</strong> Indien Media Query in gebruik is, zal de Media Type selectie genegeerd worden.<br /> Gebruik een geldige uitdrukking, zoals aanbevolen bij <a href="http://www.w3.org/TR/css3-mediaqueries/" rel="external" title="W3C">W3C</a>.';
$lang['admin']['mediatype_'] = 'Niets ingesteld : be&iuml;nvloed alles';
$lang['admin']['mediatype_all'] = 'all : geschikt voor alle apparaten';
$lang['admin']['mediatype_aural'] = 'aural : bedoeld voor spraaksynthesizers.';
$lang['admin']['mediatype_braille'] = 'braille : bedoeld voor braillegevoelsterugkoppelapparaten.';
$lang['admin']['mediatype_embossed'] = 'embossed : bedoeld voor brailleprinters.';
$lang['admin']['mediatype_handheld'] = 'handheld : bedoeld voor handheld-apparaten.';
$lang['admin']['mediatype_print'] = 'print : bedoeld voor opgemaakt, ondoorzichtig materiaal en voor documenten die op het scherm in printvoorbeeldmodus bekeken worden.';
$lang['admin']['mediatype_projection'] = 'projection : bedoeld voor geprojecteerde presentaties, bijvoorbeeld projectors of printen naar (transparante) sheets.';
$lang['admin']['mediatype_screen'] = 'screen : voornamelijk bedoeld voor kleurencomputerschermen.';
$lang['admin']['mediatype_tty'] = 'tty : bedoeld voor media die een &quot;fixed-pitch character grid&quot; gebruiken, zoals teletypes en terminals.';
$lang['admin']['mediatype_speech'] = 'spraak: Bedoelt voor spraaksynthesizers.';
$lang['admin']['mediatype_tv'] = 'tv : bedoeld voor televisieachtige apparaten.';
$lang['admin']['assignmentchanged'] = 'Groepstoewijzingen zijn bijgewerkt.';
$lang['admin']['stylesheetexists'] = 'Stylesheet bestaat al';
$lang['admin']['errorcopyingstylesheet'] = 'Fout bij kopi&euml;ren van de stylesheet';
$lang['admin']['copystylesheet'] = 'Stylesheet kopi&euml;ren';
$lang['admin']['newstylesheetname'] = 'Nieuwe stylesheet-naam';
$lang['admin']['target'] = 'Doel';
$lang['admin']['xml'] = 'XML ';
$lang['admin']['xmlmodulerepository'] = 'URL van de ModuleRepository SOAP server';
$lang['admin']['metadata'] = 'Metadata ';
$lang['admin']['globalmetadata'] = 'Algemene metadata';
$lang['admin']['titleattribute'] = 'Beschrijving (Titel-attribuut en meta-description)';
$lang['admin']['tabindex'] = 'Tabindex';
$lang['admin']['accesskey'] = 'Toegangstoets';
$lang['admin']['sitedownwarning'] = '<strong>Waarschuwing:</strong> u website laat op dit moment een &quot;Website is in onderhoud&quot; bericht zien.  Verwijder het %s bestand om dit op te veranderen.';
$lang['admin']['deletecontent'] = 'Inhoud verwijderen';
$lang['admin']['deletepages'] = 'Deze pagina&#039;s verwijderen?';
$lang['admin']['selectall'] = 'Alles selecteren';
$lang['admin']['selecteditems'] = 'Met geselecteerden';
$lang['admin']['inactive'] = 'Inactief';
$lang['admin']['deletetemplates'] = 'Sjablonen verwijderen';
$lang['admin']['templatestodelete'] = 'Deze sjablonen worden verwijderd';
$lang['admin']['wontdeletetemplateinuse'] = 'Deze sjablonen zijn in gebruik en worden niet verwijderd';
$lang['admin']['deletetemplate'] = 'Stylesheets verwijderen';
$lang['admin']['stylesheetstodelete'] = 'Deze stylesheets worden verwijderd';
$lang['admin']['sitename'] = 'Sitenaam';
$lang['admin']['goto'] = 'Terug naar:';
$lang['admin']['siteadmin'] = 'Sitebeheer';
$lang['admin']['images'] = 'Afbeeldingbeheer';
$lang['admin']['blobs'] = 'HTML-blokken';
$lang['admin']['groupmembers'] = 'Groepstaken';
$lang['admin']['troubleshooting'] = '(Probleemoplossing)';
$lang['admin']['event_desc_loginpost'] = 'Een tag die wordt aangeroepen nadat een gebruiker in het beheer paneel is ingelogd';
$lang['admin']['event_desc_logoutpost'] = 'Een tag die wordt aangeroepen nadat een gebruiker in het beheer paneel is uitgelogd';
$lang['admin']['event_desc_adduserpre'] = 'Een tag die wordt aangeroepen voordat een nieuwe gebruiker wordt aangemaakt';
$lang['admin']['event_desc_adduserpost'] = 'Een tag die wordt aangeroepen nadat een nieuwe gebruiker is aangemaakt';
$lang['admin']['event_desc_edituserpre'] = 'Een tag die wordt aangeroepen voordat bewerkingen aan een gebruiker worden opgeslagen';
$lang['admin']['event_desc_edituserpost'] = 'Een tag die wordt aangeroepen nadat bewerkingen aan een gebruiker zijn opgeslagen';
$lang['admin']['event_desc_deleteuserpre'] = 'Een tag die wordt aangeroepen voordat een gebruiker uit het systeem wordt verwijderd';
$lang['admin']['event_desc_deleteuserpost'] = 'Een tag die wordt aangeroepen nadat een gebruiker uit het systeem is verwijderd';
$lang['admin']['event_desc_addgrouppre'] = 'Een tag die wordt aangeroepen voordat een nieuwe groep wordt aangemaakt';
$lang['admin']['event_desc_addgrouppost'] = 'Een tag die wordt aangeroepen nadat een nieuwe groep is aangemaakt';
$lang['admin']['event_desc_changegroupassignpre'] = 'Een tag die wordt aangeroepen voordat een groeps toewijzing is opgeslagen';
$lang['admin']['event_desc_changegroupassignpost'] = 'Een tag die wordt aangeroepen nadat een groeps toewijzing is opgeslagen';
$lang['admin']['event_desc_editgrouppre'] = 'Een tag die wordt aangeroepen voordat bewerkingen aan een groep worden opgeslagen';
$lang['admin']['event_desc_editgrouppost'] = 'Een tag die wordt aangeroepen nadat bewerkingen aan een groep zijn opgeslagen';
$lang['admin']['event_desc_deletegrouppre'] = 'Een tag die wordt aangeroepen voordat een groep uit het systeem wordt verwijderd';
$lang['admin']['event_desc_deletegrouppost'] = 'Een tag die wordt aangeroepen nadat een groep uit het systeem is verwijderd';
$lang['admin']['event_desc_addstylesheetpre'] = 'Een tag die wordt aangeroepen voordat een nieuw stylesheet wordt aangemaakt';
$lang['admin']['event_desc_addstylesheetpost'] = 'Een tag die wordt aangeroepen nadat een nieuw stylesheet is aangemaakt';
$lang['admin']['event_desc_editstylesheetpre'] = 'Een tag die wordt aangeroepen voordat bewerkingen aan een stylesheet worden opgeslagen';
$lang['admin']['event_desc_editstylesheetpost'] = 'Een tag die wordt aangeroepen nadat bewerkingen aan een stylesheet zijn opgeslagen';
$lang['admin']['event_desc_deletestylesheetpre'] = 'Een tag die wordt aangeroepen voordat een stylesheet uit het systeem wordt verwijderd';
$lang['admin']['event_desc_deletestylesheetpost'] = 'Een tag die wordt aangeroepen nadat een stylesheet uit het systeem is verwijderd';
$lang['admin']['event_desc_addtemplatepre'] = 'Een tag die wordt aangeroepen voordat een nieuw sjabloon wordt aangemaakt';
$lang['admin']['event_desc_addtemplatepost'] = 'Een tag die wordt aangeroepen nadat een nieuw sjabloon is aangemaakt';
$lang['admin']['event_desc_edittemplatepre'] = 'Een tag die wordt aangeroepen voordat bewerkingen aan een sjabloon worden opgeslagen';
$lang['admin']['event_desc_edittemplatepost'] = 'Een tag die wordt aangeroepen nadat bewerkingen aan een sjabloon zijn opgeslagen';
$lang['admin']['event_desc_deletetemplatepre'] = 'Een tag die wordt aangeroepen voordat een sjabloon uit het systeem wordt verwijderd';
$lang['admin']['event_desc_deletetemplatepost'] = 'Een tag die wordt aangeroepen nadat een sjabloon uit het systeem is verwijderd';
$lang['admin']['event_desc_templateprecompile'] = 'Een tag die wordt aangeroepen voordat een sjabloon wordt verzonden naar smarty voor verwerking';
$lang['admin']['event_desc_templatepostcompile'] = 'Een tag die wordt aangeroepen nadat een sjabloon is verwerkt door smarty';
$lang['admin']['event_desc_addglobalcontentpre'] = 'Een tag die wordt aangeroepen voordat een nieuw HTML blok wordt aangemaakt';
$lang['admin']['event_desc_addglobalcontentpost'] = 'Een tag die wordt aangeroepen nadat een nieuw HTML blok is aangemaakt';
$lang['admin']['event_desc_editglobalcontentpre'] = 'Een tag die wordt aangeroepen voordat bewerkingen aan een HTML blok worden opgeslagen';
$lang['admin']['event_desc_editglobalcontentpost'] = 'Een tag die wordt aangeroepen nadat bewerkingen aan een HTML blok zijn opgeslagen';
$lang['admin']['event_desc_deleteglobalcontentpre'] = 'Een tag die wordt aangeroepen voordat een HTML blok uit het systeem wordt verwijderd';
$lang['admin']['event_desc_deleteglobalcontentpost'] = 'Een tag die wordt aangeroepen nadat een HTML blok uit het systeem is verwijderd';
$lang['admin']['event_desc_globalcontentprecompile'] = 'Een tag die wordt aangeroepen  voordat een HTML blok wordt verzonden naar smarty voor verwerking';
$lang['admin']['event_desc_globalcontentpostcompile'] = 'Een tag die wordt aangeroepen nadat een HTML blok verwerkt door smarty';
$lang['admin']['event_desc_contenteditpre'] = 'Een tag die wordt aangeroepen voordat bewerkingen aan de inhoud worden opgeslagen';
$lang['admin']['event_desc_contenteditpost'] = 'Een tag die wordt aangeroepen nadat bewerkingen aan de inhoud zijn opgeslagen';
$lang['admin']['event_desc_contentdeletepre'] = 'Een tag die wordt aangeroepen voordat de inhoud uit het systeem wordt verwijderd';
$lang['admin']['event_desc_contentdeletepost'] = 'Een tag die wordt aangeroepen nadat de inhoud uit het systeem is verwijderd';
$lang['admin']['event_desc_contentstylesheet'] = 'Een tag die wordt aangeroepen voordat een stylesheet wordt verzonden naar de browser';
$lang['admin']['event_desc_contentprecompile'] = 'Een tag die wordt aangeroepen voordat de inhoud wordt verzonden naar smarty voor verwerking';
$lang['admin']['event_desc_contentpostcompile'] = 'Een tag die wordt aangeroepen nadat de inhoud is verwerkt door smarty';
$lang['admin']['event_desc_contentpostrender'] = 'Een tag die wordt aangeroepen voordat gecombineerd html wordt verzonden naar de browser';
$lang['admin']['event_desc_smartyprecompile'] = 'Een tag die wordt aangeroepen voordat enige inhoud bedoeld voor smarty wordt verzonden voor verwerking';
$lang['admin']['event_desc_smartypostcompile'] = 'Een tag die wordt aangeroepen nadat enige inhoud bedoeld voor smarty is verwerkt';
$lang['admin']['event_help_loginpost'] = '<p>Verzonden nadat een gebruiker in het beheer paneel is ingelogd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_logoutpost'] = '<p>Verzonden nadat een gebruiker in het beheer paneel is uitgelogd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_adduserpre'] = '<p>Verzonden voordat een nieuwe gebruiker wordt aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_adduserpost'] = '<p>Verzonden nadat een nieuwe gebruiker is aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_edituserpre'] = '<p>Verzonden voordat bewerkingen aan een gebruiker worden opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_edituserpost'] = '<p>Verzonden nadat bewerkingen aan een gebruiker zijn opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_deleteuserpre'] = '<p>Verzonden voordat een gebruiker uit het systeem wordt verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_deleteuserpost'] = '<p>Verzonden nadat een gebruiker uit het systeem is verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;user&#039; - Verwijzing naar het be&iuml;nvloedde gebruikerobject.</li>
</ul>
';
$lang['admin']['event_help_addgrouppre'] = '<p>Verzonden voordat een nieuwe groep wordt aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar het be&iuml;nvloedde groepobject.</li>
</ul>
';
$lang['admin']['event_help_addgrouppost'] = '<p>Verzonden nadat een nieuwe groep is aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar het be&iuml;nvloedde groepobject.</li>
</ul>
';
$lang['admin']['event_help_changegroupassignpre'] = '<p>Verzonden voordat een groepstoewijzing is opgeslagen.</p>
<h4>Parameters></h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar een groepobject.</li>
<li>&#039;users&#039; - Tabel van verwijzingen naar gebruikers die toebehoren tot een groep.</li>
';
$lang['admin']['event_help_changegroupassignpost'] = '<p>Verzonden nadat een groepstoewijzing is opgeslagen.</p>
<h4>Parameters></h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar een groepobject.</li>
<li>&#039;users&#039; - Tabel van verwijzingen naar gebruikers die toebehoren tot de be&iuml;nvloede groep.</li>
';
$lang['admin']['event_help_editgrouppre'] = '<p>Verzonden voordat bewerkingen aan een groep worden opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar het be&iuml;nvloedde groepobject.</li>
</ul>
';
$lang['admin']['event_help_editgrouppost'] = '<p>Verzonden nadat bewerkingen aan een groep zijn opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar het be&iuml;nvloedde groepobject.</li>
</ul>
';
$lang['admin']['event_help_deletegrouppre'] = '<p>Verzonden voordat een groep uit het systeem wordt verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar het be&iuml;nvloedde groepobject.</li>
</ul>
';
$lang['admin']['event_help_deletegrouppost'] = '<p>Verzonden nadat een groep uit het systeem is verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;group&#039; - Verwijzing naar het be&iuml;nvloedde groepobject.</li>
</ul>
';
$lang['admin']['event_help_addstylesheetpre'] = '<p>Verzonden voordat een nieuw stylesheet wordt aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;stylesheet&#039; - Verwijzing naar het be&iuml;nvloedde stylesheet-object.</li>
</ul>
';
$lang['admin']['event_help_addstylesheetpost'] = '<p>Verzonden nadat een nieuw stylesheet is aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;stylesheet&#039; - Verwijzing naar het be&iuml;nvloedde stylesheet-object.</li>
</ul>
';
$lang['admin']['event_help_editstylesheetpre'] = '<p>Verzonden voordat bewerkingen aan een stylesheet worden opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;stylesheet&#039; - Verwijzing naar het be&iuml;nvloedde stylesheet-object.</li>
</ul>
';
$lang['admin']['event_help_editstylesheetpost'] = '<p>Verzonden nadat bewerkingen aan een stylesheet zijn opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;stylesheet&#039; - Verwijzing naar het be&iuml;nvloedde stylesheet-object.</li>
</ul>
';
$lang['admin']['event_help_deletestylesheetpre'] = '<p>Verzonden voordat een stylesheet uit het systeem wordt verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;stylesheet&#039; - Verwijzing naar het be&iuml;nvloedde stylesheet-object.</li>
</ul>
';
$lang['admin']['event_help_deletestylesheetpost'] = '<p>Verzonden nadat een stylesheet uit het systeem is verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;stylesheet&#039; - Verwijzing naar het be&iuml;nvloedde stylesheet-object.</li>
</ul>
';
$lang['admin']['event_help_addtemplatepre'] = '<p>Verzonden voordat een nieuw sjabloon wordt aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar het be&iuml;nvloedde sjabloonobject.</li>
</ul>
';
$lang['admin']['event_help_addtemplatepost'] = '<p>Verzonden nadat een nieuw sjabloon is aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar het be&iuml;nvloedde sjabloonobject.</li>
</ul>
';
$lang['admin']['event_help_edittemplatepre'] = '<p>Verzonden voordat bewerkingen aan een sjabloon worden opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar het be&iuml;nvloedde sjabloonobject.</li>
</ul>
';
$lang['admin']['event_help_edittemplatepost'] = '<p>Verzonden nadat bewerkingen aan een sjabloon zijn opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar het be&iuml;nvloedde sjabloonobject.</li>
</ul>
';
$lang['admin']['event_help_deletetemplatepre'] = '<p>Verzonden voordat een sjabloon uit het systeem wordt verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar het be&iuml;nvloedde sjabloonobject.</li>
</ul>
';
$lang['admin']['event_help_deletetemplatepost'] = '<p>Verzonden nadat een sjabloon uit het systeem is verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar het be&iuml;nvloedde sjabloonobject.</li>
</ul>
';
$lang['admin']['event_help_templateprecompile'] = '<p>Verzonden voordat een sjabloon wordt verzonden naar smarty voor verwerking.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar de be&iuml;nvloedde sjabloontekst.</li>
</ul>
';
$lang['admin']['event_help_templatepostcompile'] = '<p>Verzonden nadat een sjabloon is verwerkt door smarty.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;template&#039; - Verwijzing naar de be&iuml;nvloedde sjabloontekst.</li>
</ul>
';
$lang['admin']['event_help_addglobalcontentpre'] = '<p>Verzonden voordat een nieuw HTML blok wordt aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar het be&iuml;nvloedde HTML blokobject.</li>
</ul>
';
$lang['admin']['event_help_addglobalcontentpost'] = '<p>Verzonden nadat een nieuw HTML blok is aangemaakt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar het be&iuml;nvloedde HTML blokobject.</li>
</ul>
';
$lang['admin']['event_help_editglobalcontentpre'] = '<p>Verzonden voordat bewerkingen aan een HTML blok worden opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar het be&iuml;nvloedde HTML blokobject.</li>
</ul>
';
$lang['admin']['event_help_editglobalcontentpost'] = '<p>Verzonden nadat bewerkingen aan een HTML blok zijn opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar het be&iuml;nvloedde HTML blokobject.</li>
</ul>
';
$lang['admin']['event_help_deleteglobalcontentpre'] = '<p>Verzonden voordat een HTML blok uit het systeem wordt verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar het be&iuml;nvloedde HTML blokobject.</li>
</ul>
';
$lang['admin']['event_help_deleteglobalcontentpost'] = '<p>Verzonden nadat een HTML blok uit het systeem is verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar het be&iuml;nvloedde HTML blokobject.</li>
</ul>
';
$lang['admin']['event_help_globalcontentprecompile'] = '<p>Verzonden voordat een HTML blok wordt verzonden naar smarty voor verwerking.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar de be&iuml;nvloedde HTML bloktekst.</li>
</ul>
';
$lang['admin']['event_help_globalcontentpostcompile'] = '<p>Verzonden nadat een HTML blok is verwerkt door smarty.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar de be&iuml;nvloedde HTML bloktekst.</li>
</ul>
';
$lang['admin']['event_help_contenteditpre'] = '<p>Verzonden voordat bewerkingen aan de inhoud worden opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;global_content&#039; - Verwijzing naar het be&iuml;nvloedde inhoudsobject.</li>
</ul>
';
$lang['admin']['event_help_contenteditpost'] = '<p>Verzonden nadat bewerkingen aan de inhoud is opgeslagen.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar het be&iuml;nvloedde inhoudsobject.</li>
</ul>
';
$lang['admin']['event_help_contentdeletepre'] = '<p>Verzonden voordat inhoud uit het systeem wordt verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar het be&iuml;nvloedde inhoudsobject.</li>
</ul>
';
$lang['admin']['event_help_contentdeletepost'] = '<p>Verzonden nadat inhoud uit het systeem is verwijderd.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar het be&iuml;nvloedde inhoudsobject.</li>
</ul>
';
$lang['admin']['event_help_contentstylesheet'] = '<p>Verzonden voordat een stylesheet wordt verzonden naar de browser.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar de be&iuml;nvloedde stylesheet-tekst.</li>
</ul>
';
$lang['admin']['event_help_contentprecompile'] = '<p>Verzonden voordat inhoud wordt verzonden naar smarty voor verwerking.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar de be&iuml;nvloedde inhoudstekst.</li>
</ul>
';
$lang['admin']['event_help_contentpostcompile'] = '<p>Verzonden nadat inhoud is verwerkt door smarty.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar de be&iuml;nvloedde inhoudstekst.</li>
</ul>
';
$lang['admin']['event_help_contentpostrender'] = '<p>Verzonden voordat gecombineerde html wordt verzonden naar de browser.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar de be&iuml;nvloedde html-tekst.</li>
</ul>
';
$lang['admin']['event_help_smartyprecompile'] = '<p>Verzonden voordat alle inhoud bedoeld voor smarty, wordt verzonden voor verwerking.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar de be&iuml;nvloedde tekst.</li>
</ul>
';
$lang['admin']['event_help_smartypostcompile'] = '<p>Verzonden nadat alle inhoud bedoeld voor smarty, is verwerkt.</p>
<h4>Parameters</h4>
<ul>
<li>&#039;content&#039; - Verwijzing naar de be&iuml;nvloedde tekst.</li>
</ul>
';
$lang['admin']['filterbymodule'] = 'Filter op module';
$lang['admin']['showall'] = 'Alles tonen';
$lang['admin']['core'] = 'Core ';
$lang['admin']['defaultpagecontent'] = 'Standaard paginainhoud';
$lang['admin']['file_url'] = 'Link naar bestand (in plaats naar URL)';
$lang['admin']['no_file_url'] = 'Geen (gebruik bovenstaande URL)';
$lang['admin']['defaultparentpage'] = 'Bovenliggende standaardpagina';
$lang['admin']['error_udt_name_whitespace'] = 'Fout: gebruikersgedefinieerde tags (UDT) mogen geen spaties in de naam hebben.';
$lang['admin']['warning_safe_mode'] = '<strong><em>WAARSCHUWING:</em></strong> PHP veilige modus (Safe Mode) is actief.  Dit kan voor problemen zorgen bij uploads vanuit de webbrowser. Dit geldt voor afbeeldingen, thema&rsquo;s en module-XML-pakketten. Het advies is veilige modus uit te zetten in PHP.';
$lang['admin']['test'] = 'Controleer';
$lang['admin']['results'] = 'Resultaten';
$lang['admin']['untested'] = 'Niet gecontroleerd';
$lang['admin']['unknown'] = 'Niet bekend';
$lang['admin']['download'] = 'Download ';
$lang['admin']['frontendwysiwygtouse'] = 'Frontend WYSIWYG';
$lang['admin']['backendwysiwygtouse'] = 'Standaard backend wysiwyg (voor nieuwe accounts)';
$lang['admin']['all_groups'] = 'Alle Groepen';
$lang['admin']['error_type'] = 'Fout-type';
$lang['admin']['contenttype_errorpage'] = 'Fout-pagina';
$lang['admin']['errorpagealreadyinuse'] = 'Foutcode al in gebruik';
$lang['admin']['404description'] = 'Pagina niet gevonden';
$lang['admin']['usernotfound'] = 'Gebruikersnaam niet gevonden.';
$lang['admin']['passwordchange'] = 'Wilt u alstublieft een nieuw wachtwoord invoeren';
$lang['admin']['recoveryemailsent'] = 'E-mail verzonden naar het bekende mailadres. Controleer uw Postvak In van uw mail programma voor verdere instructies';
$lang['admin']['errorsendingemail'] = 'Er is een fout opgetreden tijdens het versturen van de &#039;Wachtwoord Herstel&#039; mail. Neem contact op met uw administrator.';
$lang['admin']['passwordchangedlogin'] = 'Wachtwoord gewijzigd.  Meldt u opnieuw aan met deze gegevens.';
$lang['admin']['nopasswordforrecovery'] = 'Geen e-mail adres bekend voor deze gebruiker. Wachtwoord Herstel is hierdoor niet mogelijk. Neem contact op met uw administrator.';
$lang['admin']['lostpw'] = 'Wachtwoord vergeten?';
$lang['admin']['lostpwemailsubject'] = '[%s] Wachtwoord Herstellen';
$lang['admin']['lostpwemail'] = 'U ontvangt deze mail omdat er een verzoek is gedaan om het (%s) wachtwoord van deze gebruiker: %s te wijzigen. Als u dit verzoek wilt uitvoeren klik dat op de onderstaande link of kopieer deze in de adres regel van uw favoriete webbrowser:
%s

Heeft u niet een dergelijk verzoek gedaan, negeer dan deze mail en er zal verder niets aan uw account worden gewijzigd.';
$lang['admin']['utma'] = '156861353.1959396905.1343157646.1343157646.1343157646.1';
$lang['admin']['utmz'] = '156861353.1343157646.1.1.utmccn=(direct)|utmcsr=(direct)|utmcmd=(none)';
$lang['admin']['utmb'] = '156861353';
$lang['admin']['utmc'] = '156861353';
?>