<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Manage Jobs') ) exit;

$this->SetCurrentTab('jobs');
if( !isset($params['jobid']) ) {
  $this->SetError($this->Lang('error_missingparams'));
  $this->RedirectToTab($id);
}

try {
  $pause = 1;
  if( isset($params['pause']) ) $pause = (int)$params['pause'];
  $jobid = (int)$params['jobid'];
  
  // load the job
  $job = cgjobmgr_job::load_by_id($jobid);

  // check the status
  if( $pause ) {
    if( !in_array($job->get_status(),array(cgjobmgr_job::STATUS_INPROGRESS,cgjobmgr_job::STATUS_COMPLETING)) &&
	$job->get_recur_interval() == 0 ) {
      $this->SetError($this->Lang('error_pause_badstatus'));
      $this->RedirectToTab($id);
    }
    $job->set_persistent_value('__ORIG_STATUS__',$job->get_status());
    $job->set_status(cgjobmgr_job::STATUS_PAUSED);

    audit('',$this->GetName(),'Paused Job: '.$job->name);
    $this->SendEvent('JobPaused',array('job'=>$job));
  }
  else {
    if( $job->get_status() != cgjobmgr_job::STATUS_PAUSED ) {
      $this->SetError($this->Lang('error_unpause_badstatus'));
      $this->RedirectToTab($id);
    }
    $origstatus = $job->get_persistent_value('__ORIG_STATUS__','notset');
    if( $origstatus == 'notset' ) {
      $this->SetError($this->Lang('error_unpause_badstatus'));
      $this->RedirectToTab($id);
    }
    $job->set_status($origstatus);
    $job->unlock();

    audit('',$this->GetName(),'Resumed Job: '.$job->name);
    $this->SendEvent('JobResumed',array('job'=>$job));
  }

  // save it
  $job->save();
}
catch( Exception $e ) {
  $this->SetError($e->getMessage());
}
$this->RedirectToTab($id);

#
# EOF
#
?>