<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Modify Site Preferences') ) exit;

$contentops = $gCms->GetContentOperations();
$dflt_page = $this->GetPreference('dflt_page',$contentops->GetDefaultContent());

$url = $this->create_url('cntnt01','process',$dflt_page,array(),false,false,$this->Getname().'/process');
$smarty->assign('process_url',$url);
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_savesettings'));
$smarty->assign('input_dfltpage',$contentops->CreateHierarchyDropdown('',$dflt_page,$id.'dfltpage'));
$smarty->assign('cronjob_interval',$this->GetPreference('cronjob_interval'));
$smarty->assign('escalation_intervallimit',$this->GetPreference('escalation_intervallimit',10));
$smarty->assign('timeout',$this->GetPreference('task_timeout'));
$smarty->assign('iterative_slack',$this->GetPreference('iterative_slack'));
$smarty->assign('max_autotask_iterations',$this->GetPreference('max_autotask_iterations',10));
$smarty->assign('formend',$this->CreateFormEnd());

echo $this->ProcessTemplate('admin_settingstab.tpl');
#
# EOF
#
?>