<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGJobMgr (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to manage jobs that take considerable
#  amounts of time to process.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

final class cgjobmgr_utils
{
  protected function __construct() {}

  public static function get_jobs($criteria = array())
  {
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cgjobmgr';
    $where = array();
    $parms = array();
    
    foreach( $criteria as $key => $params ) {
      switch( $key ) {
      case 'name':
	$params = str_replace('*','%',$params);
	$where[] = 'name LIKE ?';
	$parms[] = $params;
	break;

      case 'owner':
	$where[] = 'owner = ?';
	$parms[] = (int)$params;
	break;

      case 'status':
	if( !is_array($params) ) {
	  $params = array($params);
	}
	$params = '('.cge_array::implode_quoted($params).')';
	$where[] = 'status IN '.$params;
	break;

      case 'started':
	$where[] = 'COALESCE(started_at,UNIX_TIMESTAMP()) < UNIX_TIMESTAMP()';
	break;
      }
    }

    if( count($where) ) {
      $query .= ' WHERE '.implode(' AND ',$where);
    }
    $db = cmsms()->GetDb();
    $dbr = $db->GetArray($query,$parms);

    if( !is_array($dbr) || count($dbr) == 0 ) {
      return;
    }

    $out = array();
    foreach( $dbr as $row ) {
      $out[] = cgjobmgr_job::load_from_data($row);
    }
    return $out;
  }


  /**
   * This sends notification emails out related to the status of the job.
   *
   * @internal
   * @ignore
   * @param cgjobmgr_job  The job we are notifying about.
   */
  public static function notifier(cgjobmgr_job $job)
  {
    $mod = cms_utils::get_module('CGJobMgr');
    $groups = unserialize($mod->GetPreference('notification_groups'));
    $status = unserialize($mod->GetPreference('notification_status'));
    if( $groups == '' || (is_array($groups) && count($groups) == 0) ) return;
    if( $status == '' || (is_array($status) && count($status) == 0) ) return;

    // check if the job status is something we're concerned about
    if( !in_array($job->get_status(),$status) ) return;
    if( $job->recur_interval > 0 ) return;

    // now we have groups,, see if we can find any email adddresses.
    $ops = cmsms()->GetUserOperations();
    $emaillist = array();
    foreach( $groups as $groupid ) {
      $list = $ops->LoadUsersInGroup($groupid);
      if( is_array($list) && count($list) ) {
	foreach( $list as $user ) {
	  if( $user->email != '' && !in_array($user->email,$emaillist) ) {
	    $emaillist[] = $user->email;
	  }
	}
      }
    }
    if( !count($emaillist) ) return;

    $smarty = cmsms()->GetSmarty();
    $smarty->assign('job',$job);

    // now we gotta send an email
    $mailer = cms_utils::get_module('CMSMailer');
    $mailer->reset();
    $mailer->IsHTML(TRUE);
    foreach( $emaillist as $one ) {
      $mailer->AddAddress($one);
    }
    $mailer->SetSubject('Alert: '.$mod->GetName().' Job Terminated');
    $body = $mod->ProcessTemplate('job_notifications.tpl');
    $mailer->SetBody($body);
    $mailer->Send();

    audit($job->id,$mod->GetName(),'Notifications Sent to '.count($emaillist).' users because job status is '.$job->get_status());
  }
} // end of class

#
# EOF
#
?>