<?php
$lang['friendlyname'] = 'Galerie';
$lang['moddescription'] = 'Die einfachste Art, Bildergalerien zu verwalten und anzuzeigen.';
$lang['description'] = 'Eine einfach zu verwendende Bildergalerie, die automatisch die Bilder eines vorgegebenen Verzeichnisses anzeigt.';
$lang['postinstall'] = 'Das Galerie-Modul wurde installiert.';
$lang['tinymce_description_picker'] = 'Einfaches Einfügen von Foto-Galerien erlauben.';
$lang['tinymce_button_picker'] = 'Galerie hinzufügen';
$lang['active'] = 'Aktiv';
$lang['apply'] = 'Anwenden';
$lang['areyousure'] = 'Wollen Sie dies wirklich löschen?';
$lang['areyousuremulti'] = 'Wollen Sie wirklich diese Massenaktion ausführen?';
$lang['cancel'] = 'Abbrechen';
$lang['copy'] = 'Kopieren';
$lang['default'] = 'Standard';
$lang['delete'] = 'Löschen';
$lang['down'] = 'Nach unten';
$lang['edit'] = 'Bearbeiten';
$lang['error'] = 'Fehler!';
$lang['inactive'] = 'Inaktiv';
$lang['setfalse'] = 'Deaktivieren';
$lang['settrue'] = 'Aktivieren';
$lang['submit'] = 'Speichern';
$lang['up'] = 'Nach oben';
$lang['gallerymenu'] = 'Galerie Menu';
$lang['galleries'] = 'Galerien';
$lang['gallerypath'] = 'Galerie';
$lang['dirtag'] = 'Tag, um diese untergeordnete Galerie anzuzeigen';
$lang['editgallery'] = 'Galerie bearbeiten';
$lang['addsubgallery'] = 'Untergeordnete Galerie hinzufügen';
$lang['uploadimages'] = 'Bilder hochladen';
$lang['editimage'] = 'Bilddetails bearbeiten';
$lang['editthumbs'] = 'Vorschaubilder bearbeiten';
$lang['nogalleriestext'] = 'Noch keine Galerien verfügbar';
$lang['list'] = 'Liste';
$lang['item'] = 'Bild';
$lang['title'] = 'Titel';
$lang['date'] = 'Datum';
$lang['nofilestext'] = 'Noch keine Bilder verfügbar';
$lang['directoryname'] = 'Neuer Verzeichnisname';
$lang['gallerytitle'] = 'Galerietitel';
$lang['comment'] = 'Kommentar';
$lang['albumcover'] = 'Album-Bild';
$lang['noalbumcover'] = 'Untergeordneten Galerien kann kein Album-Cover zugeordnet werden';
$lang['template'] = 'Vorlage';
$lang['editors'] = 'Bearbeiter';
$lang['parentgallery'] = 'Übergeordnete Galerie';
$lang['hideparentlink'] = 'Den Link auf die übergeordnete Galerie verbergen';
$lang['usedefault'] = 'Voreinstellung verwenden';
$lang['sortbysettings'] = 'Nach den Vorlageneinstellungen sortieren';
$lang['sureunsort'] = 'Wollen Sie wirklich die manuell erstellte Sortierreihenfolge löschen?';
$lang['updatethumbs'] = 'Vorschaubilder aktualisieren';
$lang['sureupdatethumbs'] = 'Wollen Sie wirklich die Vorschaubilder löschen?';
$lang['thumbsrecreated'] = 'Beim ersten Besuch der Galerie werden sie neu erstellt';
$lang['thumbsdeleted'] = 'Die Vorschaubilder wurden gelöscht.';
$lang['galleryupdated'] = 'Die Galerie wurde aktualisiert.';
$lang['withselected'] = 'ausgewählte Dateien';
$lang['moveto'] = 'Verschieben nach';
$lang['imageupdated'] = 'Die Bilddetails wurden aktualisiert.';
$lang['imagedetailsupdated'] = 'Die Bildinformationen sind aktuell.';
$lang['thumbupdated'] = 'Das Vorschaubild wurde aktualisiert.';
$lang['error_insufficientparams'] = 'Parameter nicht ausreichend.';
$lang['error_updategalleryfailed'] = 'Die Aktualisierung der Galerie ist fehlgeschlagen.';
$lang['error_directorynameinvalid'] = 'Ungültiger Verzeichnisname.';
$lang['error_directoryalreadyexists'] = 'Ein Verzeichnis mit diesem Namen existiert bereits.';
$lang['templates'] = 'Vorlagen';
$lang['title_available_templates'] = 'Verfügbare Vorlagen';
$lang['prompt_name'] = 'Name';
$lang['prompt_version'] = 'Version';
$lang['prompt_about'] = 'Über';
$lang['prompt_default'] = 'Standard';
$lang['prompt_visible'] = 'Im Vorlagenauswahlmenü sichtbar';
$lang['prompt_newtemplate'] = 'Neue Vorlage erstellen';
$lang['makevisible'] = 'Die Vorlage wird Benutzern ohne die Berechtigung „Modify Templates“ im Vorlagenauswahlmenü angezeigt';
$lang['makeinvisible'] = 'Die Vorlage wird Benutzern ohne die Berechtigung „Modify Templates“ im Vorlagenauswahlmenü nicht angezeigt';
$lang['title_importxml'] = 'Vorlage via XML-Datei importieren';
$lang['importxmlnote'] = 'XML-Dateien mit verschiedenen Galerie-Vorlagen können im Projektverzeichnis des <a href="http://dev.cmsmadesimple.org/project/files/726" target="_blank">Galerie-Moduls</a> heruntergeladen werden. Bitte lesen Sie die Versions-Hinweise vor dem Hochladen!';
$lang['importxml'] = 'Vorlagen-XML importieren';
$lang['overwrite'] = 'Die bereits existierenden Modulvorlagen überschreiben';
$lang['title_singleimg_template'] = 'Vorlage für Modulaufrufecalls mit einem einzelnen Bild';
$lang['title_template'] = 'Vorlageneditor';
$lang['prompt_templatename'] = 'Vorlagenname';
$lang['thumbnailsize'] = 'Größe des Vorschaubildes (auf Benutzerseite)';
$lang['leaveempty'] = '(frei lassen, um die Standard-Vorschaubilder der Bildverwaltung zu verwenden)';
$lang['width'] = 'Breite';
$lang['height'] = 'Höhe';
$lang['resizemethod'] = 'Skalierungsmethode';
$lang['crop'] = 'Beschneiden';
$lang['scale'] = 'Skalieren';
$lang['zoomcrop'] = 'Zoomen & beschneiden';
$lang['zoomscale'] = 'Zoomen & skalieren';
$lang['maxnumber'] = 'Maximale Anzahl der Einträge pro Seite';
$lang['showallimages'] = 'Ohne Eintrag werden alle Bilder ohne Seitenlinks angezeigt.';
$lang['sortingoptions'] = 'Sortier-Optionen';
$lang['specifysortfields'] = 'Legen Sie hier die Felder fest, nach denen sortiert werden soll';
$lang['ascending'] = 'aufsteigend';
$lang['descending'] = 'absteigend';
$lang['addfield'] = 'Feld hinzufügen';
$lang['deletefield'] = 'Die letzte Zeile löschen';
$lang['prompt_template'] = 'Vorlagenquelle';
$lang['prompt_templatecss'] = 'Stylesheet-Vorlage';
$lang['prompt_templatejs'] = 'JavaScript-Vorlage';
$lang['jsposition'] = 'Wo soll das JavaScript eingefügt werden?';
$lang['jstop'] = 'Im >head&lt>-Element';
$lang['jsbtm'] = 'Am Ende des >body<-Elements';
$lang['resetoriginal'] = 'Auf die programmseitigen Voreinstellungen zurücksetzen';
$lang['resetoriginalwarning'] = 'Soll der Vorlagencode wirklich auf die programmseitigen Voreinstellungen zurückgesetzt werden?';
$lang['templateupdated'] = 'Die Vorlage wurde aktualisiert.';
$lang['templateadded'] = 'Die Vorlage wurde hinzugefügt.';
$lang['error_templateexists'] = 'Die Modulvorlage existiert bereits und kann nicht überschrieben werden.';
$lang['error_directorynotwritable'] = 'Das Verzeichnis ist nicht beschreibbar.';
$lang['error_incompletexml'] = 'XML unvollständig.';
$lang['error_cantcreatedir'] = 'Konnte das Verzeichnis nicht erstellen';
$lang['error_cantcreatefile'] = 'Konnte die Datei nicht erstellen';
$lang['templatedeleted'] = 'Vorlage gelöscht';
$lang['availablevariables'] = 'Verfügbare Smarty-Variablen in der Vorlage';
$lang['availablevariableslist'] = 'These are the variables you can use to customize your template:<br /><br />
<code>{$module_message}</code> - error message, is only set if there\'s a message<br />
<code>{$galleryid}</code> - unique id for the gallery<br />
<code>{$gallerytitle}</code> - title of the gallery. If there is no title, this will show the directory name<br />
<code>{$gallerycomment}</code> - comment of the gallery<br />
<code>{$gallerydate}</code> - creation date/time of the gallery<br />
<code>{$gallerydir}</code> - directory name of the gallery<br />
<code>{$parentid}</code> - id for the parent of the current gallery (only in default action)<br />
<code>{$parentlink}</code> - link to the parent folder<br />
<code>{$parent_url}</code> - url to the parent folder<br />
<code>{$parent_txt}</code> - text to create a link with above url<br />
<code>{$hideparentlink}</code> - true/false<br />
<code>{$imagecount}</code> - shows e.g. "6 images", depending on language<br />
<code>{$itemcount}</code> - number of items, images + folders<br />
<code>{$numimages}</code> - number of images<br />
<code>{$numdirs}</code> - number of folders<br />
<code>{$pages}</code> - number of pages<br />
<code>{$currentpage}</code> - the current pagenumber<br />
<code>{$prevpage}</code> - link to previous page, if applicable<br />
<code>{$prevpage_url}</code> - url to previous page, if applicable<br />
<code>{$prevpage_txt}</code> - text to create a link with above url<br />
<code>{$nextpage}</code> - link to next page, if applicable<br />
<code>{$nextpage_url}</code> - url to next page, if applicable<br />
<code>{$nextpage_txt}</code> - text to create a link with above url<br />
<code>{$pagelinks}</code> - links to each existing page<br />
<code>{$fields.your_field_alias.name}</code> - gallery custum field name<br />
<code>{$fields.your_field_alias.value}</code> - gallery custom field value<br />
<code>{$fields.your_field_alias.type}</code> - gallery custom field type<br />
<code>{$images}</code> - array with keys:<br />
 - <code>file</code> - relative path to the original image (or subgallery)<br />
 - <code>filename</code> - filename of the image (or subgallery)<br />
 - <code>title</code> - title of the image<br />
 - <code>titlename</code> - this shows the title if there is one, or else the filename<br />
 - <code>comment</code> - comment to the image<br />
 - <code>active</code> - true/false<br />
 - <code>filedate</code> - creation date/time<br />
 - <code>thumb</code> - relative path to the thumbnail. In case of a subgallery, this wil revert to the image which is set as default in that subgallery. If no image is set as default, a standard folder-icon will be used.<br />
 - <code>fileid</code> - unique id for the image or subgallery<br />
 - <code>isdir</code> - true if it\'s a subgallery<br />
 - <code>galleryid</code> - id of the gallery the image belongs to<br />
 - <code>gallery_url</code> - url to gallery the image belongs to<br />
 - <code>fields.your_field_alias.name</code> - custum field name<br />
 - <code>fields.your_field_alias.value</code> - custom field value<br />
 - <code>fields.your_field_alias.type</code> - custom field type<br />';
$lang['fielddefinitions'] = 'Felddefinitionen';
$lang['fielddefinition'] = 'Felddefinition';
$lang['addfielddef'] = 'Felddefinition hinzufügen';
$lang['editfielddef'] = 'Felddefinition bearbeiten';
$lang['alias'] = 'Alias';
$lang['type'] = 'Typ';
$lang['textinput'] = 'Texteingabefeld';
$lang['dropdown'] = 'Aufklapp-Liste';
$lang['checkbox'] = 'Kontrollkästchen';
$lang['radiobuttons'] = 'Radioknöpfe';
$lang['textarea'] = 'Textbereich';
$lang['wysiwyg'] = 'WYSIWYG';
$lang['file'] = 'Datei';
$lang['properties'] = 'Feldeigenschaften';
$lang['properties_help'] = 'Maximale Anzahl der Zeichen für das Eingabefeld oder eine kommagetrennte Liste von Werten für eine Aufklappmenü oder Radioknöpfe';
$lang['public'] = 'Öffentlich';
$lang['dirfield'] = 'Feld anwenden auf';
$lang['fielddefadded'] = 'Die Felddefinition wurde hinzugefügt';
$lang['fielddefsupdated'] = 'Die Felddefinition wurde aktualisiert';
$lang['options'] = 'Optionen';
$lang['urlprefix'] = 'Präfix, der in allen URLs des Gallery-Moduls verwendet werden soll';
$lang['urlprefix_help'] = 'Dies funktioniert nur, wenn die Pretty URLs via mod_rewrite oder die internen Pretty URLs aktiviert wurden';
$lang['allowed_extensions'] = 'Erlaubte Dateiendungen';
$lang['maxsize'] = 'Vor dem Hochladen die Größe der Bilder auf diese Maximalwerte ändern';
$lang['imagejpgquality'] = 'Qualität bei Größenänderung für große Bilder';
$lang['thumbjpgquality'] = 'Qualität bei Größenänderung für Vorschaubilder';
$lang['jpgquality_help'] = '(1–100)';
$lang['use_permissions'] = 'Benötigt Benutzerberechtigung zum Editieren von Unter-Galerien';
$lang['newgalleries_active'] = 'Neue Galerien sind standardmäßig aktiv';
$lang['use_comment_wysiwyg'] = 'Einen WYSIWYG-Editor für das Kommentarfeld der Galerie verwenden';
$lang['editdirdates'] = 'Benutzern erlauben, das Erstellungsdatum von untergeordneten Galerien zu bearbeiten';
$lang['editfiledates'] = 'Benutzern erlauben, die Dateidaten des Bildes zu bearbeiten';
$lang['fe_folderpath'] = 'Pfad zu dem voreingestellten Verzeichnis-Icon (Webseite)';
$lang['be_folderpath'] = 'Pfad zu dem Verzeichnis-Icon (Administration)';
$lang['optionsupdated'] = 'Die Optionen wurden erfolgreich aktualisiert.';
$lang['rotateclockwise'] = 'Im Uhrzeigersinn drehen';
$lang['rotateanticlockwise'] = 'Gegen den Uhrzeigersinn drehen';
$lang['editthumb_help'] = 'Klicke und ziehe auf dem Bild um einen Bereich zu markieren';
$lang['thumb_current'] = 'Aktuelles Vorschaubild';
$lang['thumb_preview'] = 'Vorschaubild-Vorschau';
$lang['image'] = 'Bild';
$lang['images'] = 'Bilder';
$lang['parent'] = 'Zurück zur übergeordneten Galerie';
$lang['prevpage'] = '‹ zurück';
$lang['nextpage'] = 'weiter ›';
$lang['defaultgallerycomment'] = 'Vielen Dank für die Installation des Gallery-Moduls. Wenn Sie ein paar Bilder in das Verzeichnis „uploads/images/Gallery“ hochgeladen haben, dann werden diese jetzt unten angezeigt. Sie können Titel, Beschreibungen und die Größe der Vorschaubilder im Administrationsbereich bearbeiten. Alle weiteren Funktionen dieses Moduls sind in der Modulhilfe beschrieben.';
$lang['message_wrongdir'] = 'Das Verzeichnis „Gallery/%s“ existiert nicht. Bitte überprüfen Sie die eingegebenen Parameter.';
$lang['help_dir'] = 'Parameter, um ein Verzeichnis festzulegen (relativ zu „uploads/images/Gallery/“)';
$lang['help_template'] = 'Es wird ein separates Datenbank-Template für die Anzeige der Fotogalerie verwendet. Dieses Template muss existieren und im Reiter Templates der Gallery-Administration sichtbar sein. Es muss jedoch nicht das voreingestellte Template sein. Ohne diesen Parameter wird das Template verwendet, welches dem Verzeichnis zugeordnet wurde, ansonsten das voreingestellte Template.';
$lang['help_targetpage'] = 'Seite, auf der die Galerie angezeigt werden soll. Dies kann entweder ein Seiten-Alias oder eine Seiten-ID sein. Kann verwendet werdern, um eine Galerie mit einem anderen Seiten-Template anzuzeigen.';
$lang['help_number'] = 'Maximale Anzahl an Vorschaubildern, die pro Seite angezeigt werden sollen (ohne Eintrag werden alle Bilder angezeigt)';
$lang['help_start'] = 'Beim x-ten Bild beginnen (ohne Eintrag wird beim ersten Bild begonnen)';
$lang['help_show'] = 'Überschreibt, welche Bilder angezeigt werden sollen. Mögliche Werte sind:
<ul>
<li>\'active\' - es werden nur die als aktiv gekennzeichneten Bilder angezeigt (voreingestellt)</li>
<li>\'inactive\' - es werden nur die als inaktiv gekennzeichneten Bilder angezeigt</li>
<li>\'all\' - es werden alle Bilder angezeigt</li>
</ul>';
$lang['help_action'] = 'Überschreibt die voreingestellte Aktion. Kann in Kombination mit den nachfolgenden Parametern verwendet werden. Mögliche Werte sind:
<ul>
<li>\'showrandom\' - es wird eine bestimmte Anzahl von zufällig ausgewählten Vorschaubildern angezeigt (funktioniert nur mit den Bildern, die in der Datenbank gespeichert sind, die Anzahl ist auf 6 Bilder voreingestellt). Verwenden Sie \'/*\' nach dem Verzeichnisnamen, um die Bilder aus den Unterverzeichnissen mit einzubeziehen</li>
<li>\'showlatest\' - es werden die aktuell hinzugefügten Bilder angezeigt (funktioniert nur mit den Bildern, die in der Datenbank gespeichert sind, die Anzahl ist auf 6 Bilder voreingestellt). Der dir-Parameter kann gesetzt werden, ansonsten wird das voreingestellte Galerie-Wurzelverzeichns verwendet. Unterverzeichnisse werden automatisch mit einbezogen.</li>
<li>\'showlatestdir\' - es wird eine bestimmte Anzahl von zufällig ausgewählten Vorschaubildern des zuletzt hinzugefügten Verzeichnisses angezeigt (funktioniert nur mit den Bildern, die in der Datenbank gespeichert sind, die Anzahl ist auf 6 Bilder voreingestellt)</li>
<li>\'gallerytree\' - es werden Links zu allen Galerien und untergeordneten Galerien angezeigt. Standardmäßig wird dafür das gallerytree Template verwendet, was aber mit dem Parameter template überschrieben werden kann. Der Parameter dir kann verwendet werden, um eine Teilansicht eines Galeriebaumes darzustellen. (funktioniert nur mit den Galerien, die in der Datenbank gespeichert sind)</li>
</ul>
Bitte beachten Sie, dass Bilder nur dann in der Datenbank gespeichert werden, wenn die Galerie in der Administration aufgerufen wurde.';
$lang['help_loadcustomfields'] = 'Nur mit action=\'gallerytree\' benutzen. Setzen Sie diesen Parameter auf 1, wenn Sie die benutzerdefinierten Felder in Ihrem gallerytree template verwenden wollen.';
$lang['help_img'] = 'Mit <code>{Gallery img="123"}</code> wird ein einzelnes Bild aufgerufen. Die HTML-Ausgabe kann über die Registerkarte „Templates“ angepasst werden. Die Größe der Vorschaubilder und das zu verwendende JavaScript-System kann festgelegt werden, indem Sie das entsprechende Template im Listenfeld-Menü auswählen.';
$lang['help2'] = 'Mit <code>{Gallery img=\'123\'}</code> wird ein einzelnes Bild aufgerufen. Die HTML-Ausgabe kann über die Registerkarte „Templates“ angepasst werden. Die Größe der Vorschaubilder und das zu verwendende JavaScript-System kann festgelegt werden, indem Sie das entsprechende Template im Listenfeld-Menü auswählen.
<h3>Was macht dieses Modul?</h3>
<p>Das Gallery-Modul ist eine einfach zu verwendende Fotogalerie, die automatisch die Bilder eines vorgegebenen Verzeichnisses anzeigt. Unterverzeichnisse werden als untergeordnete Bildergalerien angezeigt. Es beinhaltet eine ganze Reihe von Funktionen wie zum Beispiel das automatische Erstellen der Vorschaubilder, die Verwendung verschiedener Lightbox-ähnlicher Templates oder sonstiger CSS/Javascript-Templates nach Ihren Vorstellungen. Außerdem können Sie sowohl für Ihre Galerien als auch für die Fotos Titel und Beschreibungen eingeben.</p>
<h3>Wie wird es eingesetzt?</h3>
<p>Zunächst müssen Sie das Modul mit dem {Gallery}-Tag in Ihre Seite oder Template (oder wo immer Sie wollen) einfügen. Anschließend laden Sie einige Bilder mit der Bildverwaltung, der Dateiverwaltung oder via FTP in das Verzeichnis uploads/images/Gallery/ .</p>
<p>Das war’s schon!</p>
<p>Wenn Sie noch weitere Fotogalerien möchten, erstellen Sie einfach ein Unterverzeichnis und laden Ihre Fotos wie beschrieben in dieses Verzeichnis. Wenn Sie dem {Gallery}-Tag weitere Parameter hinzufügen, können Sie ganz einfach steuern, welche untergeordnete Galerie mit welchem Template angezeigt werden soll, z.Bsp.{Gallery dir="Urlaub/Niederlande2009" template="Lightbox"}</p>
<p>Standardmäßig werden die von der Bildverwaltung erstellten Vorschaubilder verwendet, um die Fotogalerien anzuzeigen.</p>

<h3>Erweiterte Optionen (aber genau so einfach zu verwenden)</h3>
<p>In der Administration des Moduls finden Sie eine ganze Reihe weiterer Optionen:</p>
<ul>
<li>Legen Sie ein Foto als Voreinstellung für eine Galerie fest, welches dann in der übergeordneten Galerie als "Cover" für diese Galerie angezeigt wird (anstatt des voreingestellten Verzeichnis-Icons).</li>
<li>Fügen Sie den Galerien Titel und Bescheibungen hinzu.</li>
<li>Legen Sie ein voreingestelltes Template für jede Galerie fest.</li>
<li>Legen Sie die Größe der Vorschaubilder für jedes Template fest, mit den Möglichkeiten zum Skalieren, Beschneiden und Zoomen der Bilder.</li>
<li>Legen Sie für jedes Template fest, in welcher Reihenfolge die Fotos sortiert werden sollen.</li>
<li>Ändern Sie die Sortierung der Fotos manuell durch Drag and Drop in der Gallery-Liste. (Beachten Sie die Änderung des Mauszeigers)</li>
<li>Fügen Sie den Fotos Titel und Beschreibungen hinzu.</li>
<li>Deaktivieren Sie bestimmte Fotos oder Galerien, damit diese nicht angezeigt werden.</li>
<li>Bearbeiten/Kopieren Sie die Templates oder erstellen ein neues. Über das Info-Icon unterhalb des Template-Code erfahren Sie mehr über die verfügbaren Variablen.</li>
</ul>
<p>Alle Titel, Beschreibungen und Einstellungen werden in der Datenbank gespeichert. Die Datenbank wird bei jedem Aufruf der Gallery-Administration mit den Verzeichnissen synchronisiert. Eine kleine Warnung: Wenn Sie ein Bild oder ein Unterverzeichnis umbenennen oder via Bildverwaltung, Dateiverwaltung oder FTP in ein anderes Verzeichnis verschieben, gehen dessen Titel, Beschreibungen und Einstellungen verloren. Verwenden Sie daher IMMER die entsprechende Funktion des Gallery-Moduls.</p>

<h3>Hochladen und Größenänderung von Bildern</h3>
<p>Das Gallery-Modul hat eine eigene Funktion zum Hochladen von Bildern. Für den Auswahl-Dialog via Ctrl/Shift zum Hochladen mehrerer Bilder wird das Plupload Bibliothek verwendet. Damit dies funktioniert, muss für Ihren Browser HTML unterstützen oder ein aktuelles Flash Player plugin installiert sein.</p>
<p>Um das Hochladen sehr großer Bilder zu verhindern, können Sie in der Registerkarte "Optionen" eine maximale Größe festlegen, die hochgeladen werden darf. Größere Bilder werden vor dem Hochladen entsprechend Ihren Vorgaben skaliert. Die Proportionen der Bilder bleiben dabei unverändert.</p>

<h3>Benutzerdefinierte Felder</h3>
<p>Für das Gallery-Modul lassen sich verschiedene, benutzerdefinierte Felder festlegen. Ein benutzerdefiniertes Feld kann auch für eine untergeordnete Galerie oder ein einzelnes Bild festgelegt werden.</p>
<p>Benutzerdefinierte Felder können im Gallery-Template direkt mit <code>{$fields.ihr_feld_alias.name}</code> und <code>{$fields.ihr_feld_alias.value}</code> aufgerrufen werden. Sie können auch eine foreach-Schleife auf <code>{$fields}</code> erstellen.</p>
<p>Benutzerdefinierte Felder für einzelne Bilder oder untergeordnete Galerien können innerhalb der $images-foreach-Schleife im Gallery-Template mit <code>{$image->fields.ihr_feld_alias.name}</code> and <code>{$image->fields.ihr_feld_alias.value}</code> aufgerufen werden.</p

<h3>Bearbeiten, Im- und Exportieren von Gallery-Templates</h3>
<p>Um Templates bearbeiten zu können, müssen die entsprechenden Benutzer Mitglieder einer Gruppe mit der Berechtigung \'Modify Templates\' sein.</p>
<p>Gallery-Templates können separat von der <a href="http://dev.cmsmadesimple.org/project/files/726" target="_blank">Gallery-Modul-Projektseite</a> heruntergeladen werden. Wenn der Name des Templates bereits vorhanden ist und das entsprechende Kontrollfeld aktiviert ist, wird dieses beim Import überschrieben. Bitte beachten Sie, dass eine Aktualisierung des Gallery-Moduls keinerlei Auswirkungen auf Ihre Modul-Templates hat.</p>
<p>Wenn Sie eigene Templates erstellen und diese exportieren wollen, achten Sie darauf, dass sich alle benötigten Dateien (genau wie die voreingestellten Templates) in einem eigenen Verzeichnis mit dem Template-Namen im Verzeichnis <em>assets/modules/Gallery/templates/</em> befinden. Diese Dateien werden dann automatisch der XML-Datei hinzugefügt. Klicken Sie auf den Link \'Über\', um die Versionsnummer und den Infotext zu bearbeiten.</p>
<p>Im Template-Listenfeldmenü können Templates als unsichtbar definiert werden, so dass diese Templates von normalen Administratoren nicht ausgewählt werden können, sondern nur von Benutzern, die die Berechtigung \'Modify Templates\' haben.</p>

<h3>Globale Gallery-Optionen</h3>
<p>Um die globalen Gallery-Options bearbeiten zu können, müssen die jeweiligen Benutzer Mitglieder einer Gruppe mit der Berechtigung \'Modify Site Preferences\' sein.</p>

<h3>Support</h3>
<p>Dieses Modul beinhaltet keinen kommerziellen Support. Sie können jedoch über folgende Möglichkeiten Hilfe zu dem Modul erhalten:</p>
<ul>
<!-- li>FAQs, weitere Hilfe und Troubleshooting kann man finden in <a href="http://wiki.cmsms.nl/index.php/Gallery">Gallery Wiki Documentation</a>.</li -->
<li>Für die letzte Version dieses Moduls, dem Versand eines Fehlerreports oder Bugreports besuchen Sie bitte die <a href="http://dev.cmsmadesimple.org/projects/gallery/">Projektseite</a> im CMSms Forge.</li>
<li>Weitere Diskussionen zu diesem Modul sind auch in den Foren von <a href="http://forum.cmsmadesimple.org">CMS Made Simple</a> zu finden.</li>
<li>Letztlich erreichen Sie den Autor auch über eine direkte Email.</li>
</ul>
<p>Nach der GPL wird diese Software so veröffentlicht, wie sie ist. Bitte lesen Sie den Lizenztext für den vollen Haftungsausschluss.</p>

<h3>Feedback</h3>
<p>If you enjoy this module, use it on a commercial website or would like to encourage future development, you might consider just a small donation.<br />Or leave a message in the <a href="http://forum.cmsmadesimple.org/viewtopic.php?t=41780">Gallery forum topic</a>. Any kind of feedback will be much appreciated.</p>';
?>