<?php
// A
$lang['admindescription'] = 'A full featured WYSIWYG-editor providing file management and image management functionality';
$lang['advanced_menu'] = 'Advanced menu';
$lang['apply'] = 'Apply';
$lang['autoresize'] = 'Auto resize';

// B
$lang['block_formats'] = 'Available formats';
$lang['button_name'] = 'Button name';

// C
$lang['cancel'] = 'Cancel';
$lang['cmsms_linker'] = 'Link to content page';
$lang['contextmenu'] = 'Context menu';
$lang['contextmenu_content'] = 'Context menu content';
$lang['copy'] = 'copy';
$lang['copy_profile'] = 'Copy profile';
$lang['css_classes'] = 'CSS classes';
$lang['css_editor_render'] = 'CSS editor render';
$lang['css_files'] = '... or CSS files';
$lang['css_files_info'] = 'One file per line, relative to the CMSMS website root path. Ex: <em>assets/css/styles.css</em>';
$lang['custom_dropdown'] = 'Custom dropdown';
$lang['custom_dropdown_title'] = 'Custom dropdown title';

// D
$lang['default'] = 'Default';
$lang['default_designmanager_template'] = 'Default template from the DesignManager';
$lang['default_profile_set'] = 'Default profile successfully changed';
$lang['delete_profile'] = 'Delete profile';
$lang['delete_profile_confirm']='Are you sure this profile should be deleted?';
$lang['design_css'] = 'Design to use for CSS stylesheets';
$lang['documentation'] = 'Documentation';

// E
$lang['edit_profile'] = 'Edit profile';
$lang['enable_custom_dropdown'] = 'Enable custom dropdown';
$lang['enable_linker'] = 'Load the CMSMS linker plugin (links to content pages)';
$lang['enable_user_templates'] = 'Enable user templates';
$lang['error_delete_profile'] = 'An error occurred during the delete process';
$lang['error_cannot_delete_default_profile'] = 'Error: the default profile cannot be deleted';
$lang['error_saving_profile'] = 'An error occurred during the save process';
$lang['external_modules'] = 'External modules';
$lang['external_modules_show_menutext'] = 'Show the button text on the toolbar - unchecked = icon only';
$lang['extra_js'] = 'Extra JavaScript options for the init script';

// F
$lang['filemanager'] = 'File manager';
$lang['filemanager_tui_active'] = 'Enable the TUI photo editor';
$lang['filemanager_chmod_dirs'] = 'CHMOD directories';
$lang['filemanager_chmod_files'] = 'CHMOD files';
$lang['filemanager_copy_cut_dirs'] = 'Copy and cut directories';
$lang['filemanager_copy_cut_files'] = 'Copy and cut files';
$lang['filemanager_create_folders'] = 'Create folders';
$lang['filemanager_create_text_files'] = 'Create text files';
$lang['filemanager_delete_files'] = 'Delete files';
$lang['filemanager_delete_folders'] = 'Delete folders';
$lang['filemanager_duplicate_files'] = 'Duplicate files';
$lang['filemanager_edit_text_files'] = 'Edit text files';
$lang['filemanager_image_resizing'] = 'Automatically resize images after upload';
$lang['filemanager_image_resizing_title'] = 'Automatic image resizing';
$lang['filemanager_image_resizing_height'] = 'Max image height after resizing';
$lang['filemanager_image_resizing_width'] = 'Max image width after resizing';
$lang['filemanager_photo_editor'] = 'Image editor';
$lang['filemanager_preview_text_files'] = 'Preview text files';
$lang['filemanager_rename_files'] = 'Rename files';
$lang['filemanager_rename_folders'] = 'Rename folders';
$lang['filemanager_upload_files'] = 'Upload files';
$lang['filemanager_options'] = 'File manager options';
$lang['filemanager_use'] = 'Enable the file manager';
$lang['friendlyname'] = 'TinyMCE WYSIWYG editor';
$lang['forced_root_block'] = 'Force paragraph on line break';

// G
$lang['general'] = 'General';
$lang['global_settings'] = 'Global settings';
$lang['group_frontend'] = 'Frontend users';

// H
$lang['help_advanced_menu'] = 'If you are looking for an advanced menu customization, your can turn this option on. Edit the menu entries in the field below. Using that option will disable the standard menu.';
$lang['help_autoresize'] = 'Enable the <em>autoresize</em> plugin to automatically resize the editor height according to the content size';
$lang['help_cmsms_linker'] = 'Enable the <em>cmsms_linker</em> plugin to easily insert links to other content pages. If you need this tool in your Menu, you must use the <em>Advanced menu</em> in the <em>Menubar</em> tab, and add <em>cmsms_linker</em> in the right section';
$lang['help_tui_editor'] = 'TUI image editor is a full-featured image editor that comes with crop, resize, text, shape tools, and some filters. More about it: <a href="https://ui.toast.com/tui-image-editor/" target="_blank">https://ui.toast.com/tui-image-editor/</a>';
$lang['help_css_files'] = 'Here you can give a list of CSS files to be included in TinyMCE. This option will only work if the {content} tag has not a <em>cssname</em> parameter, and if there is no <em>Design</em> selected.<br>Please write one css file per line, with a path relative to the CMSMS root directory.';
$lang['help_design_css'] = 'TinyMCE can load a set of stylesheets from a design defined in the Design Manager in order to improve the visual experience. Note that if the {content} tag has a <em>cssname</em> parameter, this preference will be ignored in the default JS template (but you can create a new JS template to change that behavior).<br><br><strong>Important:</strong> if you\'re using that feature, you must clear the CMS cache after every stylesheet change in order to see it in TinyMCE.';
$lang['help_enable_custom_dropdown'] = 'Adds a special button so the editors can add some snippets (Smarty tags or not) to their content. Don\'t forget to add the <em><strong>customdropdown</strong></em> button to your toolbar and your custom menubar.';
$lang['help_external_modules'] = 'Some third-party modules can give to TinyMCE a menu to include items. Please select which module should be loaded. Don\'t forget to add the module button to the toolbar if you want it here. The <em>Insert</em> menu will show it too.';
$lang['help_extra_js'] = 'Some JavaScript code you can add to the initialization script to add custom options or behavior. Please separate every option with a comma. Check the TinyMCE configurations options to see what you can use.';
$lang['help_filemanager_image_resizing'] = 'After an image upload, the file manager can automatically resize the image to the desired maximum dimensions. Useful to prevent users from including too big/large images in their pages.';
$lang['help_filemanager_use'] = 'Enable the filemanager - Note that for security reasons, the filemanager will never be loaded on the frontend.<br><br>The file manager will be loaded in the <em>add link</em> and <em>insert image</em> dialogs, but you can add a button to your toolbar too with the button: <em>responsivefilemanager</em>.';
$lang['help_forced_root_block'] = 'This option enables you to make sure that any non block elements or text nodes are wrapped in block (p) elements. For example <strong>something</strong> will result in output like: &lt;p&gt;<strong>something</strong>&lt;/p&gt;.<br><br>If unchecked, the editor will never produce <strong>&lt;p&gt;</strong> tags on enter, only a <strong>&lt;br&gt;</strong>. You will have to use Shift+Enter to produce a <strong>&lt;p&gt;</strong> tag.';
$lang['help_image_classes'] = 'Here you can tell TinyMCE which classes can be applied to an image. The user will be able to choose it from the add/edit image window. This choice will not be mandatory for the user.';
$lang['help_link_classes'] = 'Here you can tell TinyMCE which classes can be applied to a link. The user will be able to choose it from the add/edit link window. This choice will not be mandatory for the user.';
$lang['help_js_template'] = 'The TinyMCE module can use a specific JavaScript template. This is useful if you want to completely customize the JavaScript that configures TinyMCE.<br><br>If you want to follow the latest JS configuration template shipped with the module, select the <em>Original template shipped with the module</em>.<br><br>If you are a developer, your can change this parameter to use a template from the DesignManager and customize it. Be aware that you may have to edit your custom JS configuration on a new module release to use new features.';
$lang['help_menubar'] = 'Set which menus are displayed to the editor, and in which position. Take a look at the documentation to see which options you can use.';
$lang['help_plugins'] = 'TinyMCE can include external plugins to extend its functions. Before adding any button to the menu or toolbar, you may have to include it here. Note that the <em>cmsms_linker</em>, <em>template</em>, <em>contextmenu</em> and <em>responsivefilemanager</em> plugins are automatically included.<br>Read the documentation to get a complete list of available plugins.';
$lang['help_priority'] = 'This parameter is used to choose which profile has the priority when a user is in multiple user groups that have various TinyMCE profiles. Lower is better.<br><br>For instance: user 1 is linked to  groups A and C. Group A has the TinyMCE profile Y, group C the Z. The profile the user will get when using TinyMCE is the one that has the lower priority number between Y and Z.';
$lang['help_relative_urls'] = 'If checked, all the images/files urls will be defined relative to the root url (example: <em>/uploads/images/myimage.jpg</em>).<br><br>If unchecked, the root url will always be included in the source code (example: <em>http://www.my-website.com/uploads/images/myimage.jpg</em>).';
$lang['help_show_statusbar'] = 'Show or hide the editor statusbar. Please note that enabling the resize function will force the statusbar to be shown.';
$lang['help_style_formats'] = 'The editor users can insert formatted tags to content with the <em>Formats</em> dropdown menu. Here you can define which style will be available in the dropdown. Note that this will not define any visual styles for CSS classes, only give the class name the tag. You must add the proper CSS rules in your CSS file(s) to get a visual render. Take a look at the TinyMCE documentation to configure that option.<br><br>Don\'t forget to add the <em><strong>styleselect</strong></em> button to your toolbar if you want it here';

$lang['help_toolbar'] = 'Define all the buttons you want to be displayed on the toolbar (the icons bar). Note that you will need to load the appropriate plugins for some buttons.';
$lang['help_use_custom_block_formats'] = 'Customize the formats dropdown to give your users only the formats you want them to use. This will only work with the <em>formatselect</em> button, and with block-level tag types (h1..6, div, pre, ...)';
$lang['help_user_templates'] = 'User templates are HTML templates/blocks that TinyMCE users can easily include in the content using the <em>template</em> plugin. You can create as many user templates as you want in the CMSMS Design Manager (template type: <em>TinyMCE user template</em>) and/or as files in a specific directory (see below).<br><br>Once enabled, don\'t forget to add the <em>template</em> button to you toolbar, if needed. It will be automatically added to the menubar.';
$lang['help_user_templates_files_dir'] = 'If you want to use file templates, fill that field with the path of the directory containing those templates (extension .tpl). Relative to the CMS root dir.<br>Ex: <em>assets/tinymce_templates</em>';
$lang['help_usergroups'] = 'Select which user groups will use the current TinyMCE profile. Note that selecting a user group that is currently linked to another profile will remove the current association. If no profile is found for a user group, the default profile will be used.';

// I
$lang['id'] = 'ID';
$lang['image_advtab'] = 'Enable the advanced tab for images (style, spacing, border)';
$lang['image_classes'] = 'CSS classes that can be used for images';
$lang['image_classes_info'] = 'One class per line, example: <code><em>Bordered image=bordered border-round</em></code>';
$lang['image_plugin'] = 'Image plugin options';
$lang['info_linker_autocomplete'] = 'This is an auto complete field. Begin by typing a few characters of the desired page alias, menu text, or title. Any matching items will be displayed in a list.';
$lang['install_profile_admin'] = 'Administrators';
$lang['install_profile_advanced'] = 'Advanced';
$lang['install_profile_frontend'] = 'Frontend';
$lang['install_profile_minimal'] = 'Minimal';
$lang['install_profile_standard'] = 'Standard';

// J
$lang['js_template'] = 'JavaScript template';

// L
$lang['link_classes'] = 'CSS classes that can be used for links';
$lang['link_classes_info'] = 'One class per line, example: <code><em>Blue button=btn btn-blue</em></code>';
$lang['loading_info'] = 'Loading...';

// M
$lang['menubar'] = 'Menubar';

// N
$lang['name'] = 'Name';
$lang['new_profile'] = 'Create a new profile';
$lang['newwindow'] = 'New window';
$lang['no_design_linked'] = 'No design';
$lang['none'] = 'None';

// O
$lang['orig_js_template_file'] = 'Original template shipped with the module';

// P
$lang['plugins'] = 'Plugins';
$lang['postinstall'] = 'The TinyMCE editor has been successfully installed. <strong>Important:</strong> if you\'re using URL Rewriting, please update your .htaccess file (see the TinyMCE help page)';
$lang['priority'] = 'Priority';
$lang['profile_copied'] = 'The profile has been successfully duplicated';
$lang['profile_deleted'] = 'The profile has been successfully deleted';
$lang['profile_name'] = 'Profile name';
$lang['profile_saved'] = 'Profile successfully saved';
$lang['profiles'] = 'Profiles';
$lang['prompt_href'] = 'Generated URL';
$lang['prompt_linker'] = 'Enter Page title';
$lang['prompt_profiles'] = 'Profiles';
$lang['prompt_selectedalias'] = 'Selected Page alias';
$lang['prompt_name'] = 'Name';
$lang['prompt_target'] = 'Target';
$lang['prompt_class'] = 'Class attribute';
$lang['prompt_rel'] = 'Rel attribute';
$lang['prompt_texttodisplay'] = 'Text to display';

// R
$lang['relative_urls'] = 'Use relative URLs';
$lang['resize'] =' Resize';
$lang['resize_no'] = 'Do not allow to resize';
$lang['resize_vertical'] = 'Allow vertical resizing';
$lang['resize_both'] = 'Allow vertical and horizontal resizing';

// S
$lang['show_menubar'] = 'Show menubar';
$lang['show_statusbar'] = 'Show statusbar';
$lang['show_toolbar'] = 'Show toolbar';
$lang['style_formats'] = 'Style formats';
$lang['style_formats_info'] = 'One rule per line, example: <code><em>title: \'Red title\', block: \'h2\', classes: \'text-red\'</em></code>';
$lang['subhelp_contextmenu_content'] = 'Syntax: <em> link image imagetools | table inserttable cell row column deletetable | bold italic</em><br><br><em>Note: the browsers native context menu can still be accessed by holding the Ctrl key while right clicking with the mouse.</em>';
$lang['subhelp_custom_block_formats'] = 'Syntax: <em>Paragraph=p;Header 1=h1;Header 2=h2</em>';
$lang['subhelp_toolbar'] = 'Syntax: <em>undo redo | cut copy paste | bold italic</em><br>Special CMSMS buttons: <em>customdropdown</em>, <em>cmsms_linker</em>, <em>responsivefilemanager</em>';
$lang['subhelp_custom_dropdown'] = 'Syntax: <em>Item title|content to add</em> or <em>Item title|opening content|end content</em> to add <em>opening content</em> before selection, and <em>end content</em> after it.<br>Don\'t forget to add <em><strong>customdropdown</strong></em> to your toolbar buttons and your custom menubar';
$lang['submit'] = 'Submit';

// T
$lang['tab_general_title'] = 'General';
$lang['tab_advanced_title'] = 'Advanced';
$lang['template'] = 'Template';
$lang['templates'] = 'Templates';
$lang['title_cmsms_linker'] = 'Create a link to a content page';
$lang['toolbar'] = 'Toolbar';
$lang['toolbar1'] = 'Toolbar - 1st line';
$lang['toolbar2'] = 'Toolbar - 2nd line';
$lang['tooltip_selectedalias'] = 'This field is read only';
$lang['type_TinyMCE'] = 'TinyMCE';
$lang['type_js'] = 'JavaScript';
$lang['type_js_description'] = 'JavaScript script that runs TinyMCE - Using a template gives you full control to completely customize TinyMCE for each profile. Please take a look at the TinyMCE documentation (https://www.tinymce.com/docs/) to see how to edit that script.';
$lang['type_usertemplate'] = 'TinyMCE user template';
$lang['type_usertemplate_description'] = 'You can use that type of template to create many HTML blocks the TinyMCE users can include in their content through the <em>templates</em> TinyMCE plugin';

// U
$lang['use_advanced_menu'] = 'Use advanced menu';
$lang['use_custom_block_formats'] = 'Use a custom formats dropdown';
$lang['usergroups'] = 'Users groups';
$lang['user_templates_files_dir'] = 'Directory containing the user templates';



$lang['help'] =  <<<EOT

<h3>What Does This Do?</h3>
<p>
	This module embeds the full TinyMCE WYSIWYG editor version in CMS Made Simple. It works with content blocks in CMSMS content pages (when a WYSIWYG has been allowed), in module Admin forms where WYSIWYG editors are allowed, and allows restricted capabilities for editing html blocks on frontend pages.
</p>
<p>In order for TinyMCE to be used as the WYSIWYG editor in the Admin console the TinyMCE WYSIWYG Editor needs to be selected in the users preferences.  Please select &quot;TinyMCE&quot; in the &quot;Select WYSIWYG to Use&quot; option under &quot;My Preferences &gt;&gt; User Preferences&quot; in the CMSMS Admin panel.  Additional options in various modules or in content page templates, and content pages themselves can control whether a text area or a WYSIWYG field is provided in various edit forms.</p>
<p>For Frontend editing capabilities TinyMCE must be selected as the &quot;Frontend WYSIWYG&quot; in the global settings page of the CMSMS admin console.</p>

<h3>Features:</h3>
<ul>
	<li>Full native <a href="http://www.tinymce.com" target="_blank">TinyMCE editor</a> is available.</li>
	<li>Configuration profiles and backend groups attribution.</li>
	<li>Lots of customization options: toolbar, menubar, external modules, custom styles, ...</li>
	<li>Uses the internal page linker from the MicroTiny module.</li>
	<li>Embeds the powerful <a href="http://www.responsivefilemanager.com/" target="_blank">Responsive File Manager</a> thanks to its author Alberto Peripolli. Note: for security reasons, the Responsive File Manager will not be available to the frontend users</li>
	<li>Ability to use an external javascript template file from the DesignManager instead of the stock JS file - This permits a complete customization of the init script.</li>
	<li>Customizable appearance by specifying a design to use for the editor.</li>
</ul>

<h3>How do I use it</h3>
<ul>
	<li>Install and configure the module</li>
	<li><strong style="color: red">Important:</strong> if you're using URL Rewriting, you must update your .htaccess file and replace:
		<ul>
			<li><code>RedirectMatch 403 ^.*/modules/(.*)\.php</code>$&nbsp;with:</li>
			<li><code>RedirectMatch 403 ^.*/modules/(?!TinyMCE/responsive_filemanager/filemanager/).*\.php$</code></li>
			<li>... in order to make the Responsive File Manager work - If you already did some changes on that line, please update the rule accordingly</li>
		</ul>
	</li>
	<li>Create and configure the appropriate profiles in <em>Extensions</em> / <em>TinyMCE WYSIWYG editor</em></li>
	<li>Don't forget to link profiles with backend user groups (or frontend) in the TinyMCE profile</li>
	<li>Set TinyMCE as your WYSIWYG editor of choice in &quot;My Preferences&quot;</li>
</ul>

<p>
	Note about profile edition: the backend user <strong>must have</strong> the <em>Manage TinyMCE profiles</em> permission to get the TinyMCE Admin page.
</p>

<h3>Caching:</h3>
<p>In an effort to improve performance, TinyMCE will attempt to cache the generated JavaScript files unless something has changed. Saving a profile or clearing the CMS Made Simple cache will always reset the JS cache file.</p>

<h3>Module developers: how to create a new button for your module in TinyMCE?</h3>
<p>
	You must add three functions to your main module class - Example for the Gallery module:
</p>

<code><pre>
	function HasCapability(&#36;capability, &#36;params=array()) {
		if (&#36;capability=='WYSIWYGItems') return true;
		return false;
	}

	function GetWYSIWYGBtnName()
	{
		return 'module_gallery';
	}

	function GetWYSIWYGBtn(&#36;wysiwyg_module)
	{
		// TEST ARRAY EXAMPLE
		&#36;items = array(
			array(
				'menu_text' => 'Gallery 1',
				'content' => "{Gallery dir='dir1'}", // Empty = no action on click
				'children' => array(
					array(
						'menu_text' => 'SubGallery 1.1',
						'content' => "{Gallery dir='subdir11'}"
						'children' => array() // You can have as many sublevels as you need
					),
					array(
						'menu_text' => 'SubGallery 1.2',
						'content' => "{Gallery dir='subdir12'}"
					),
					array(
						'menu_text' => 'SubGallery 1.3',
						'content' => "{Gallery dir='subdir13'}"
					)
				)
			),
			array(
				'menu_text' => 'Gallery 2',
				'content' => "{Gallery dir='dir2'}", // Empty = no action on click
				'children' => array(
					array(
						'menu_text' => 'SubGallery 2.1',
						'content' => "{Gallery dir='subdir21'}"
					),
					array(
						'menu_text' => 'SubGallery 2.2',
						'content' => "{Gallery dir='subdir22'}"
					),
					array(
						'menu_text' => 'SubGallery 2.3',
						'content' => "{Gallery dir='subdir23'}"
					)
				)
			)
		);

		// BUILD THE BUTTON OBJECT USED BY THE TinyMCE MODULE
		if (&#36;wysiwyg_module == 'TinyMCE')
		{
			&#36;obj = new tinymce_modulemenu;
			&#36;obj->module_name = &#36;this->GetName();
			&#36;obj->button_name = &#36;this->GetWYSIWYGBtnName();
			&#36;obj->title = &#36;this->Lang('tinymce_button_picker');
			&#36;obj->tooltip = &#36;this->Lang('tinymce_description_picker');
			&#36;obj->icon = 'image';
			&#36;obj->image = &#36;this->GetModuleURLPath() . '/images/icon.gif';
			&#36;obj->menu_entries = &#36;items;
			&#36;obj->menu_section = 'insert';

			return &#36;obj;
		}
		return false;
	}
</pre></code>

<p>
	The <strong>GetWYSIWYGBtn()</strong> function must return a <strong>tinymce_modulemenu</strong> object with an array <em>menu_entries</em> property.
</p>
<br>

<h3>License informations</h3>
<p>This module is free software - you can use it under the terms of the GNU General Public License 2 or any later version.</p>
<p><strong>However</strong>, the <a href="http://www.responsivefilemanager.com/" target="_blank">Responsive FileManager</a> is licensed under a <a href="http://creativecommons.org/licenses/by-nc/3.0/" target="_blank">Creative Commons Attribution-NonCommercial 3.0 Unported License</a>. The TinyMCE module includes it <strong>with the permission from Alberto Peripolli</strong> given on 2016-01-19. Thank you Alberto! <a href="http://www.responsivefilemanager.com/" target="_blank">If you want to support that project, please check this page and make a free donation.</a></p>

<h3>Help and support</h3>
<p>We tried to explain each configuration option on the profile edition Admin page. Please use the "?" buttons near each option to get more informations.</p>

<h3>Bug report or feature request</h3>
<p>
	Checkout the CMS Made Simple forge: <a href="http://dev.cmsmadesimple.org/projects/tinymce" target="_blank">http://dev.cmsmadesimple.org/projects/tinymce</a>
</p>

<h3>Authors</h3>
<ul>
	<li>Morten Poulsen: <a href="mailto:morten@poulsen.org">morten@poulsen.org</a></li>
	<li>Rolf Tjassens: <a href="mailto:rolf@cmsmadesimple.org">rolf@cmsmadesimple.org</a></li>
	<li>Mathieu Muths: <a href="mailto:contact@airelibre.net">contact@airelibre.net</a></li>
</ul>
EOT;

?>