<?php
// ======================================================
// YÖNETİM PANELİ (Linkleri ve Ayarları Buradan Yönet)
// ======================================================

// Buton Hedef Linkleri (Burayı düzenlemen yeterli)
$link_giris = "https://kullanici-giris-linkin-buraya.com";
$link_kayit = "https://uyelik-kayit-linkin-buraya.com";

// SEO & SERP AYARLARI (Rakiplerden Farklılaşma Stratejisi)
// Standart "Güncel Adres" yerine, "VIP", "Hızlı", "Panel" kelimeleri kullanıldı.
$site_title = "Betnano Giriş - Betnano 2026 Güncel Adresi Yayınlandı!"; 
$site_desc = "Betnano giriş engeline takılmadan 2026 Betnano Adresine Bu Bağlantı Üzerinden Giriş yap Betnano Official Adres Yayında.";

// Link Yapısı
$canonical_url = "https://boristattoo.com/";
$publish_date = date("Y-m-d"); // Otomatik güncel tarih
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo $site_desc; ?>">
    <meta name="robots" content="index, follow">
    <title><?php echo $site_title; ?></title>
    <meta name="google-site-verification" content="Vcmcc5N0rS78LniSVbkb6-M-EfufvY4xRZPKh-xl81g" />
    <link rel="canonical" href="<?php echo $canonical_url; ?>" />
    <link rel="alternate" hreflang="tr" href="https://m.betnanoyagiris-2026.com/">
    <link rel="alternate" hreflang="az" href="https://m.betnanoyagiris-2026.com/">
    <link rel="alternate" hreflang="pt" href="https://m.betnanoyagiris-2026.com/">
    <link rel="alternate" hreflang="uk" href="https://m.betnanoyagiris-2026.com/">
    <link rel="alternate" hreflang="kk" href="https://m.betnanoyagiris-2026.com/">
    <link rel="alternate" hreflang="ar" href="https://m.betnanoyagiris-2026.com/">
    <link rel="alternate" hreflang="ru" href="https://m.betnanoyagiris-2026.com/">
    <link rel="alternate" hreflang="pl" href="https://m.betnanoyagiris-2026.com/">

    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "Organization",
      "name": "Betnano Rehberi",
      "url": "<?php echo $canonical_url; ?>",
      "logo": "https://m.betnanoyagiris-2026.com//logo.png",
      "sameAs": [
        "https://twitter.com/betnano_ornek",
        "https://instagram.com/betnano_ornek"
      ]
    }
    </script>

    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "FAQPage",
      "mainEntity": [{
        "@type": "Question",
        "name": "Betnano giriş yapamıyorum, ne yapmalıyım?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Erişim sorunu yaşıyorsanız tarayıcı önbelleğinizi temizleyin veya sitemizdeki 'Hızlı Giriş' butonlarını kullanarak otomatik yönlendirme servisini kullanın."
        }
      }, {
        "@type": "Question",
        "name": "Betnano kayıt olurken belge istiyor mu?",
        "acceptedAnswer": {
          "@type": "Answer",
          "text": "Hayır, Betnano 2025 üyelik prosedürlerinde standart işlemler için belge talep etmemektedir. Hızlı üyelik formu ile 2 dakikada hesabınızı açabilirsiniz."
        }
      }]
    }
    </script>

    <style>
        /* --- MODERN DEĞİŞKENLER --- */
        :root {
            --gold: #FFD700;
            --gold-glow: rgba(255, 215, 0, 0.4);
            --red: #D90429;
            --dark-red: #8d0000;
            --bg-dark: #020617; /* Daha derin siyah/mavi */
            --bg-glass: rgba(30, 41, 59, 0.7); /* Glassmorphism için */
            --text-light: #f1f5f9;
        }

        body {
            font-family: 'Inter', 'Segoe UI', sans-serif;
            background-color: var(--bg-dark);
            color: var(--text-light);
            margin: 0;
            padding-bottom: 70px; /* Mobil bar için boşluk */
            line-height: 1.6;
        }

        /* --- KAR EFEKTİ (YILBAŞI) --- */
        .snowflake { position: fixed; top: -10px; z-index: 1; color: rgba(255,255,255,0.2); animation: fall linear forwards; pointer-events: none; }
        @keyframes fall { to { transform: translateY(105vh); } }

        /* --- HEADER & NAV --- */
        header {
            background: rgba(2, 6, 23, 0.9);
            backdrop-filter: blur(12px); /* Buzlu cam efekti */
            border-bottom: 1px solid rgba(255, 215, 0, 0.15);
            position: sticky;
            top: 0;
            z-index: 1000;
            padding: 15px 0;
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.3);
        }

        .container { max-width: 1200px; margin: 0 auto; padding: 0 20px; display: flex; justify-content: space-between; align-items: center; }

        .logo { font-size: 26px; font-weight: 800; color: #fff; text-decoration: none; letter-spacing: -1px; }
        .logo span { color: var(--gold); }

        .header-actions { display: flex; gap: 15px; }

        /* --- BUTON TASARIMLARI --- */
        .btn {
            padding: 10px 24px;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 700;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        /* Giriş Butonu (Outline) */
        .btn-login {
            border: 2px solid var(--gold);
            color: var(--gold);
            background: transparent;
        }
        .btn-login:hover { background: var(--gold); color: #000; box-shadow: 0 0 15px var(--gold-glow); }

        /* Kayıt Butonu (Solid & Pulse) */
        .btn-register {
            background: linear-gradient(135deg, var(--red) 0%, var(--dark-red) 100%);
            color: #fff;
            border: none;
            box-shadow: 0 4px 15px rgba(217, 4, 41, 0.4);
            animation: pulse-red 2s infinite;
        }
        .btn-register:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(217, 4, 41, 0.6); }

        @keyframes pulse-red {
            0% { box-shadow: 0 0 0 0 rgba(217, 4, 41, 0.7); }
            70% { box-shadow: 0 0 0 10px rgba(217, 4, 41, 0); }
            100% { box-shadow: 0 0 0 0 rgba(217, 4, 41, 0); }
        }

        /* --- HERO SECTION --- */
        .hero {
            background: radial-gradient(circle at 50% 0%, #2a0a0f 0%, var(--bg-dark) 80%);
            text-align: center;
            padding: 80px 20px;
            position: relative;
            z-index: 2;
        }
        .hero h1 { 
            font-size: 3.5rem; 
            margin-bottom: 15px; 
            background: linear-gradient(to right, #fff, var(--gold)); 
            -webkit-background-clip: text; 
            -webkit-text-fill-color: transparent; 
        }
        .hero p { color: #94a3b8; max-width: 600px; margin: 0 auto 30px; font-size: 1.2rem; }

        /* --- CONTENT GRID --- */
        .layout-grid {
            display: grid;
            grid-template-columns: 2.5fr 1fr;
            gap: 40px;
            margin: 50px auto;
            max-width: 1200px;
            padding: 0 20px;
        }

        /* CARD STİLİ (Glassmorphism) */
        .glass-card {
            background: var(--bg-glass);
            border: 1px solid rgba(255, 255, 255, 0.05);
            border-radius: 16px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }

        h2 { color: var(--gold); font-size: 1.8rem; margin-top: 0; display: flex; align-items: center; gap: 10px; }
        h3 { color: #fff; font-size: 1.4rem; border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 10px; margin-top: 30px; }
        p, li { color: #cbd5e1; }
        
        /* SIDEBAR LİNKLERİ */
        .sidebar-links a {
            display: block;
            padding: 15px;
            margin-bottom: 10px;
            background: rgba(255,255,255,0.03);
            color: #fff;
            text-decoration: none;
            border-radius: 8px;
            border-left: 3px solid transparent;
            transition: 0.3s;
        }
        .sidebar-links a:hover {
            background: rgba(255,215,0,0.1);
            border-left-color: var(--gold);
            padding-left: 20px;
        }

        /* --- MOBİL SABİT BAR (STICKY FOOTER) --- */
        .mobile-bottom-bar {
            position: fixed;
            bottom: 0;
            left: 0;
            width: 100%;
            background: rgba(15, 23, 42, 0.95);
            backdrop-filter: blur(10px);
            border-top: 1px solid rgba(255, 215, 0, 0.2);
            padding: 12px 20px;
            display: none; /* Masaüstünde gizle */
            justify-content: space-between;
            gap: 15px;
            z-index: 9999;
            box-sizing: border-box;
        }
        .mobile-bottom-bar .btn { flex: 1; justify-content: center; padding: 12px; font-size: 1rem; }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            .header-actions { display: none; } /* Header butonlarını gizle */
            .mobile-bottom-bar { display: flex; } /* Alttaki barı göster */
            .layout-grid { grid-template-columns: 1fr; }
            .hero h1 { font-size: 2.2rem; }
        }
    </style>
</head>
<body>

    <script>
        document.addEventListener("DOMContentLoaded", () => {
            for(let i=0; i<25; i++){
                const s = document.createElement("div"); s.className="snowflake"; s.innerHTML="❄";
                s.style.left=Math.random()*100+"vw"; s.style.animationDuration=(Math.random()*3+2)+"s";
                s.style.fontSize=(Math.random()*10+10)+"px"; document.body.appendChild(s);
            }
        });
    </script>

    <header>
        <div class="container">
            <a href="/" class="logo">BETNANO<span>.VIP</span></a>
            
            <div class="header-actions">
                <a href="<?php echo $link_giris; ?>" class="btn btn-login">
                    <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path></svg>
                    Giriş Yap
                </a>
                <a href="<?php echo $link_kayit; ?>" class="btn btn-register">
                    <svg width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24"><path d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path></svg>
                    Kayıt Ol
                </a>
            </div>
        </div>
    </header>

    <section class="hero">
        <div class="container">
            <h1>Betnano: Betnano 2026 Yılı Yenilenen Giriş Adresi</h1>
            <p>Standartlardan sıkılanlar için özel altyapı. Kesintisiz erişim, anlık bakiye yükleme ve %200 Yılbaşı Hoş Geldin bonusu tek bir ekranda.</p>
            <div style="display:flex; justify-content:center; gap:15px; flex-wrap:wrap;">
                 <a href="<?php echo $link_giris; ?>" class="btn btn-login" style="padding:15px 40px; background: rgba(255,215,0,0.1);">Hızlı Giriş</a>
                 <a href="<?php echo $link_kayit; ?>" class="btn btn-register" style="padding:15px 40px;">Hemen Üye Ol</a>
            </div>
        </div>
    </section>

    <div class="layout-grid">
        
        <main>
            <article class="glass-card">
                <h2>
                    <svg width="24" height="24" fill="var(--gold)" viewBox="0 0 24 24"><path d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                    Betnano Giriş: Hızın Yeni Tanımı
                </h2>
                <p>2025 yılına girerken bahis severlerin en büyük talebi "hız" oldu. <strong>Betnano giriş</strong> altyapısı, bu talebe yanıt vererek sayfa yüklenme sürelerini milisaniyelere indirdi. Artık VPN açmakla veya DNS değiştirmekle uğraşmadan, sitemiz üzerindeki akıllı butonları kullanarak doğrudan hesabınıza erişebilirsiniz.</p>
                <p>Güvenlik protokolleri, sadece giriş aşamasında değil, oyun içi deneyimde de devrede. VIP panel teknolojisi sayesinde verileriniz uçtan uca şifrelenir.</p>

                <h3>Mobil Uygulama vs. Mobil Giriş</h3>
                <p>Kullanıcıların sıkça ikilemde kaldığı "Uygulama mı indireyim, tarayıcıdan mı gireyim?" sorusuna Betnano son noktayı koydu. Yeni nesil responsive tasarım sayesinde, <em>Betnano güncel adresi</em> üzerinden yaptığınız girişler, native uygulama performansı sunar. Telefon hafızasını doldurmadan, Safari veya Chrome üzerinden tek tıkla casinodasınız.</p>

                <div style="background: rgba(217, 4, 41, 0.1); border-left: 4px solid var(--red); padding: 15px; margin: 20px 0;">
                    <strong>🔥 Editörün Tavsiyesi:</strong> Yılbaşı gecesi yoğunluktan etkilenmemek için hesabınızı şimdiden doğrulayın ve "Betnano Kayıt Ol" butonu üzerinden VIP statüsüne geçiş yapın.
                </div>
            </article>

            <article class="glass-card">
                <h2>Finansal İşlemlerde Şeffaflık</h2>
                <p>Betnano, sadece oyun çeşitliliğiyle değil, finansal gücüyle de sektörde fark yaratıyor. Para yatırma ve çekme işlemlerinde 2025 yılına özel olarak limitler esnetildi.</p>
                <ul>
                    <li><strong>Papara & Payfix:</strong> 7/24 Anında işlem.</li>
                    <li><strong>Kripto (USDT):</strong> Gizlilik odaklı ve komisyonsuz.</li>
                    <li><strong>Havale/EFT:</strong> 5 Dakika içinde bakiyeniz hesabınızda.</li>
                </ul>
            </article>
        </main>

        <aside>
            <div class="glass-card">
                <h3 style="margin-top:0; color:var(--gold)">🚀 Hızlı İşlemler</h3>
                <div class="sidebar-links">
                    <a href="<?php echo $link_giris; ?>">» Şifremi Unuttum</a>
                    <a href="<?php echo $link_giris; ?>">» Canlı Destek (7/24)</a>
                    <a href="<?php echo $link_kayit; ?>">» Bonus Talep Et</a>
                    <a href="<?php echo $link_giris; ?>">» TV İzle (Maç Yayını)</a>
                </div>
            </div>

            <div class="glass-card" style="text-align:center; border:1px solid var(--red);">
                <div style="font-size:3rem;">🎁</div>
                <h3 style="margin-top:10px; border:none; color:var(--text-light)">Yılbaşı Çekilişi</h3>
                <p style="font-size:0.9rem;">Büyük ikramiye sahibini arıyor. Üye ol, biletini kap!</p>
                <a href="<?php echo $link_kayit; ?>" class="btn btn-register" style="width:100%; justify-content:center; box-sizing:border-box;">Katıl</a>
            </div>
        </aside>

    </div>

    <div class="mobile-bottom-bar">
        <a href="<?php echo $link_giris; ?>" class="btn btn-login">Giriş Yap</a>
        <a href="<?php echo $link_kayit; ?>" class="btn btn-register">Kayıt Ol</a>
    </div>

    <footer style="text-align:center; padding:40px; background:rgba(0,0,0,0.5); font-size:0.8rem; color:#666;">
        <p>Copyright © 2025 Betnano Destek Hizmetleri. Sitemizdeki bilgiler kullanıcı deneyimini artırmak amaçlıdır.</p>
    </footer>

</body>
</html>